/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.exceptions;

public class TemplateAssertionException
extends RuntimeException {
    private static final long serialVersionUID = -2261382147273524844L;
    private static final String ASSERTION_MESSAGE = "Assertion '%s' not valid in template '%s'";
    private static final String ASSERTION_MESSAGE_LINE_COL = "Assertion '%s' not valid in template '%s', line %d col %d";

    public TemplateAssertionException(String assertionExpression, String templateName, int line, int col) {
        super(TemplateAssertionException.createMessage(assertionExpression, templateName, line, col));
    }

    public TemplateAssertionException(String assertionExpression, String templateName) {
        super(TemplateAssertionException.createMessage(assertionExpression, templateName, null, null));
    }

    private static String createMessage(String assertionExpression, String templateName, Integer line, Integer col) {
        if (line == null || col == null) {
            return String.format(ASSERTION_MESSAGE, assertionExpression, templateName);
        }
        return String.format(ASSERTION_MESSAGE_LINE_COL, assertionExpression, templateName, line, col);
    }
}

