/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DebugCounter;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectSupport;
import com.oracle.truffle.api.object.ExtAllocator;
import com.oracle.truffle.api.object.ExtLayout;
import com.oracle.truffle.api.object.ExtLayoutStrategy;
import com.oracle.truffle.api.object.ExtLocation;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LayoutImpl;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationImpl;
import com.oracle.truffle.api.object.Obsolescence;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.PropertyMap;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.object.ShapeExt;
import com.oracle.truffle.api.object.ShapeImpl;
import com.oracle.truffle.api.object.Transition;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graalvm.collections.Pair;

final class ObsolescenceStrategy
extends ExtLayoutStrategy {
    private static final DebugCounter makeSuccessorShapeCount = DebugCounter.create("Rebuild shape count");
    private static final DebugCounter reshapeCount = DebugCounter.create("Reshape count");
    private static final int TRACE_RESHAPE_LIMIT = 500;
    private static final Error STACK_OVERFLOW_ERROR = new NonrecoverableError();
    private static final ObsolescenceStrategy SINGLETON = new ObsolescenceStrategy();

    private ObsolescenceStrategy() {
    }

    static ObsolescenceStrategy singleton() {
        return SINGLETON;
    }

    @Override
    protected boolean updateShape(DynamicObject object) {
        boolean changed = this.checkForObsoleteShapeAndMigrate(object);
        return changed;
    }

    @Override
    protected ShapeImpl ensureValid(ShapeImpl newShape) {
        ShapeImpl nextShape = newShape;
        if (!nextShape.isValid()) {
            nextShape = this.getObsoletedBy(nextShape);
        }
        return nextShape;
    }

    @Override
    protected ShapeImpl ensureSpace(ShapeImpl shape, Location location) {
        Objects.requireNonNull(location);
        assert (ObsolescenceStrategy.assertLocationInRange(shape, location));
        return shape;
    }

    @Override
    protected ShapeImpl definePropertyGeneralize(ShapeImpl oldShape, Property oldProperty, Object value, int putFlags) {
        return super.definePropertyGeneralize(oldShape, oldProperty, value, putFlags);
    }

    @Override
    protected ShapeImpl generalizeProperty(Property oldProperty, Object value, ShapeImpl oldShape, ShapeImpl newShape, int putFlags) {
        if (oldShape.isShared() || oldProperty.getLocation().isValue()) {
            return super.generalizeProperty(oldProperty, value, oldShape, newShape, putFlags);
        }
        if (oldShape == newShape) {
            return this.generalizeHelper(oldProperty, value, oldShape, putFlags);
        }
        return ObsolescenceStrategy.generalizeHelperWithShape(oldProperty, value, oldShape, newShape, putFlags);
    }

    @Override
    protected ShapeImpl generalizePropertyWithFlags(ShapeImpl oldShape, Property oldProperty, Object value, int propertyFlags, int putFlags) {
        if (oldShape.isShared() || oldProperty.getLocation().isValue()) {
            return super.generalizePropertyWithFlags(oldShape, oldProperty, value, propertyFlags, putFlags);
        }
        ShapeImpl generalizedShape = this.generalizeHelper(oldProperty, value, oldShape, putFlags);
        Property generalizedProperty = generalizedShape.getProperty(oldProperty.getKey());
        Property propertyWithFlags = Property.create(oldProperty.getKey(), generalizedProperty.getLocation(), propertyFlags);
        return this.replaceProperty(generalizedShape, generalizedProperty, propertyWithFlags);
    }

    @Override
    protected ShapeImpl replaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        if (shape.isShared() || oldProperty.getLocation().isValue()) {
            return this.directReplaceProperty(shape, oldProperty, newProperty);
        }
        return this.indirectReplaceProperty(shape, oldProperty, newProperty);
    }

    private ShapeImpl indirectReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        assert (!shape.isShared());
        assert (oldProperty.getKey().equals(newProperty.getKey()));
        Object key = newProperty.getKey();
        Transition.IndirectReplacePropertyTransition replacePropertyTransition = new Transition.IndirectReplacePropertyTransition(oldProperty, newProperty);
        shape.onPropertyTransition(replacePropertyTransition);
        ShapeImpl cachedShape = shape.queryTransition(replacePropertyTransition);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl root = shape.getRoot();
        ArrayList<Transition> transitionList = new ArrayList<Transition>();
        ShapeImpl newParent = null;
        for (ShapeImpl oldParent = shape; oldParent != root; oldParent = oldParent.getParent()) {
            Transition.DirectReplacePropertyTransition replaceTransition;
            Transition transition = oldParent.getTransitionFromParent();
            if (transition instanceof Transition.AddPropertyTransition) {
                if (((Transition.AddPropertyTransition)transition).getPropertyKey().equals(key)) {
                    newParent = this.applyTransition(oldParent.getParent(), this.newAddPropertyTransition(newProperty), false);
                    break;
                }
            } else if (transition instanceof Transition.DirectReplacePropertyTransition && (replaceTransition = (Transition.DirectReplacePropertyTransition)transition).getPropertyKey().equals(key)) {
                newParent = this.applyTransition(oldParent.getParent(), new Transition.DirectReplacePropertyTransition(replaceTransition.getProperty(), newProperty), false);
                break;
            }
            transitionList.add(transition);
        }
        if (newParent == null) {
            throw new IllegalArgumentException("property not found");
        }
        ShapeImpl newShape = newParent;
        boolean obsolete = false;
        ListIterator iterator = transitionList.listIterator(transitionList.size());
        while (iterator.hasPrevious()) {
            if (!newShape.isValid()) {
                obsolete = true;
            }
            Transition transition = (Transition)iterator.previous();
            newShape = this.applyTransition(newShape, transition, false);
            assert (!(transition instanceof Transition.AddPropertyTransition) || ((Transition.AddPropertyTransition)transition).getProperty().equals(newShape.getLastProperty()));
            if (!obsolete || !newShape.isValid()) continue;
            newShape.invalidateValidAssumption();
        }
        newShape = shape.addIndirectTransition(replacePropertyTransition, newShape);
        Property actualProperty = newShape.getProperty(key);
        this.ensureSameTypeOrMoreGeneral(actualProperty, newProperty);
        return newShape;
    }

    @Override
    protected ShapeImpl.BaseAllocator createAllocator(ShapeImpl shape) {
        return new AllocatorImpl(shape);
    }

    @Override
    protected ShapeImpl.BaseAllocator createAllocator(LayoutImpl layout) {
        return new AllocatorImpl(layout);
    }

    private ShapeImpl getObsoletedBy(ShapeImpl shape) {
        if (shape.isValid()) {
            return null;
        }
        assert (!shape.isShared());
        ShapeImpl ret = ((ShapeExt)shape).getSuccessorShape();
        while (ret == null || !ret.isValid()) {
            if (ret != null) {
                ShapeImpl next = ((ShapeExt)ret).getSuccessorShape();
                assert (ret != next);
                ret = next;
                continue;
            }
            ret = this.makeSuccessorShape(shape);
            Obsolescence.setObsoletedBy(shape, ret);
            break;
        }
        return ret;
    }

    private void reshape(DynamicObject store) {
        CompilerAsserts.neverPartOfCompilation();
        reshapeCount.inc();
        ShapeImpl oldShape = (ShapeImpl)store.getShape();
        assert (!oldShape.isValid() && !oldShape.isShared());
        ArrayDeque<ShapeImpl> affectedShapes = new ArrayDeque<ShapeImpl>();
        ShapeImpl goodAncestor = oldShape;
        while (!goodAncestor.isValid()) {
            affectedShapes.addFirst(goodAncestor);
            goodAncestor = goodAncestor.getParent();
        }
        ShapeImpl offendingShape = (ShapeImpl)affectedShapes.removeFirst();
        ShapeImpl obsoletedBy = this.getObsoletedBy(offendingShape);
        if (ExtLayout.TraceReshape) {
            ObsolescenceStrategy.out().printf("RESHAPE\nGOOD ANCESTOR: %s\nOFFENDING SHAPE: %s\nOBSOLETED BY: %s\n", goodAncestor.toStringLimit(500), offendingShape.toStringLimit(500), obsoletedBy.toStringLimit(500));
        }
        ShapeImpl newShape = obsoletedBy;
        for (ShapeImpl affectedShape : affectedShapes) {
            Transition transition = affectedShape.getTransitionFromParent();
            newShape = this.applyTransition(newShape, transition, true);
        }
        List<Object> toCopy = ObsolescenceStrategy.prepareCopy(store, oldShape, newShape);
        try {
            ObsolescenceStrategy.resizeStore(store, oldShape, newShape);
            ObsolescenceStrategy.performCopy(store, toCopy);
            DynamicObjectSupport.setShapeWithStoreFence(store, newShape);
            assert (store.getShape() == newShape);
        }
        catch (StackOverflowError e) {
            throw STACK_OVERFLOW_ERROR;
        }
        if (ExtLayout.TraceReshape) {
            while (!goodAncestor.isValid()) {
                goodAncestor = goodAncestor.getParent();
            }
            ObsolescenceStrategy.out().printf("OLD %s\nNEW %s\nLCA %s\nDIFF %s\n---\n", oldShape.toStringLimit(500), newShape.toStringLimit(500), goodAncestor.toStringLimit(500), ObsolescenceStrategy.diffToString(oldShape, newShape));
        }
        assert (ObsolescenceStrategy.checkExtensionArrayInvariants(store, newShape));
    }

    private static void resizeStore(DynamicObject store, ShapeImpl oldShape, ShapeImpl newShape) {
        DynamicObjectSupport.resize(store, oldShape, newShape);
    }

    static boolean checkExtensionArrayInvariants(DynamicObject store, ShapeImpl newShape) {
        assert (store.getShape() == newShape);
        Object[] objectArray = store.getObjectStore();
        assert (objectArray == null && newShape.getObjectArrayCapacity() == 0 || objectArray != null && objectArray.length == newShape.getObjectArrayCapacity());
        if (newShape.hasPrimitiveArray()) {
            int[] primitiveArray = store.getPrimitiveStore();
            assert (primitiveArray == null && newShape.getPrimitiveArrayCapacity() == 0 || primitiveArray != null && primitiveArray.length == newShape.getPrimitiveArrayCapacity());
        }
        return true;
    }

    private ShapeImpl makeSuccessorShape(ShapeImpl oldShape) {
        makeSuccessorShapeCount.inc();
        assert (!oldShape.isValid());
        ArrayDeque<ShapeImpl> affectedShapes = new ArrayDeque<ShapeImpl>();
        ShapeImpl goodAncestor = oldShape;
        while (!goodAncestor.isValid()) {
            affectedShapes.addFirst(goodAncestor);
            goodAncestor = goodAncestor.getParent();
        }
        ShapeImpl offendingShape = (ShapeImpl)affectedShapes.removeFirst();
        ShapeImpl obsoletedBy = this.getObsoletedBy(offendingShape);
        if (ExtLayout.TraceReshape) {
            ObsolescenceStrategy.out().printf("REBUILING SHAPE: %s\nGOOD ANCESTOR: %s\nOFFENDING SHAPE: %s\nOBSOLETED BY: %s\n", oldShape.toStringLimit(500), goodAncestor.toStringLimit(500), offendingShape.toStringLimit(500), obsoletedBy.toStringLimit(500));
        }
        ShapeImpl newShape = obsoletedBy;
        for (ShapeImpl affectedShape : affectedShapes) {
            Transition transition = affectedShape.getTransitionFromParent();
            newShape = this.applyTransition(newShape, transition, true);
        }
        if (ExtLayout.TraceReshape) {
            while (!goodAncestor.isValid()) {
                goodAncestor = goodAncestor.getParent();
            }
            ObsolescenceStrategy.out().printf("OLD %s\nNEW %s\nLCA %s\nDIFF %s\n---\n", oldShape.toStringLimit(500), newShape.toStringLimit(500), goodAncestor.toStringLimit(500), ObsolescenceStrategy.diffToString(oldShape, newShape));
        }
        return newShape;
    }

    private static List<Object> prepareCopy(DynamicObject fromObject, ShapeImpl fromShape, ShapeImpl toShape) {
        ArrayList<Object> toCopy = new ArrayList<Object>();
        PropertyMap fromMap = fromShape.getPropertyMap();
        Iterator<Property> toMapIt = toShape.getPropertyMap().orderedValueIterator();
        while (toMapIt.hasNext()) {
            Property toProperty = toMapIt.next();
            Property fromProperty = (Property)fromMap.get(toProperty.getKey());
            if (toProperty.getLocation().isValue() || toProperty.getLocation().equals(fromProperty.getLocation())) continue;
            Object value = fromProperty.getLocation().get(fromObject, false);
            toCopy.add(toProperty);
            toCopy.add(value);
        }
        return toCopy;
    }

    private static void performCopy(DynamicObject toObject, List<Object> toCopy) {
        for (int i = 0; i < toCopy.size(); i += 2) {
            Property toProperty = (Property)toCopy.get(i);
            Object value = toCopy.get(i + 1);
            ObsolescenceStrategy.setPropertyInternal(toProperty, toObject, value);
        }
    }

    private static void setPropertyInternal(Property toProperty, DynamicObject toObject, Object value) {
        try {
            ((ExtLocation)toProperty.getLocation()).set(toObject, value, false, true);
        }
        catch (IncompatibleLocationException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    private boolean checkForObsoleteShapeAndMigrate(DynamicObject store) {
        Shape currentShape = store.getShape();
        if (currentShape.isValid()) {
            return false;
        }
        CompilerDirectives.transferToInterpreter();
        return this.migrateObsoleteShape(currentShape, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrateObsoleteShape(Shape currentShape, DynamicObject store) {
        CompilerAsserts.neverPartOfCompilation();
        Object object = ((ShapeImpl)currentShape).getMutex();
        synchronized (object) {
            if (!currentShape.isValid()) {
                assert (!currentShape.isShared());
                this.reshape(store);
                return true;
            }
            return false;
        }
    }

    private ShapeImpl rebuildObsoleteShape(ShapeImpl oldShape, ShapeImpl owningShape) {
        assert (!owningShape.isValid());
        if (oldShape.isValid()) {
            for (ShapeImpl current = oldShape; current != owningShape && current != null; current = current.getParent()) {
                Obsolescence.invalidateShape(current);
            }
        }
        assert (!oldShape.isValid());
        return this.makeSuccessorShape(oldShape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShapeImpl generalizeHelper(Property currentProperty, Object value, ShapeImpl currentShape, int putFlags) {
        ShapeImpl oldShape = currentShape;
        Property oldProperty = currentProperty;
        assert (!oldProperty.getLocation().canStore(value));
        while (true) {
            ShapeImpl owningShape = ObsolescenceStrategy.getOwningShape(oldShape, oldProperty);
            Object object = oldShape.getMutex();
            synchronized (object) {
                if (owningShape.isValid()) {
                    ShapeImpl oldParentShape = owningShape.getParent();
                    Location newLocation = ((ExtAllocator)oldParentShape.allocator()).locationForValueUpcast(value, oldProperty.getLocation(), putFlags);
                    Property newProperty = Property.create(oldProperty.getKey(), newLocation, oldProperty.getFlags());
                    return this.obsoleteAndMakeShapeWithProperty(oldProperty, oldShape, owningShape, newProperty);
                }
                ShapeImpl newShape = this.rebuildObsoleteShape(oldShape, owningShape);
                Property newPropertyAfterReshape = newShape.getProperty(oldProperty.getKey());
                if (((LocationImpl)newPropertyAfterReshape.getLocation()).canStore(value)) {
                    return newShape;
                }
                oldShape = newShape;
                oldProperty = newPropertyAfterReshape;
            }
        }
    }

    private ShapeImpl obsoleteAndMakeShapeWithProperty(Property oldProperty, ShapeImpl oldShape, ShapeImpl owningShape, Property newProperty) {
        ShapeImpl newOwningShape = this.makeNewOwningShape(owningShape, newProperty);
        assert (owningShape != newOwningShape);
        Obsolescence.markObsolete(owningShape, newOwningShape, oldProperty, newProperty);
        return this.rebuildObsoleteShape(oldShape, owningShape);
    }

    private ShapeImpl makeNewOwningShape(ShapeImpl owningShape, Property newProperty) {
        ShapeImpl oldParentShape = owningShape.getParent();
        Transition transitionFromParent = owningShape.getTransitionFromParent();
        if (transitionFromParent instanceof Transition.DirectReplacePropertyTransition) {
            return this.directReplaceProperty(oldParentShape, ((Transition.AbstractReplacePropertyTransition)transitionFromParent).getPropertyBefore(), newProperty);
        }
        assert (transitionFromParent instanceof Transition.AddPropertyTransition);
        return oldParentShape.addProperty(newProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShapeImpl generalizeHelperWithShape(Property oldProperty, Object value, ShapeImpl oldShapeBefore, ShapeImpl oldShapeAfter, int putFlags) {
        assert (!oldProperty.getLocation().isDeclared());
        Location newLocation = ((ExtAllocator)oldShapeBefore.allocator()).locationForValueUpcast(value, oldProperty.getLocation(), putFlags);
        Property newProperty = Property.create(oldProperty.getKey(), newLocation, oldProperty.getFlags());
        Object object = oldShapeBefore.getMutex();
        synchronized (object) {
            ShapeImpl newShapeAfter = oldShapeBefore.addProperty(newProperty);
            assert (oldShapeAfter != newShapeAfter);
            Obsolescence.markObsolete(oldShapeAfter, newShapeAfter, oldProperty, newProperty);
            assert (oldProperty.getKey().equals(newShapeAfter.getLastProperty().getKey()));
            assert (newShapeAfter.getLastProperty().equals(newShapeAfter.getProperty(oldProperty.getKey())));
            return newShapeAfter;
        }
    }

    private static ShapeImpl getOwningShape(ShapeImpl shape, Property prop) {
        ShapeImpl root = shape.getRoot();
        for (ShapeImpl current = shape; current != root; current = current.getParent()) {
            Transition transitionFromParent = current.getTransitionFromParent();
            if (!(transitionFromParent instanceof Transition.AddPropertyTransition ? ((Transition.AddPropertyTransition)transitionFromParent).getProperty().equals(prop) : transitionFromParent instanceof Transition.DirectReplacePropertyTransition && ((Transition.DirectReplacePropertyTransition)transitionFromParent).getPropertyAfter().equals(prop))) continue;
            return current;
        }
        return null;
    }

    private static PrintStream out() {
        return System.out;
    }

    public static Map<Object, Pair<Property, Property>> findPropertyDifferences(Shape oldShape, Shape newShape) {
        List<Property> oldList = oldShape.getPropertyListInternal(true);
        List<Property> newList = newShape.getPropertyListInternal(true);
        LinkedHashMap<Object, Pair<Property, Property>> diff = new LinkedHashMap<Object, Pair<Property, Property>>(Math.max(oldList.size(), newList.size()));
        for (Property p : oldList) {
            diff.put(p.getKey(), Pair.createLeft((Object)p));
        }
        for (Property p : newList) {
            diff.merge(p.getKey(), (Pair<Property, Property>)Pair.createRight((Object)p), (lp, rp) -> Pair.create((Object)((Property)lp.getLeft()), (Object)((Property)rp.getRight())));
        }
        Iterator iterator = diff.values().iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!Objects.equals(pair.getLeft(), pair.getRight())) continue;
            iterator.remove();
        }
        return diff;
    }

    public static String diffToString(Shape oldShape, Shape newShape) {
        return ObsolescenceStrategy.findPropertyDifferences(oldShape, newShape).values().stream().map(p -> String.valueOf(p.getLeft()) + " => " + String.valueOf(p.getRight())).collect(Collectors.joining(",\n", "[", "]"));
    }

    private static class AllocatorImpl
    extends ExtAllocator {
        protected AllocatorImpl(LayoutImpl layout) {
            super(layout);
        }

        protected AllocatorImpl(ShapeImpl shape) {
            super(shape);
        }
    }

    static final class NonrecoverableError
    extends ThreadDeath {
        NonrecoverableError() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String getMessage() {
            return "Execution cancelled due to non-recoverable StackOverflowError";
        }
    }
}

