/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.BreakNetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CMarshaller {
    private static final T4CMarshaller BASIC;
    private static final T4CMarshaller STREAM;
    static final T4CMarshaller CHAR;
    static final T4CMarshaller LONG_RAW;
    static final T4CMarshaller RAW;
    static final T4CMarshaller VARCHAR;
    static final T4CMarshaller LONG;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    abstract boolean unmarshalOneRow(Accessor var1) throws SQLException, IOException;

    abstract int readStreamFromWire(byte[] var1, int var2, int var3, int[] var4, boolean[] var5, boolean[] var6, T4CMAREngine var7, T4CTTIoer11 var8) throws SQLException, IOException;

    private T4CMarshaller() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CMarshaller.class, $$$methodRef$$$0, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CMarshaller.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMarshaller.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMarshaller.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$1 = T4CMarshaller.class.getDeclaredConstructor(1.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMarshaller.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        BASIC = new BasicMarshaller();
        STREAM = new StreamMarshaller();
        CHAR = BASIC;
        LONG_RAW = STREAM;
        RAW = BASIC;
        VARCHAR = BASIC;
        LONG = STREAM;
    }

    private static final class StreamMarshaller
    extends T4CMarshaller {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private StreamMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor acc) throws SQLException, IOException {
            T4CAccessor t4cAcc = (T4CAccessor)((Object)acc);
            T4CMAREngine mare = t4cAcc.getMAREngine();
            if (acc.isUseless()) {
                ++acc.lastRowProcessed;
                return false;
            }
            boolean isStream = false;
            acc.escapeSequenceArr[0] = mare.unmarshalUB1();
            if (mare.escapeSequenceNull(acc.escapeSequenceArr[0])) {
                acc.setNull(acc.lastRowProcessed, true);
                mare.processIndicator(false, 0);
                int ignore = (int)mare.unmarshalUB4();
                acc.escapeSequenceArr[0] = 0;
                acc.previousRowProcessed = acc.lastRowProcessed++;
            } else {
                acc.setNull(acc.lastRowProcessed, false);
                acc.readHeaderArr[0] = true;
                acc.readAsNonStreamArr[0] = false;
                if (acc.statement.isFetchStreams || acc.definedColumnType == -2 || acc.definedColumnType == 12 || acc.definedColumnType == 1) {
                    int nbBytesReadTemp = 0;
                    int nbBytesRead = 0;
                    byte[] buf = acc.statement.connection.getByteBuffer(32768);
                    acc.setOffset(acc.lastRowProcessed);
                    while (nbBytesReadTemp != -1) {
                        nbBytesReadTemp = this.readStreamFromWire(buf, 0, 32768, acc.escapeSequenceArr, acc.readHeaderArr, acc.readAsNonStreamArr, mare, ((T4CConnection)acc.statement.connection).oer);
                        if (nbBytesReadTemp == -1) continue;
                        if (acc.statement.connection.checksumMode.needToCalculateFetchChecksum()) {
                            long localCheckSum;
                            acc.statement.checkSum = localCheckSum = CRC64.updateChecksum(acc.statement.checkSum, buf, 0, nbBytesReadTemp);
                        }
                        acc.rowData.put(buf, 0, nbBytesReadTemp);
                        nbBytesRead += nbBytesReadTemp;
                    }
                    acc.setLength(acc.lastRowProcessed, nbBytesRead);
                    acc.previousRowProcessed = acc.lastRowProcessed++;
                    acc.isStream = false;
                    acc.statement.connection.cacheBuffer(buf);
                } else {
                    isStream = true;
                }
            }
            return isStream;
        }

        @Override
        int readStreamFromWire(byte[] buffer, int offset, int length, int[] escapeSequenceArr, boolean[] readHeaderArr, boolean[] readAsNonStreamArr, T4CMAREngine mare, T4CTTIoer11 oer) throws SQLException, IOException {
            int bytesToRead;
            block13: {
                bytesToRead = -1;
                try {
                    if (!readAsNonStreamArr[0]) {
                        if (length > 32768 || length < 0) {
                            throw (SQLException)DatabaseError.createSqlException(433).fillInStackTrace();
                        }
                        if (readHeaderArr[0]) {
                            if (escapeSequenceArr[0] == 254) {
                                bytesToRead = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                            } else {
                                if (escapeSequenceArr[0] == 0) {
                                    oer.connection.internalClose();
                                    throw (SQLException)DatabaseError.createSqlException(401).fillInStackTrace();
                                }
                                readAsNonStreamArr[0] = true;
                                bytesToRead = escapeSequenceArr[0];
                            }
                            readHeaderArr[0] = false;
                            escapeSequenceArr[0] = 0;
                        } else {
                            bytesToRead = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                        }
                    } else {
                        readAsNonStreamArr[0] = false;
                    }
                    if (bytesToRead > 0) {
                        mare.unmarshalNBytes(buffer, offset, bytesToRead);
                    } else {
                        bytesToRead = -1;
                    }
                }
                catch (BreakNetException ea) {
                    bytesToRead = mare.unmarshalSB1();
                    if (bytesToRead != 4) break block13;
                    oer.init();
                    oer.processError();
                }
            }
            if (bytesToRead == -1) {
                readHeaderArr[0] = true;
                mare.unmarshalUB2();
                mare.unmarshalUB2();
            }
            return bytesToRead;
        }

        static {
            try {
                $$$methodRef$$$3 = StreamMarshaller.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = StreamMarshaller.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = StreamMarshaller.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = StreamMarshaller.class.getDeclaredMethod("unmarshalOneRow", Accessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class BasicMarshaller
    extends T4CMarshaller {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        private BasicMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor acc) throws SQLException, IOException {
            T4CAccessor t4cAcc = (T4CAccessor)((Object)acc);
            boolean isStream = false;
            if (!acc.isUseless()) {
                if (acc.isUnexpected()) {
                    long pos = acc.rowData.getPosition();
                    t4cAcc.unmarshalColumnMetadata();
                    this.unmarshalBytes(acc);
                    acc.rowData.setPosition(pos);
                    acc.setNull(acc.lastRowProcessed, true);
                } else if (acc.isNullByDescribe()) {
                    acc.setNull(acc.lastRowProcessed, true);
                    t4cAcc.unmarshalColumnMetadata();
                    if (acc.statement.connection.versionNumber < 9200) {
                        t4cAcc.processIndicator(0);
                    }
                } else {
                    t4cAcc.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes(acc);
                }
            }
            acc.previousRowProcessed = acc.lastRowProcessed++;
            return isStream;
        }

        private boolean unmarshalBytes(Accessor acc) throws SQLException, IOException {
            T4CAccessor t4cAcc = (T4CAccessor)((Object)acc);
            T4CMAREngine mare = t4cAcc.getMAREngine();
            acc.setOffset(acc.lastRowProcessed);
            int len = acc.statement.maxFieldSize > 0 ? ((DynamicByteArray)acc.rowData).unmarshalCLR(mare, acc.statement.maxFieldSize) : ((DynamicByteArray)acc.rowData).unmarshalCLR(mare);
            t4cAcc.processIndicator(len);
            acc.setLength(acc.lastRowProcessed, len);
            acc.setNull(acc.lastRowProcessed, len == 0);
            return false;
        }

        @Override
        int readStreamFromWire(byte[] buffer, int offset, int length, int[] escapeSequenceArr, boolean[] readHeaderArr, boolean[] readAsNonStreamArr, T4CMAREngine mare, T4CTTIoer11 oer) throws SQLException, IOException {
            return -1;
        }

        static {
            try {
                $$$methodRef$$$4 = BasicMarshaller.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = BasicMarshaller.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = BasicMarshaller.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = BasicMarshaller.class.getDeclaredMethod("unmarshalBytes", Accessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = BasicMarshaller.class.getDeclaredMethod("unmarshalOneRow", Accessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

