/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.message2;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graalvm.shadowed.com.ibm.icu.message2.DateTimeFormatterFactory;
import org.graalvm.shadowed.com.ibm.icu.message2.FormattedPlaceholder;
import org.graalvm.shadowed.com.ibm.icu.message2.Formatter;
import org.graalvm.shadowed.com.ibm.icu.message2.FormatterFactory;
import org.graalvm.shadowed.com.ibm.icu.message2.IdentityFormatterFactory;
import org.graalvm.shadowed.com.ibm.icu.message2.MFDataModel;
import org.graalvm.shadowed.com.ibm.icu.message2.MFFunctionRegistry;
import org.graalvm.shadowed.com.ibm.icu.message2.MessageFormatter;
import org.graalvm.shadowed.com.ibm.icu.message2.NumberFormatterFactory;
import org.graalvm.shadowed.com.ibm.icu.message2.PlainStringFormattedValue;
import org.graalvm.shadowed.com.ibm.icu.message2.Selector;
import org.graalvm.shadowed.com.ibm.icu.message2.SelectorFactory;
import org.graalvm.shadowed.com.ibm.icu.message2.TextSelectorFactory;
import org.graalvm.shadowed.com.ibm.icu.util.Calendar;
import org.graalvm.shadowed.com.ibm.icu.util.CurrencyAmount;

class MFDataModelFormatter {
    private final Locale locale;
    private final MessageFormatter.ErrorHandlingBehavior errorHandlingBehavior;
    private final MFDataModel.Message dm;
    private final MFFunctionRegistry standardFunctions;
    private final MFFunctionRegistry customFunctions;
    private static final MFFunctionRegistry EMPTY_REGISTY = MFFunctionRegistry.builder().build();

    MFDataModelFormatter(MFDataModel.Message dm, Locale locale, MessageFormatter.ErrorHandlingBehavior errorHandlingBehavior, MFFunctionRegistry customFunctionRegistry) {
        this.locale = locale;
        this.errorHandlingBehavior = errorHandlingBehavior == null ? MessageFormatter.ErrorHandlingBehavior.BEST_EFFORT : errorHandlingBehavior;
        this.dm = dm;
        this.customFunctions = customFunctionRegistry == null ? EMPTY_REGISTY : customFunctionRegistry;
        this.standardFunctions = MFFunctionRegistry.builder().setFormatter("datetime", new DateTimeFormatterFactory("datetime")).setFormatter("date", new DateTimeFormatterFactory("date")).setFormatter("time", new DateTimeFormatterFactory("time")).setDefaultFormatterNameForType(Date.class, "datetime").setDefaultFormatterNameForType(Calendar.class, "datetime").setDefaultFormatterNameForType(java.util.Calendar.class, "datetime").setDefaultFormatterNameForType(Temporal.class, "datetime").setFormatter("number", new NumberFormatterFactory("number")).setFormatter("integer", new NumberFormatterFactory("integer")).setDefaultFormatterNameForType(Integer.class, "number").setDefaultFormatterNameForType(Double.class, "number").setDefaultFormatterNameForType(Number.class, "number").setDefaultFormatterNameForType(CurrencyAmount.class, "number").setFormatter("string", new IdentityFormatterFactory()).setDefaultFormatterNameForType(String.class, "string").setDefaultFormatterNameForType(CharSequence.class, "string").setSelector("number", new NumberFormatterFactory("number")).setSelector("integer", new NumberFormatterFactory("integer")).setSelector("string", new TextSelectorFactory()).setSelector("icu:gender", new TextSelectorFactory()).build();
    }

    String format(Map<String, Object> arguments) {
        Map<String, Object> variables;
        MFDataModel.Pattern patternToRender = null;
        if (arguments == null) {
            arguments = new HashMap<String, Object>();
        }
        if (this.dm instanceof MFDataModel.PatternMessage) {
            MFDataModel.PatternMessage pm = (MFDataModel.PatternMessage)this.dm;
            variables = this.resolveDeclarations(pm.declarations, arguments);
            if (pm.pattern == null) {
                MFDataModelFormatter.fatalFormattingError("The PatternMessage is null.");
            }
            patternToRender = pm.pattern;
        } else if (this.dm instanceof MFDataModel.SelectMessage) {
            MFDataModel.SelectMessage sm = (MFDataModel.SelectMessage)this.dm;
            variables = this.resolveDeclarations(sm.declarations, arguments);
            patternToRender = this.findBestMatchingPattern(sm, variables, arguments);
            if (patternToRender == null) {
                MFDataModelFormatter.fatalFormattingError("Cannor find a match for the selector.");
            }
        } else {
            MFDataModelFormatter.fatalFormattingError("Unknown message type.");
            return "ERROR!";
        }
        StringBuilder result = new StringBuilder();
        for (MFDataModel.PatternPart part : patternToRender.parts) {
            if (part instanceof MFDataModel.StringPart) {
                MFDataModel.StringPart strPart = (MFDataModel.StringPart)part;
                result.append(strPart.value);
                continue;
            }
            if (part instanceof MFDataModel.Expression) {
                FormattedPlaceholder formattedExpression = this.formatExpression((MFDataModel.Expression)part, variables, arguments);
                result.append(formattedExpression.getFormattedValue().toString());
                continue;
            }
            if (part instanceof MFDataModel.Markup) continue;
            MFDataModelFormatter.fatalFormattingError("Unknown part type: " + String.valueOf(part));
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private MFDataModel.Pattern findBestMatchingPattern(MFDataModel.SelectMessage sm, Map<String, Object> variables, Map<String, Object> arguments) {
        void var11_37;
        MFDataModel.Pattern patternToRender = null;
        List<MFDataModel.Expression> selectors = sm.selectors;
        ArrayList<ResolvedSelector> res = new ArrayList<ResolvedSelector>(selectors.size());
        for (MFDataModel.Expression sel : selectors) {
            void var10_12;
            FormattedPlaceholder fph = this.formatExpression(sel, variables, arguments);
            Object var10_13 = null;
            Object var11_26 = null;
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (fph.getInput() instanceof ResolvedExpression) {
                ResolvedExpression re = (ResolvedExpression)fph.getInput();
                Object object = re.argument;
                String string = re.functionName;
                options.putAll(re.options);
            } else if (fph.getInput() instanceof MFDataModel.VariableExpression) {
                MFDataModel.VariableExpression ve = (MFDataModel.VariableExpression)fph.getInput();
                Object object = MFDataModelFormatter.resolveLiteralOrVariable(ve.arg, variables, arguments);
                if (ve.annotation instanceof MFDataModel.FunctionAnnotation) {
                    String string = ((MFDataModel.FunctionAnnotation)ve.annotation).name;
                }
            } else if (fph.getInput() instanceof MFDataModel.LiteralExpression) {
                MFDataModel.LiteralExpression le = (MFDataModel.LiteralExpression)fph.getInput();
                MFDataModel.Literal literal = le.arg;
                if (le.annotation instanceof MFDataModel.FunctionAnnotation) {
                    String string = ((MFDataModel.FunctionAnnotation)le.annotation).name;
                }
            }
            SelectorFactory funcFactory = this.standardFunctions.getSelector((String)var10_12);
            if (funcFactory == null) {
                funcFactory = this.customFunctions.getSelector((String)var10_12);
            }
            if (funcFactory != null) {
                void var11_25;
                Selector selectorFunction = funcFactory.createSelector(this.locale, options);
                ResolvedSelector rs = new ResolvedSelector(var11_25, options, selectorFunction);
                res.add(rs);
                continue;
            }
            MFDataModelFormatter.fatalFormattingError("Unknown selector type: " + (String)var10_12);
        }
        if (res.size() != selectors.size()) {
            MFDataModelFormatter.fatalFormattingError("Something went wrong, not enough selector functions, " + res.size() + " vs. " + selectors.size());
        }
        ArrayList<List<String>> pref = new ArrayList<List<String>>();
        for (int i = 0; i < res.size(); ++i) {
            ArrayList keys = new ArrayList();
            for (MFDataModel.Variant variant : sm.variants) {
                MFDataModel.LiteralOrCatchallKey key = variant.keys.get(i);
                if (key instanceof MFDataModel.CatchallKey) {
                    keys.add("*");
                    continue;
                }
                if (key instanceof MFDataModel.Literal) {
                    String ks = ((MFDataModel.Literal)key).value;
                    keys.add(ks);
                    continue;
                }
                MFDataModelFormatter.fatalFormattingError("Literal expected, but got " + String.valueOf(key));
            }
            ResolvedSelector resolvedSelector = (ResolvedSelector)res.get(i);
            List<String> list = this.matchSelectorKeys(resolvedSelector, keys);
            pref.add(list);
        }
        ArrayList<MFDataModel.Variant> vars = new ArrayList<MFDataModel.Variant>();
        for (MFDataModel.Variant variant : sm.variants) {
            int n = 0;
            for (int i = 0; i < pref.size(); ++i) {
                MFDataModel.LiteralOrCatchallKey key = variant.keys.get(i);
                if (key instanceof MFDataModel.CatchallKey) {
                    ++n;
                    continue;
                }
                if (!(key instanceof MFDataModel.Literal)) {
                    MFDataModelFormatter.fatalFormattingError("Literal expected");
                }
                String ks = ((MFDataModel.Literal)key).value;
                List matches = (List)pref.get(i);
                if (!matches.contains(ks)) break;
                ++n;
            }
            if (n != pref.size()) continue;
            vars.add(variant);
        }
        ArrayList<IntVarTuple> sortable = new ArrayList<IntVarTuple>();
        for (MFDataModel.Variant variant : vars) {
            IntVarTuple tuple = new IntVarTuple(-1, variant);
            sortable.add(tuple);
        }
        int n = pref.size();
        int n2 = n - 1;
        while (var11_37 >= 0) {
            List matches = (List)pref.get((int)var11_37);
            int minpref = matches.size();
            for (IntVarTuple tuple : sortable) {
                int matchpref = minpref;
                MFDataModel.LiteralOrCatchallKey key = tuple.variant.keys.get((int)var11_37);
                if (!(key instanceof MFDataModel.CatchallKey)) {
                    if (!(key instanceof MFDataModel.Literal)) {
                        MFDataModelFormatter.fatalFormattingError("Literal expected");
                    }
                    String ks = ((MFDataModel.Literal)key).value;
                    matchpref = matches.indexOf(ks);
                }
                tuple.integer = matchpref;
            }
            sortable.sort(MFDataModelFormatter::sortVariants);
            --var11_37;
        }
        IntVarTuple var = (IntVarTuple)sortable.get(0);
        patternToRender = var.variant.value;
        if (patternToRender == null) {
            MFDataModelFormatter.fatalFormattingError("The selection went wrong, cannot select any option.");
        }
        return patternToRender;
    }

    private static int sortVariants(IntVarTuple o1, IntVarTuple o2) {
        int result = Integer.compare(o1.integer, o2.integer);
        if (result != 0) {
            return result;
        }
        List<MFDataModel.LiteralOrCatchallKey> v1 = o1.variant.keys;
        List<MFDataModel.LiteralOrCatchallKey> v2 = o1.variant.keys;
        if (v1.size() != v2.size()) {
            MFDataModelFormatter.fatalFormattingError("The number of keys is not equal.");
        }
        for (int i = 0; i < v1.size(); ++i) {
            MFDataModel.LiteralOrCatchallKey k2;
            String s2;
            MFDataModel.LiteralOrCatchallKey k1 = v1.get(i);
            String s1 = k1 instanceof MFDataModel.Literal ? ((MFDataModel.Literal)k1).value : "*";
            int cmp = s1.compareTo(s2 = (k2 = v2.get(i)) instanceof MFDataModel.Literal ? ((MFDataModel.Literal)k2).value : "*");
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private List<String> matchSelectorKeys(ResolvedSelector rv, List<String> keys) {
        return rv.selectorFunction.matches(rv.argument, keys, rv.options);
    }

    private static void fatalFormattingError(String message) throws IllegalArgumentException {
        throw new IllegalArgumentException(message);
    }

    private FormatterFactory getFormattingFunctionFactoryByName(Object toFormat, String functionName) {
        FormatterFactory func;
        if (functionName == null || functionName.isEmpty()) {
            if (toFormat == null) {
                return null;
            }
            Class<?> clazz = toFormat.getClass();
            functionName = this.standardFunctions.getDefaultFormatterNameForType(clazz);
            if (functionName == null) {
                functionName = this.customFunctions.getDefaultFormatterNameForType(clazz);
            }
            if (functionName == null) {
                MFDataModelFormatter.fatalFormattingError("Object to format without a function, and unknown type: " + toFormat.getClass().getName());
            }
        }
        if ((func = this.standardFunctions.getFormatter(functionName)) == null) {
            func = this.customFunctions.getFormatter(functionName);
        }
        return func;
    }

    private static Object resolveLiteralOrVariable(MFDataModel.LiteralOrVariableRef value, Map<String, Object> localVars, Map<String, Object> arguments) {
        if (value instanceof MFDataModel.Literal) {
            String val = ((MFDataModel.Literal)value).value;
            return val;
        }
        if (value instanceof MFDataModel.VariableRef) {
            String varName = ((MFDataModel.VariableRef)value).name;
            Object val = localVars.get(varName);
            if (val == null) {
                val = localVars.get(varName);
            }
            if (val == null) {
                val = arguments.get(varName);
            }
            return val;
        }
        return value;
    }

    private static Map<String, Object> convertOptions(Map<String, MFDataModel.Option> options, Map<String, Object> localVars, Map<String, Object> arguments) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (MFDataModel.Option option : options.values()) {
            result.put(option.name, MFDataModelFormatter.resolveLiteralOrVariable(option.value, localVars, arguments));
        }
        return result;
    }

    private FormattedPlaceholder formatExpression(MFDataModel.Expression expression, Map<String, Object> variables, Map<String, Object> arguments) {
        FormatterFactory funcFactory;
        MFDataModel.Annotation annotation = null;
        String functionName = null;
        Object toFormat = null;
        HashMap<String, Object> options = new HashMap<String, Object>();
        Object fallbackString = "{\ufffd}";
        if (expression instanceof MFDataModel.VariableExpression) {
            MFDataModel.VariableExpression varPart = (MFDataModel.VariableExpression)expression;
            fallbackString = "{$" + varPart.arg.name + "}";
            annotation = varPart.annotation;
            Object resolved = MFDataModelFormatter.resolveLiteralOrVariable(varPart.arg, variables, arguments);
            if (resolved instanceof FormattedPlaceholder) {
                Object input = ((FormattedPlaceholder)resolved).getInput();
                if (input instanceof ResolvedExpression) {
                    ResolvedExpression re = (ResolvedExpression)input;
                    toFormat = re.argument;
                    functionName = re.functionName;
                    options.putAll(re.options);
                } else {
                    toFormat = input;
                }
            } else {
                toFormat = resolved;
            }
        } else if (expression instanceof MFDataModel.FunctionExpression) {
            MFDataModel.FunctionExpression fe = (MFDataModel.FunctionExpression)expression;
            fallbackString = "{:" + fe.annotation.name + "}";
            annotation = fe.annotation;
        } else if (expression instanceof MFDataModel.LiteralExpression) {
            MFDataModel.LiteralExpression le = (MFDataModel.LiteralExpression)expression;
            annotation = le.annotation;
            fallbackString = "{|" + le.arg.value + "|}";
            toFormat = MFDataModelFormatter.resolveLiteralOrVariable(le.arg, variables, arguments);
        } else {
            if (expression instanceof MFDataModel.Markup) {
                return new FormattedPlaceholder(expression, new PlainStringFormattedValue(""));
            }
            if (expression == null) {
                MFDataModelFormatter.fatalFormattingError("unexpected null expression");
            } else {
                MFDataModelFormatter.fatalFormattingError("unknown expression type " + expression.getClass().getName());
            }
        }
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            MFDataModel.FunctionAnnotation fa = (MFDataModel.FunctionAnnotation)annotation;
            if (functionName != null && !functionName.equals(fa.name)) {
                MFDataModelFormatter.fatalFormattingError("invalid function overrides, '" + functionName + "' <> '" + fa.name + "'");
            }
            functionName = fa.name;
            Map<String, Object> newOptions = MFDataModelFormatter.convertOptions(fa.options, variables, arguments);
            options.putAll(newOptions);
        }
        if ((funcFactory = this.getFormattingFunctionFactoryByName(toFormat, functionName)) == null) {
            if (this.errorHandlingBehavior == MessageFormatter.ErrorHandlingBehavior.STRICT) {
                MFDataModelFormatter.fatalFormattingError("unable to find function at " + (String)fallbackString);
            }
            return new FormattedPlaceholder(expression, new PlainStringFormattedValue((String)fallbackString));
        }
        Formatter ff = funcFactory.createFormatter(this.locale, options);
        Object res = ff.formatToString(toFormat, arguments);
        if (res == null) {
            if (this.errorHandlingBehavior == MessageFormatter.ErrorHandlingBehavior.STRICT) {
                MFDataModelFormatter.fatalFormattingError("unable to format string at " + (String)fallbackString);
            }
            res = fallbackString;
        }
        ResolvedExpression resExpression = new ResolvedExpression(toFormat, functionName, options);
        return new FormattedPlaceholder(resExpression, new PlainStringFormattedValue((String)res));
    }

    private Map<String, Object> resolveDeclarations(List<MFDataModel.Declaration> declarations, Map<String, Object> arguments) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (declarations != null) {
            for (MFDataModel.Declaration declaration : declarations) {
                MFDataModel.Expression value;
                String name;
                if (declaration instanceof MFDataModel.InputDeclaration) {
                    name = ((MFDataModel.InputDeclaration)declaration).name;
                    value = ((MFDataModel.InputDeclaration)declaration).value;
                } else {
                    if (!(declaration instanceof MFDataModel.LocalDeclaration)) continue;
                    name = ((MFDataModel.LocalDeclaration)declaration).name;
                    value = ((MFDataModel.LocalDeclaration)declaration).value;
                }
                try {
                    FormattedPlaceholder fmt = this.formatExpression(value, variables, arguments);
                    variables.put(name, fmt);
                }
                catch (Exception exception) {}
            }
        }
        return variables;
    }

    static class ResolvedExpression
    implements MFDataModel.Expression {
        final Object argument;
        final String functionName;
        final Map<String, Object> options;

        public ResolvedExpression(Object argument, String functionName, Map<String, Object> options) {
            this.argument = argument;
            this.functionName = functionName;
            this.options = options;
        }
    }

    private static class ResolvedSelector {
        final Object argument;
        final Map<String, Object> options;
        final Selector selectorFunction;

        public ResolvedSelector(Object argument, Map<String, Object> options, Selector selectorFunction) {
            this.argument = argument;
            this.options = new HashMap<String, Object>(options);
            this.selectorFunction = selectorFunction;
        }
    }

    private static class IntVarTuple {
        int integer;
        final MFDataModel.Variant variant;

        public IntVarTuple(int integer, MFDataModel.Variant variant) {
            this.integer = integer;
            this.variant = variant;
        }
    }
}

