/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.SuppressFBWarnings;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileLock;
import java.nio.channels.Pipe;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

abstract class PosixResources
extends PosixSupport {
    private static final int FD_STDIN = 0;
    private static final int FD_STDOUT = 1;
    private static final int FD_STDERR = 2;
    protected final PythonContext context;
    private final SortedMap<Integer, ChannelWrapper> files;
    protected final Map<Integer, String> filePaths;
    private final List<Process> children;
    private final Map<String, Integer> inodes;
    private int inodeCnt = 0;

    protected PosixResources(PythonContext context) {
        this.context = context;
        this.files = Collections.synchronizedSortedMap(new TreeMap());
        this.filePaths = Collections.synchronizedMap(new HashMap());
        this.children = Collections.synchronizedList(new ArrayList());
        String osProperty = System.getProperty("os.name");
        this.files.put(0, ChannelWrapper.createForStandardStream());
        this.files.put(1, ChannelWrapper.createForStandardStream());
        this.files.put(2, ChannelWrapper.createForStandardStream());
        if (osProperty != null && osProperty.toLowerCase(Locale.ENGLISH).contains("win")) {
            this.filePaths.put(0, "STDIN");
            this.filePaths.put(1, "STDOUT");
            this.filePaths.put(2, "STDERR");
        } else {
            this.filePaths.put(0, "/dev/stdin");
            this.filePaths.put(1, "/dev/stdout");
            this.filePaths.put(2, "/dev/stderr");
        }
        this.children.add(new ProcessGroup(this.children));
        this.inodes = new HashMap<String, Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public void setEnv(TruffleLanguage.Env env) {
        SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
        synchronized (sortedMap) {
            ((ChannelWrapper)this.files.get(0)).setNewChannel(env.in());
            ((ChannelWrapper)this.files.get(1)).setNewChannel(env.out());
            ((ChannelWrapper)this.files.get(2)).setNewChannel(env.err());
        }
    }

    private void addFD(int fd, Channel channel) {
        this.addFD(fd, channel, null);
    }

    @CompilerDirectives.TruffleBoundary
    private void addFD(int fd, Channel channel, String path) {
        this.files.put(fd, new ChannelWrapper(channel));
        if (path != null) {
            this.filePaths.put(fd, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected boolean removeFD(int fd) throws IOException {
        ChannelWrapper channelWrapper = this.files.getOrDefault(fd, null);
        if (channelWrapper != null) {
            SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
            synchronized (sortedMap) {
                if (channelWrapper.cnt == 1) {
                    channelWrapper.channel.close();
                } else if (channelWrapper.cnt > 1) {
                    --channelWrapper.cnt;
                }
                this.files.remove(fd);
                this.filePaths.remove(fd);
            }
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private void dupFD(int fd1, int fd2) {
        ChannelWrapper channelWrapper = this.files.getOrDefault(fd1, null);
        String path = this.filePaths.get(fd1);
        if (channelWrapper != null) {
            ++channelWrapper.cnt;
            this.files.put(fd2, channelWrapper);
            if (path != null) {
                this.filePaths.put(fd2, path);
            }
        }
    }

    protected boolean isStandardStream(int fd) {
        ChannelWrapper channelWrapper = (ChannelWrapper)this.files.get(fd);
        return channelWrapper != null && channelWrapper.isStandardStream;
    }

    @CompilerDirectives.TruffleBoundary
    public FileLock getFileLock(int fd) {
        ChannelWrapper channelWrapper = this.files.getOrDefault(fd, null);
        if (channelWrapper != null) {
            return channelWrapper.lock;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void setFileLock(int fd, FileLock lock) {
        ChannelWrapper channelWrapper = this.files.getOrDefault(fd, null);
        if (channelWrapper != null) {
            channelWrapper.lock = lock;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Channel getFileChannel(int fd) {
        ChannelWrapper channelWrapper = this.files.getOrDefault(fd, null);
        if (channelWrapper != null) {
            return channelWrapper.channel;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public String getFilePath(int fd) {
        return this.filePaths.getOrDefault(fd, null);
    }

    @CompilerDirectives.TruffleBoundary
    public void close(int fd) {
        try {
            this.removeFD(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void fdopen(int fd, Channel fc) {
        ((ChannelWrapper)this.files.get((Object)Integer.valueOf((int)fd))).channel = fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public int open(TruffleFile path, Channel fc) {
        SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
        synchronized (sortedMap) {
            int fd = this.nextFreeFd();
            this.addFD(fd, fc, path.getAbsoluteFile().getPath());
            return fd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public int dup(int fd) {
        SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
        synchronized (sortedMap) {
            int dupFd = this.nextFreeFd();
            this.dupFD(fd, dupFd);
            return dupFd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public int dup2(int fd, int fd2) throws IOException {
        SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
        synchronized (sortedMap) {
            this.removeFD(fd2);
            this.dupFD(fd, fd2);
            return fd2;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean fsync(int fd) {
        return this.files.getOrDefault(fd, null) != null;
    }

    @CompilerDirectives.TruffleBoundary
    public Object ftruncate(int fd, long size) throws IOException {
        Channel channel = this.getFileChannel(fd);
        if (channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)channel).truncate(size);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public int[] pipe() throws IOException {
        SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
        synchronized (sortedMap) {
            Pipe pipe = Pipe.open();
            int readFD = this.nextFreeFd();
            this.addFD(readFD, pipe.source());
            int writeFD = this.nextFreeFd();
            this.addFD(writeFD, pipe.sink());
            return new int[]{readFD, writeFD};
        }
    }

    @CompilerDirectives.TruffleBoundary
    private int nextFreeFd() {
        int fd1 = this.files.firstKey();
        for (int fd2 : this.files.keySet()) {
            if (fd2 == fd1) continue;
            if (fd2 - fd1 > 1) {
                return fd1 + 1;
            }
            fd1 = fd2;
        }
        return this.files.lastKey() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected int registerChild(Process child) {
        List<Process> list = this.children;
        synchronized (list) {
            for (int i = 0; i < this.children.size(); ++i) {
                Process openPath = this.children.get(i);
                if (openPath != null) continue;
                this.children.set(i, child);
                return i;
            }
            this.children.add(child);
            return this.children.size() - 1;
        }
    }

    private Process getChild(int pid) throws IndexOutOfBoundsException {
        if (pid < -1) {
            throw new IndexOutOfBoundsException("we do not support process groups");
        }
        if (pid == -1) {
            return this.children.get(0);
        }
        return this.children.get(pid);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public void sigdfl(int pid) throws IndexOutOfBoundsException {
        this.getChild(pid);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public void sigterm(int pid) throws IndexOutOfBoundsException {
        Process process = this.getChild(pid);
        process.destroy();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public void sigkill(int pid) throws IndexOutOfBoundsException {
        Process process = this.getChild(pid);
        process.destroyForcibly();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public int waitpid(int pid) throws IndexOutOfBoundsException, InterruptedException {
        Process process = this.getChild(pid);
        int exitStatus = process.waitFor();
        if (pid > 0) {
            this.children.set(pid, null);
        }
        return exitStatus;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public int[] exitStatus(int pid) throws IndexOutOfBoundsException {
        if (pid == -1) {
            for (int childPid = 1; childPid < this.children.size(); ++childPid) {
                Process child = this.children.get(childPid);
                if (child == null || child.isAlive()) continue;
                this.children.set(childPid, null);
                return new int[]{childPid, child.exitValue()};
            }
        } else {
            Process process = this.getChild(pid);
            if (!process.isAlive()) {
                this.children.set(pid, null);
                return new int[]{pid, process.exitValue()};
            }
        }
        return new int[]{0, 0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public int getInodeId(String canonical) {
        Map<String, Integer> map = this.inodes;
        synchronized (map) {
            int inodeId;
            if (!this.inodes.containsKey(canonical)) {
                inodeId = this.inodeCnt++;
                this.inodes.put(canonical, inodeId);
            } else {
                inodeId = this.inodes.get(canonical);
            }
            return inodeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    int assignFileDescriptor(Channel channel) {
        SortedMap<Integer, ChannelWrapper> sortedMap = this.files;
        synchronized (sortedMap) {
            int fd = this.nextFreeFd();
            this.addFD(fd, channel);
            return fd;
        }
    }

    @CompilerDirectives.TruffleBoundary
    Channel getChannel(int fd) {
        ChannelWrapper channelWrapper = this.files.getOrDefault(fd, null);
        if (channelWrapper == null) {
            return null;
        }
        return channelWrapper.channel;
    }

    private static class ChannelWrapper {
        Channel channel;
        int cnt;
        FileLock lock;
        boolean isStandardStream;

        ChannelWrapper(Channel channel) {
            this(channel, 1);
        }

        ChannelWrapper(Channel channel, int cnt) {
            this(channel, cnt, false);
        }

        ChannelWrapper(Channel channel, int cnt, boolean isStandardStream) {
            this.channel = channel;
            this.cnt = cnt;
            this.isStandardStream = isStandardStream;
        }

        static ChannelWrapper createForStandardStream() {
            return new ChannelWrapper(null, 0, true);
        }

        void setNewChannel(InputStream inputStream) {
            this.channel = Channels.newChannel(inputStream);
            this.cnt = 1;
        }

        void setNewChannel(OutputStream outputStream) {
            this.channel = new FlushingWritableByteChannel(outputStream);
            this.cnt = 1;
        }
    }

    private static class ProcessGroup
    extends Process {
        private final List<Process> children;

        ProcessGroup(List<Process> children) {
            this.children = children;
        }

        @Override
        public int waitFor() throws InterruptedException {
            for (Process child : this.children) {
                if (child == null || child == this) continue;
                int exitCode = child.waitFor();
                int childIndex = this.children.indexOf(child);
                if (childIndex > 0) {
                    this.children.set(childIndex, null);
                }
                return exitCode;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public OutputStream getOutputStream() {
            throw new RuntimeException();
        }

        @Override
        public InputStream getInputStream() {
            throw new RuntimeException();
        }

        @Override
        public InputStream getErrorStream() {
            throw new RuntimeException();
        }

        @Override
        public int exitValue() {
            for (Process child : this.children) {
                if (child == null || child == this || child.isAlive()) continue;
                return child.exitValue();
            }
            throw new IllegalThreadStateException();
        }

        @Override
        public void destroy() {
            for (Process child : this.children) {
                if (child == null || child == this) continue;
                child.destroy();
            }
        }

        @Override
        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
        public Process destroyForcibly() {
            for (Process child : this.children) {
                if (child == null || child == this) continue;
                child.destroyForcibly();
            }
            return this;
        }
    }

    private static class FlushingWritableByteChannel
    implements WritableByteChannel {
        private final OutputStream stream;
        private final WritableByteChannel delegate;

        private FlushingWritableByteChannel(OutputStream stream) {
            this.stream = stream;
            this.delegate = Channels.newChannel(stream);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int res = this.delegate.write(src);
            this.stream.flush();
            return res;
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

