/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.CallBinaryOp1Node;
import com.oracle.graal.python.lib.CallBinaryOpNode;
import com.oracle.graal.python.lib.PyNumberAddNodeGen;
import com.oracle.graal.python.lib.fastpath.PyNumberAddFastPathsBase;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(value=false)
@GenerateUncached
@OperationProxy.Proxyable
public abstract class PyNumberAddNode
extends PyNumberAddFastPathsBase {
    @Specialization(guards={"isBuiltinList(left)", "isBuiltinList(right)"})
    public static PList doPList(PList left, PList right, @Bind PythonLanguage language, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ConcatListOrTupleNode concatNode) {
        SequenceStorage newStore = concatNode.execute(inliningTarget, left.getSequenceStorage(), right.getSequenceStorage());
        return PFactory.createList(language, newStore);
    }

    @Specialization(guards={"isBuiltinTuple(left)", "isBuiltinTuple(right)"})
    public static PTuple doTuple(PTuple left, PTuple right, @Bind PythonLanguage language, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ConcatListOrTupleNode concatNode) {
        SequenceStorage concatenated = concatNode.execute(inliningTarget, left.getSequenceStorage(), right.getSequenceStorage());
        return PFactory.createTuple(language, concatenated);
    }

    @Specialization
    public static TruffleString doIt(TruffleString left, TruffleString right, @Cached TruffleString.ConcatNode concatNode) {
        return concatNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, PythonUtils.TS_ENCODING, false);
    }

    @Fallback
    public static Object doIt(VirtualFrame frame, Object v, Object w, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getVClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached.Exclusive @Cached GetClassNode getWClass, @Cached CallBinaryOp1Node callBinaryOp1Node, @Cached InlinedBranchProfile hasNbAddResult, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callBinarySlotNode, @Cached PRaiseNode raiseNode) {
        TpSlots slotsW;
        Object classV = getVClass.execute(inliningTarget, v);
        Object classW = getWClass.execute(inliningTarget, w);
        TpSlots slotsV = getVSlots.execute(inliningTarget, classV);
        Object result = callBinaryOp1Node.execute(frame, inliningTarget, v, classV, slotsV, w, classW, slotsW = getWSlots.execute(inliningTarget, classW), TpSlotBinaryOp.ReversibleSlot.NB_ADD);
        if (result != PNotImplemented.NOT_IMPLEMENTED) {
            hasNbAddResult.enter(inliningTarget);
            return result;
        }
        if (slotsV.sq_concat() != null) {
            return callBinarySlotNode.execute(frame, inliningTarget, slotsV.sq_concat(), v, w);
        }
        return CallBinaryOpNode.raiseNotSupported(inliningTarget, v, w, "+", raiseNode);
    }

    @NeverDefault
    public static PyNumberAddNode create() {
        return PyNumberAddNodeGen.create();
    }

    public static PyNumberAddNode getUncached() {
        return PyNumberAddNodeGen.getUncached();
    }
}

