# Welcome to radare2
--label:title

Please check the version below and compare with git master:

`r2 -V`

Those slides will guide you thru the process of checking all the new features
introduced in r2-5.5.0

Lots and lots of bugs has been fixed in RBin, RAnal, RIO, RCore, .. many of them
are critical, so we encourage everyone to update to this new version to be safe.

# make style

There was already a nice command 'aflm' which lists all the functions
following a makefile-style output. This is very handy to have a quick
look on which functions call which, but it was not enough for covering
all the xrefs information.

This new release adds 'axfm' and 'axtm', please press ':' and try it out
in different binaries after running 'aaa' to get some code analysed.

# Faster arm64 xrefs

The Siguza's xref core plugin have been updated with improved argument
handling to make it easier to use. You may want to open an arm64 binary,
run 'sixref' and wait for results.

Performance and results can be compared to 'aar' or 'aae' commands.

# Multiarch assemblers

The 'r2pm -ci vasm' command will install an assembler tool for each architecture,
this is integrated with r2 by using the 'vasm' assembler plugin, the asm.arch
is then taken by the text before '.vasm'

This is an optional feature, so it's also optional to test it unless you
are looking for modiying binaries for the supported architectures.

Supported archs:

* arm.vasm, 6502.vasm, 6809, c16x, jagrisc, m68k,
* pdp11, ppc, qnice, tr3200, vidcore, x86, z80"

Try it out with:

$ rasm2 -a z80.vasm nop

# Global Variables

As being one of the requested features for decompiler integration, and being already
something possible to do but not really surfacing it as a separate command, this
release adds the new 'avg' command which acts as a frontend for RFlag and RMeta to
associate a name in an offset with a type and a format string derived from the type.

You can test the 'avg' command like this:

> avg int foo @ $$
> pd 1

# All Bins

You can now select ONE or ALL binaries with 'ob 1' or 'ob *' and then all 'i' subcommands
will show the symbols, imports, libraries, strings.. for all the loaded bins.

Use this script for testing:

$ r2 /bin/ls
> is~?
> o /bin/sleep
> ob *
> is~?

# Multidex

Using the apk:// uri will now load all the classes*.dex inside the binary, and eventually
the shared libraries for the given arch/bits pair.

# Comma Suffix

The comma ',' suffix char is used for querying the table api generated by a command,
you can try things like this:

> f,?
> is, ?

And then try queries like this:

> f,

# IO Banks

See the new 'omb' command to create, switch and delete io banks, which are basically
groups of maps with predefined priority. Which will be used for kernel/userland
emulation as well as gameboy rom memory bank switching, thread local storage analysis
and more!

> omb

# Braile graphs

This command was already there for a long time, but recently a heap overflow was
spotted in the canvas pixel rendering loop, which was making the command not very
safe to use. Now the bug is fixed, so you can now test it and report any issue if
found!

> af
> agfb

Braile UTF8 chars permit to create pixel-art style using terminals, which permits
a higher resolution than using ascii-art. This is used when the minigraph option
is set.

# vector35 armv7

The 32bit arm disassembler from vector35 is now included in r2, still in beta as
long as no analysis or emulation is supported yet.

Open your favourite arm32 binary like this:

> r2 -a arm.v35 -b32 ...

Note that the v35 thumb2 disassembler is written in c++ and it can't be shipped
in r2core because it violates the 1st rule in r2land, so it may wait for
contributors to rewrite it in plain C.

# large disasms

There was a 15 year old bug fixed in the previous release, that was affecting
'pd' and 'pi' commands with a large numeric argument. Now 'pdi' joins the party.

You can test this by comparing the output of previous versions of r2 of this:

> pd 9999~invalid

# help messages

This release has increased the coverage of self-documentation by using the recursive
command help command you can discover new commands '?*', but some of them are not
handling the '?' suffix and it will be good to improve the situation by adding more
command descriptions and examples for all of them.

To test this new feature you can use '?*' and append '?' to the commands you use
more frequently and report an issue if no help is printed.

# Signatures

New metadata information is now saved and used in signatures!

Regenerate your signatures if you had any and test all the new metrics as it may
improve function matching quite a lot.

Use the 'z' command and its subcommands after 'aaa' to generate them.

> zg

Then use 'z/' to search for them after reloading the binary.

# Panels

The panels interface and visual mode has been improved and tested on more terminals,
please use the 'v' or 'V!' (visual toggle-panels) commands, use the keyboard or
mouse, create your layout, use tabs, scroll in panes... and cache contents.

You will notice it's now way more reliable and handy as it behaves better than
before, please if you like and use panels we would like to hear from you to get
some feedback or patches to improve the situation.

# Thanks



          THANKS FOR TESTING!



     Please report anything you find!
