/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlRefCountHolder;
import com.intellij.xml.util.XmlUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlUnusedNamespaceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(this){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                PsiFile psiFile;
                if (attribute == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((psiFile = holder.getFile()) instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refCountHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)psiFile);
                if (refCountHolder == null) {
                    return;
                }
                @Nullable XmlTag parent = attribute.getParent();
                if (parent == null) {
                    return;
                }
                if (!attribute.isNamespaceDeclaration()) {
                    if (XmlUnusedNamespaceInspection.getDefaultLocation(parent) == attribute) {
                        for (XmlAttribute other : parent.getAttributes()) {
                            if (!other.isNamespaceDeclaration()) continue;
                            String namespace = other.getValue();
                            String declaredPrefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(other);
                            if (namespace == null || refCountHolder.isInUse(declaredPrefix) || !declaredPrefix.isEmpty() || XmlUnusedNamespaceInspection.isUsedImplicitly(other)) continue;
                            holder.registerProblem((PsiElement)attribute, XmlAnalysisBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, true, true)});
                            return;
                        }
                    }
                    XmlUnusedNamespaceInspection.checkUnusedLocations(attribute, holder, refCountHolder);
                    return;
                }
                String namespace = attribute.getValue();
                String declaredPrefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
                if (namespace != null && !refCountHolder.isInUse(declaredPrefix)) {
                    if (XmlUnusedNamespaceInspection.isUsedImplicitly(attribute)) {
                        return;
                    }
                    XmlAttributeValue value = attribute.getValueElement();
                    assert (value != null);
                    holder.registerProblem((PsiElement)attribute, XmlAnalysisBundle.message((String)"xml.inspections.unused.schema.declaration", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, false, !refCountHolder.isUsedNamespace(namespace))});
                    if (!declaredPrefix.isEmpty() && !refCountHolder.isUsedNamespace(namespace)) {
                        for (PsiReference reference : XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent)) {
                            if (XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
                            holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlAnalysisBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceDeclarationFix(declaredPrefix, true, true)});
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$1", "visitXmlAttribute"));
            }
        };
    }

    private static boolean isUsedImplicitly(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(1);
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitUsage((PsiElement)attribute)) continue;
            return true;
        }
        return false;
    }

    private static void removeReferencesOrAttribute(PsiReference[] references) {
        if (references.length == 0) {
            return;
        }
        XmlAttributeValue element = (XmlAttributeValue)references[0].getElement();
        XmlAttribute attribute = (XmlAttribute)element.getParent();
        if (element.getReferences().length == references.length) {
            attribute.delete();
            return;
        }
        PsiFile psiFile = element.getContainingFile();
        Project project = psiFile.getProject();
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)attribute);
        for (PsiReference reference : references) {
            RemoveNamespaceDeclarationFix.removeReferenceText(reference);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        documentManager.commitDocument(document);
        String trimmed = element.getValue().trim();
        XmlAttribute pointerElement = (XmlAttribute)pointer.getElement();
        assert (pointerElement != null);
        pointerElement.setValue(trimmed);
    }

    private static void checkUnusedLocations(XmlAttribute attribute, ProblemsHolder holder, @NotNull XmlRefCountHolder refCountHolder) {
        if (refCountHolder == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(2);
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            if ("noNamespaceSchemaLocation".equals(attribute.getLocalName())) {
                if (refCountHolder.isInUse("")) {
                    return;
                }
                holder.registerProblem((PsiElement)attribute, XmlAnalysisBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveNamespaceLocationFix("")});
            } else if ("schemaLocation".equals(attribute.getLocalName())) {
                XmlAttributeValue value = attribute.getValueElement();
                if (value == null) {
                    return;
                }
                PsiReference[] references = value.getReferences();
                int referencesLength = references.length;
                for (int i = 0; i < referencesLength; ++i) {
                    PsiReference nextRef;
                    PsiReference reference = references[i];
                    if (!(reference instanceof URLReference)) continue;
                    String ns = XmlUnusedNamespaceInspection.getNamespaceFromReference(reference);
                    if (ArrayUtil.indexOf((Object[])attribute.getParent().knownNamespaces(), (Object)ns) != -1 || refCountHolder.isUsedNamespace(ns)) continue;
                    if (!XmlHighlightVisitor.hasBadResolve(reference, false)) {
                        holder.registerProblemForReference(reference, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlAnalysisBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceLocationFix(ns)});
                    }
                    for (int j = i + 1; j < referencesLength && !((nextRef = references[j]) instanceof URLReference); ++j) {
                        if (XmlHighlightVisitor.hasBadResolve(nextRef, false)) continue;
                        holder.registerProblemForReference(nextRef, ProblemHighlightType.LIKE_UNUSED_SYMBOL, XmlAnalysisBundle.message((String)"xml.inspections.unused.schema.location", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveNamespaceLocationFix(ns)});
                    }
                }
            }
        }
    }

    private static String getDeclaredPrefix(XmlAttribute attribute) {
        return attribute.getName().contains(":") ? attribute.getLocalName() : "";
    }

    @Nullable
    private static XmlAttribute getDefaultLocation(@NotNull XmlTag parent) {
        if (parent == null) {
            XmlUnusedNamespaceInspection.$$$reportNull$$$0(3);
        }
        return parent.getAttribute("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlTag tag) {
        XmlAttribute locationAttr = tag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        if (locationAttr == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue value = locationAttr.getValueElement();
        return value == null ? PsiReference.EMPTY_ARRAY : XmlUnusedNamespaceInspection.getLocationReferences(namespace, value);
    }

    private static PsiReference[] getLocationReferences(String namespace, XmlAttributeValue value) {
        PsiReference[] references = value.getReferences();
        int referencesLength = references.length;
        for (int i = 0; i < referencesLength; i += 2) {
            PsiReference reference = references[i];
            if (!namespace.equals(XmlUnusedNamespaceInspection.getNamespaceFromReference(reference))) continue;
            if (i + 1 < referencesLength) {
                return new PsiReference[]{references[i + 1], reference};
            }
            return new PsiReference[]{reference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static String getNamespaceFromReference(PsiReference reference) {
        return reference.getRangeInElement().substring(reference.getElement().getText());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "XmlUnusedNamespaceDeclaration";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refCountHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedImplicitly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUnusedLocations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemoveNamespaceDeclarationFix
    implements LocalQuickFix {
        protected final String myPrefix;
        private final boolean myLocationFix;
        private final boolean myRemoveLocation;

        private RemoveNamespaceDeclarationFix(@Nullable String prefix, boolean locationFix, boolean removeLocation) {
            this.myPrefix = prefix;
            this.myLocationFix = locationFix;
            this.myRemoveLocation = removeLocation;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlAnalysisBundle.message((String)"xml.quickfix.remove.unused.namespace.decl", (Object[])new Object[0]);
            if (string == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveNamespaceDeclarationFix.$$$reportNull$$$0(3);
            }
            this.doFix(project, descriptor, true);
        }

        @Nullable
        public SmartPsiElementPointer<XmlTag> doFix(Project project, ProblemDescriptor descriptor, boolean reformat) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof XmlAttributeValue) {
                element = element.getParent();
            } else if (!(element instanceof XmlAttribute)) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag parent = attribute.getParent();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)parent);
            this.doRemove(project, attribute, parent);
            if (reformat) {
                RemoveNamespaceDeclarationFix.reformatStartTag(project, (SmartPsiElementPointer<? extends XmlTag>)pointer);
            }
            return pointer;
        }

        public static void reformatStartTag(Project project, SmartPsiElementPointer<? extends XmlTag> pointer) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = pointer.getContainingFile();
            assert (psiFile != null);
            Document document = psiFile.getViewProvider().getDocument();
            assert (document != null);
            manager.commitDocument(document);
            XmlTag tag = (XmlTag)pointer.getElement();
            assert (tag != null);
            XmlUtil.reformatTagStart((XmlTag)tag);
        }

        protected void doRemove(Project project, XmlAttribute attribute, XmlTag parent) {
            if (!attribute.isNamespaceDeclaration()) {
                SchemaPrefix schemaPrefix = DefaultXmlExtension.DEFAULT_EXTENSION.getPrefixDeclaration(parent, this.myPrefix);
                if (schemaPrefix != null) {
                    attribute = schemaPrefix.getDeclaration();
                } else {
                    return;
                }
            }
            String namespace = attribute.getValue();
            String prefix = XmlUnusedNamespaceInspection.getDeclaredPrefix(attribute);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = parent.getContainingFile().getViewProvider().getDocument();
            assert (document != null);
            attribute.delete();
            if (this.myRemoveLocation) {
                if (prefix.isEmpty()) {
                    XmlAttribute locationAttr = XmlUnusedNamespaceInspection.getDefaultLocation(parent);
                    if (locationAttr != null) {
                        locationAttr.delete();
                    }
                } else {
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(namespace, parent);
                    XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
                    documentManager.commitDocument(document);
                }
            }
        }

        public static void removeReferenceText(PsiReference ref) {
            PsiElement element = ref.getElement();
            PsiFile psiFile = element.getContainingFile();
            TextRange range = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            Document document = psiFile.getViewProvider().getDocument();
            assert (document != null);
            PsiDocumentManager.getInstance((Project)psiFile.getProject()).doPostponedOperationsAndUnblockDocument(document);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }

        public boolean equals(Object obj) {
            return obj instanceof RemoveNamespaceDeclarationFix && Objects.equals(this.myPrefix, ((RemoveNamespaceDeclarationFix)obj).myPrefix) && (this.myLocationFix || ((RemoveNamespaceDeclarationFix)obj).myLocationFix);
        }

        public int hashCode() {
            return this.myPrefix == null ? 0 : this.myPrefix.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceDeclarationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class RemoveNamespaceLocationFix
    extends RemoveNamespaceDeclarationFix {
        private RemoveNamespaceLocationFix(String namespace) {
            super(namespace, true, true);
        }

        @Override
        @NotNull
        public String getName() {
            String string = XmlAnalysisBundle.message((String)"xml.intention.remove.unused.namespace.location", (Object[])new Object[0]);
            if (string == null) {
                RemoveNamespaceLocationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doRemove(Project project, XmlAttribute attribute, XmlTag parent) {
            if (StringUtil.isEmpty((String)this.myPrefix)) {
                attribute.delete();
            } else {
                XmlAttributeValue value = attribute.getValueElement();
                if (value == null) {
                    return;
                }
                PsiReference[] references = XmlUnusedNamespaceInspection.getLocationReferences(this.myPrefix, value);
                XmlUnusedNamespaceInspection.removeReferencesOrAttribute(references);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnusedNamespaceInspection$RemoveNamespaceLocationFix", "getName"));
        }
    }
}

