/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class EscapeSequenceTokenizer<T extends PsiElement>
extends Tokenizer<T> {
    private static final Key<int[]> ESCAPE_OFFSETS = Key.create((String)"escape.tokenizer.offsets");

    public static void processTextWithOffsets(PsiElement element, TokenConsumer consumer, StringBuilder unescapedText, int[] offsets, int startOffset) {
        if (element != null) {
            element.putUserData(ESCAPE_OFFSETS, (Object)offsets);
        }
        String text = unescapedText.toString();
        consumer.consumeToken(element, text, false, startOffset, TextRange.allOf((String)text), PlainTextSplitter.getInstance());
        if (element != null) {
            element.putUserData(ESCAPE_OFFSETS, null);
        }
    }

    @Override
    @NotNull
    public TextRange getHighlightingRange(@NotNull PsiElement element, int offset, @NotNull TextRange range) {
        int[] offsets;
        if (element == null) {
            EscapeSequenceTokenizer.$$$reportNull$$$0(0);
        }
        if (range == null) {
            EscapeSequenceTokenizer.$$$reportNull$$$0(1);
        }
        if ((offsets = (int[])element.getUserData(ESCAPE_OFFSETS)) != null) {
            int start = offsets[range.getStartOffset()];
            int end = offsets[range.getEndOffset()];
            return new TextRange(offset + start, offset + end);
        }
        TextRange textRange = super.getHighlightingRange(element, offset, range);
        if (textRange == null) {
            EscapeSequenceTokenizer.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/tokenizer/EscapeSequenceTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/tokenizer/EscapeSequenceTokenizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingRange";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

