/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.cls;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.cls.AbstractOWLClassAxiomFrameSection;
import org.protege.editor.owl.ui.frame.cls.OWLEquivalentClassesAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OWLEquivalentClassesAxiomFrameSection
extends AbstractOWLClassAxiomFrameSection<OWLEquivalentClassesAxiom, OWLClassExpression> {
    private static final String LABEL = "Equivalent To";
    private Set<OWLClassExpression> added = new HashSet<OWLClassExpression>();
    private boolean inferredEquivalentClasses = true;

    public OWLEquivalentClassesAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<OWLClass> frame) {
        super(editorKit, LABEL, "Equivalent class", (OWLFrame<? extends OWLClassExpression>)frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void addAxiom(OWLEquivalentClassesAxiom ax, OWLOntology ontology) {
        this.addRow(new OWLEquivalentClassesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, this.getRootObject(), ax));
        for (OWLClassExpression desc : ax.getClassExpressions()) {
            this.added.add(desc);
        }
    }

    @Override
    protected Set<OWLEquivalentClassesAxiom> getClassAxioms(OWLClassExpression descr, OWLOntology ont) {
        if (!descr.isAnonymous()) {
            return ont.getEquivalentClassesAxioms(descr.asOWLClass());
        }
        HashSet<OWLEquivalentClassesAxiom> axioms = new HashSet<OWLEquivalentClassesAxiom>();
        for (OWLAxiom ax : ont.getGeneralClassAxioms()) {
            if (!(ax instanceof OWLEquivalentClassesAxiom) || !((OWLEquivalentClassesAxiom)ax).getClassExpressions().contains(descr)) continue;
            axioms.add((OWLEquivalentClassesAxiom)ax);
        }
        return axioms;
    }

    @Override
    protected void refillInferred() {
        if (!this.inferredEquivalentClasses) {
            return;
        }
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_EQUIVALENT_CLASSES, () -> {
            OWLReasoner reasoner = this.getOWLModelManager().getReasoner();
            if (!reasoner.isConsistent()) {
                return;
            }
            if (!reasoner.isSatisfiable(this.getRootObject())) {
                if (!this.getRootObject().isOWLNothing()) {
                    OWLClass nothing = this.getOWLModelManager().getOWLDataFactory().getOWLNothing();
                    this.addRow(new OWLEquivalentClassesAxiomFrameSectionRow(this.getOWLEditorKit(), this, null, this.getRootObject(), this.getOWLDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{this.getRootObject(), nothing}))));
                }
            } else {
                for (OWLClassExpression cls : reasoner.getEquivalentClasses(this.getRootObject())) {
                    if (this.added.contains(cls) || cls.equals((Object)this.getRootObject())) continue;
                    this.addRow(new OWLEquivalentClassesAxiomFrameSectionRow(this.getOWLEditorKit(), this, null, this.getRootObject(), this.getOWLDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{this.getRootObject(), cls}))));
                }
            }
        });
    }

    @Override
    protected OWLEquivalentClassesAxiom createAxiom(OWLClassExpression object) {
        return this.getOWLDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{this.getRootObject(), object}));
    }

    @Override
    public OWLObjectEditor<OWLClassExpression> getObjectEditor() {
        return this.getOWLEditorKit().getWorkspace().getOWLComponentFactory().getOWLClassDescriptionEditor(null, AxiomType.EQUIVALENT_CLASSES);
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<OWLClassExpression> editor) {
        Set<OWLClassExpression> equivalents = editor.getEditedObjects();
        return equivalents.size() != 1 || !equivalents.contains(this.getRootObject());
    }

    @Override
    public void handleEditingFinished(Set<OWLClassExpression> editedObjects) {
        editedObjects = new HashSet<OWLClassExpression>(editedObjects);
        editedObjects.remove(this.getRootObject());
        super.handleEditingFinished(editedObjects);
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) {
                OWLClassExpression desc = (OWLClassExpression)obj;
                OWLEquivalentClassesAxiom ax = this.getOWLDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{this.getRootObject(), desc}));
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLEquivalentClassesAxiom && ((OWLEquivalentClassesAxiom)change.getAxiom()).getClassExpressions().contains(this.getRootObject());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLClassExpression, OWLEquivalentClassesAxiom, OWLClassExpression>> getRowComparator() {
        return null;
    }
}

