/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import com.google.auto.value.processor.AbortProcessingException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ErrorReporter {
    private final Messager messager;
    private boolean anyErrors;

    ErrorReporter(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    void reportNote(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg, e);
    }

    void reportWarning(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg, e);
    }

    void reportError(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
        this.anyErrors = true;
    }

    void abortWithError(String msg, Element e) {
        this.reportError(msg, e);
        throw new AbortProcessingException();
    }

    void abortIfAnyError() {
        if (this.anyErrors) {
            throw new AbortProcessingException();
        }
    }
}

