/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    private static final int COMPRESSION_LIMIT = 160;
    private final LiteralWrapper literal;
    @Nonnull
    static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final String language;

    @Override
    protected int index() {
        return 4008;
    }

    public OWLLiteralImpl(@Nonnull String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = new LiteralWrapper(OWLAPIPreconditions.checkNotNull(literal, "literal cannot be null"));
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null ? RDF_PLAIN_LITERAL : datatype;
        } else {
            if (datatype != null && !datatype.isRDFPlainLiteral()) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = RDF_PLAIN_LITERAL;
        }
        this.hashCode = this.getHashCode(literal);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add(this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    public String getLiteral() {
        return this.literal.get();
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.datatype.getIRI().equals(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    }

    @Override
    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    @Override
    public boolean isInteger() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_INTEGER.getIRI());
    }

    @Override
    public int parseInteger() {
        return Integer.parseInt(this.literal.get());
    }

    @Override
    public boolean isBoolean() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    @Override
    public boolean parseBoolean() {
        if (this.literal.get().equals("0")) {
            return false;
        }
        if (this.literal.get().equals("1")) {
            return true;
        }
        if (this.literal.get().equals("true")) {
            return true;
        }
        if (this.literal.get().equals("false")) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isDouble() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    @Override
    public double parseDouble() {
        return Double.parseDouble(this.literal.get());
    }

    @Override
    public boolean isFloat() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_FLOAT.getIRI());
    }

    @Override
    public float parseFloat() {
        return Float.parseFloat(this.literal.get());
    }

    @Override
    public String getLang() {
        return this.language;
    }

    @Override
    public boolean hasLang(String lang) {
        if (lang == null) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode(String lit) {
        int code = 277;
        OWLDatatype datatype2 = this.getDatatype();
        if (datatype2.equals(RDF_PLAIN_LITERAL) || datatype2.getIRI().equals(OWL2Datatype.XSD_STRING.getIRI()) || datatype2.getIRI().equals(OWLRDFVocabulary.RDF_LANG_STRING.getIRI())) {
            datatype2 = RDF_PLAIN_LITERAL;
        }
        code = code * 37 + datatype2.hashCode();
        code *= 37;
        try {
            code = this.isInteger() ? (code += this.parseInteger() * 65536) : (this.isDouble() ? (code += (int)this.parseDouble() * 65536) : (this.isFloat() ? (code += (int)this.parseFloat() * 65536) : (this.isBoolean() ? (code += this.parseBoolean() ? 65536 : 0) : (code += lit.hashCode() * 65536))));
        }
        catch (NumberFormatException e) {
            code += this.getLiteral().hashCode() * 65536;
        }
        if (this.hasLang()) {
            code = code * 37 + this.getLang().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        OWLLiteral other = (OWLLiteral)obj;
        return this.literal.get().equals(other.getLiteral()) && (this.getDatatype().equals(other.getDatatype()) || OWL2Datatype.XSD_STRING.getIRI().equals(other.getDatatype().getIRI()) || OWLRDFVocabulary.RDF_LANG_STRING.getIRI().equals(other.getDatatype().getIRI()) || OWL2Datatype.XSD_STRING.getIRI().equals(this.getDatatype().getIRI()) || OWLRDFVocabulary.RDF_LANG_STRING.getIRI().equals(this.getDatatype().getIRI())) && this.language.equals(other.getLang());
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        diff = this.literal.get().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        return this.language.compareTo(other.getLang());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }

    private static class LiteralWrapper
    implements Serializable {
        private static final long serialVersionUID = 40000L;
        String l;
        byte[] bytes;
        private static final String COMPRESSED_ENCODING = "UTF-16";

        LiteralWrapper(String s) {
            if (s.length() > 160) {
                try {
                    this.bytes = LiteralWrapper.compress(s);
                    this.l = null;
                }
                catch (IOException e) {
                    this.l = s;
                    this.bytes = null;
                }
            } else {
                this.bytes = null;
                this.l = s;
            }
        }

        @Nonnull
        String get() {
            if (this.l != null) {
                return OWLAPIPreconditions.verifyNotNull(this.l);
            }
            try {
                return LiteralWrapper.decompress(this.bytes);
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }

        @Nonnull
        static byte[] compress(String s) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream zipout = new GZIPOutputStream(out);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipout, COMPRESSED_ENCODING);
            writer.write(s);
            ((Writer)writer).flush();
            zipout.finish();
            zipout.flush();
            return out.toByteArray();
        }

        @Nonnull
        static String decompress(byte[] result) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(result);
            GZIPInputStream zipin = new GZIPInputStream(in);
            InputStreamReader reader = new InputStreamReader((InputStream)zipin, COMPRESSED_ENCODING);
            StringBuilder b = new StringBuilder();
            int c = ((Reader)reader).read();
            while (c > -1) {
                b.append((char)c);
                c = ((Reader)reader).read();
            }
            return b.toString();
        }
    }
}

