/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.core.VerifyArgument;
import com.strobel.util.EmptyArrayCache;
import java.nio.BufferUnderflowException;
import java.util.Arrays;

public class Buffer {
    private static final int DEFAULT_SIZE = 64;
    private byte[] _data;
    private int _length;
    private int _position;

    public Buffer() {
        this._data = new byte[64];
        this._length = 64;
    }

    public Buffer(byte[] data) {
        this._data = VerifyArgument.notNull(data, "data");
        this._length = data.length;
    }

    public Buffer(int initialSize) {
        this._data = new byte[initialSize];
        this._length = initialSize;
    }

    public int size() {
        return this._length;
    }

    public void flip() {
        this._length = this._position;
        this._position = 0;
    }

    public int position() {
        return this._position;
    }

    public void position(int position) {
        if (position > this._length) {
            throw new BufferUnderflowException();
        }
        this._position = position;
    }

    public void advance(int length) {
        if (this._position + length > this._length) {
            this._position = this._length;
            throw new BufferUnderflowException();
        }
        this._position += length;
    }

    public void reset() {
        this.reset(64);
    }

    public void reset(int initialSize) {
        if (VerifyArgument.isNonNegative(initialSize, "initialSize") == 0) {
            this._data = EmptyArrayCache.EMPTY_BYTE_ARRAY;
        } else if (initialSize > this._data.length || initialSize < this._data.length / 4) {
            this._data = new byte[initialSize];
        }
        this._length = initialSize;
        this._position = 0;
    }

    public byte[] array() {
        return this._data;
    }

    public int read(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this._position >= this._length) {
            return -1;
        }
        int available = this._length - this._position;
        int actualLength = Math.min(length, available);
        if (actualLength <= 0) {
            return 0;
        }
        System.arraycopy(this._data, this._position, buffer, offset, actualLength);
        this._position += actualLength;
        return actualLength;
    }

    public String readUtf8() {
        int ch;
        int count;
        int utfLength = this.readUnsignedShort();
        byte[] byteBuffer = new byte[utfLength];
        char[] charBuffer = new char[utfLength];
        int charactersRead = 0;
        this.read(byteBuffer, 0, utfLength);
        for (count = 0; count < utfLength && (ch = byteBuffer[count] & 0xFF) <= 127; ++count) {
            charBuffer[charactersRead++] = (char)ch;
        }
        block6: while (count < utfLength) {
            ch = byteBuffer[count] & 0xFF;
            switch (ch & 0xE0) {
                case 0: 
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: 
                case 96: 
                case 112: {
                    ++count;
                    charBuffer[charactersRead++] = (char)ch;
                    continue block6;
                }
                case 192: {
                    if ((count += 2) > utfLength) {
                        throw new IllegalStateException("malformed input: partial character at end");
                    }
                    byte ch2 = byteBuffer[count - 1];
                    if ((ch2 & 0xC0) != 128) {
                        throw new IllegalStateException("malformed input around byte " + count);
                    }
                    charBuffer[charactersRead++] = (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
                    continue block6;
                }
                case 224: {
                    if ((count += 3) > utfLength) {
                        throw new IllegalStateException("malformed input: partial character at end");
                    }
                    byte ch2 = byteBuffer[count - 2];
                    byte ch3 = byteBuffer[count - 1];
                    if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        throw new IllegalStateException("malformed input around byte " + (count - 1));
                    }
                    charBuffer[charactersRead++] = (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | (ch3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new IllegalStateException("malformed input around byte " + count);
        }
        return new String(charBuffer, 0, charactersRead);
    }

    public byte readByte() {
        this.verifyReadableBytes(1);
        return this._data[this._position++];
    }

    public int readUnsignedByte() {
        this.verifyReadableBytes(1);
        return this._data[this._position++] & 0xFF;
    }

    public short readShort() {
        this.verifyReadableBytes(2);
        return (short)((this.readUnsignedByte() << 8) + (this.readUnsignedByte() << 0));
    }

    public int readUnsignedShort() {
        this.verifyReadableBytes(2);
        return (this.readUnsignedByte() << 8) + (this.readUnsignedByte() << 0);
    }

    public int readInt() {
        this.verifyReadableBytes(4);
        return (this.readUnsignedByte() << 24) + (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + (this.readUnsignedByte() << 0);
    }

    public long readLong() {
        this.verifyReadableBytes(8);
        return ((long)this.readUnsignedByte() << 56) + ((long)this.readUnsignedByte() << 48) + ((long)this.readUnsignedByte() << 40) + ((long)this.readUnsignedByte() << 32) + ((long)this.readUnsignedByte() << 24) + ((long)this.readUnsignedByte() << 16) + ((long)this.readUnsignedByte() << 8) + ((long)this.readUnsignedByte() << 0);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public Buffer writeByte(int b) {
        this.ensureWriteableBytes(1);
        this._data[this._position++] = (byte)(b & 0xFF);
        return this;
    }

    public Buffer writeShort(int s) {
        this.ensureWriteableBytes(2);
        this._data[this._position++] = (byte)(s >>> 8 & 0xFF);
        this._data[this._position++] = (byte)(s & 0xFF);
        return this;
    }

    public Buffer writeInt(int i) {
        this.ensureWriteableBytes(4);
        this._data[this._position++] = (byte)(i >>> 24 & 0xFF);
        this._data[this._position++] = (byte)(i >>> 16 & 0xFF);
        this._data[this._position++] = (byte)(i >>> 8 & 0xFF);
        this._data[this._position++] = (byte)(i & 0xFF);
        return this;
    }

    public Buffer writeLong(long l) {
        this.ensureWriteableBytes(8);
        int i = (int)(l >>> 32);
        this._data[this._position++] = (byte)(i >>> 24 & 0xFF);
        this._data[this._position++] = (byte)(i >>> 16 & 0xFF);
        this._data[this._position++] = (byte)(i >>> 8 & 0xFF);
        this._data[this._position++] = (byte)(i & 0xFF);
        i = (int)l;
        this._data[this._position++] = (byte)(i >>> 24 & 0xFF);
        this._data[this._position++] = (byte)(i >>> 16 & 0xFF);
        this._data[this._position++] = (byte)(i >>> 8 & 0xFF);
        this._data[this._position++] = (byte)(i & 0xFF);
        return this;
    }

    public Buffer writeFloat(float f) {
        return this.writeInt(Float.floatToRawIntBits(f));
    }

    public Buffer writeDouble(double d) {
        return this.writeLong(Double.doubleToRawLongBits(d));
    }

    public Buffer writeUtf8(String s) {
        int charLength = s.length();
        this.ensureWriteableBytes(2 + charLength);
        this._data[this._position++] = (byte)(charLength >>> 8);
        this._data[this._position++] = (byte)charLength;
        for (int i = 0; i < charLength; ++i) {
            int j;
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this._data[this._position++] = (byte)c;
                continue;
            }
            int byteLength = i;
            for (j = i; j < charLength; ++j) {
                c = s.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++byteLength;
                    continue;
                }
                if (c > '\u07ff') {
                    byteLength += 3;
                    continue;
                }
                byteLength += 2;
            }
            this._data[this._position] = (byte)(byteLength >>> 8);
            this._data[this._position + 1] = (byte)byteLength;
            this.ensureWriteableBytes(2 + byteLength);
            for (j = i; j < charLength; ++j) {
                c = s.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    this._data[this._position++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    this._data[this._position++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this._data[this._position++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this._data[this._position++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                this._data[this._position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this._data[this._position++] = (byte)(0x80 | c & 0x3F);
            }
            break;
        }
        return this;
    }

    public Buffer putByteArray(byte[] b, int offset, int length) {
        this.ensureWriteableBytes(length);
        if (b != null) {
            System.arraycopy(b, offset, this._data, this._position, length);
        }
        this._position += length;
        return this;
    }

    protected void verifyReadableBytes(int size) {
        if (VerifyArgument.isNonNegative(size, "size") > 0 && this._position + size > this._length) {
            throw new BufferUnderflowException();
        }
    }

    protected void ensureWriteableBytes(int size) {
        int minLength = this._position + size;
        if (minLength > this._data.length) {
            int length1 = 2 * this._data.length;
            int length2 = this._position + size;
            this._data = Arrays.copyOf(this._data, Math.max(length1, length2));
        }
        this._length = Math.max(minLength, this._length);
    }
}

