/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.p4nodes.bk.BKAlignedLayout;
import org.eclipse.elk.alg.layered.p4nodes.bk.BKNodePlacer;
import org.eclipse.elk.alg.layered.p4nodes.bk.NeighborhoodInformation;
import org.eclipse.elk.core.util.Pair;

public class BKAligner {
    private LGraph layeredGraph;
    private NeighborhoodInformation ni;

    public BKAligner(LGraph layeredGraph, NeighborhoodInformation ni) {
        this.layeredGraph = layeredGraph;
        this.ni = ni;
    }

    public void verticalAlignment(BKAlignedLayout bal, Set<LEdge> markedEdges) {
        for (Layer layer : this.layeredGraph.getLayers()) {
            Iterator<LNode> iterator = layer.getNodes().iterator();
            while (iterator.hasNext()) {
                LNode v;
                bal.root[v.id] = v = iterator.next();
                bal.align[v.id] = v;
                bal.innerShift[v.id] = 0.0;
            }
        }
        List<Layer> layers = this.layeredGraph.getLayers();
        if (bal.hdir == BKAlignedLayout.HDirection.LEFT) {
            layers = Lists.reverse(layers);
        }
        for (Layer layer : layers) {
            int r = -1;
            List<LNode> nodes = layer.getNodes();
            if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                r = Integer.MAX_VALUE;
                nodes = Lists.reverse(nodes);
            }
            for (LNode v_i_k : nodes) {
                int m;
                List<Pair<LNode, LEdge>> neighbors = null;
                neighbors = bal.hdir == BKAlignedLayout.HDirection.LEFT ? this.ni.rightNeighbors.get(v_i_k.id) : this.ni.leftNeighbors.get(v_i_k.id);
                if (neighbors.size() <= 0) continue;
                int d = neighbors.size();
                int low = (int)Math.floor(((double)d + 1.0) / 2.0) - 1;
                int high = (int)Math.ceil(((double)d + 1.0) / 2.0) - 1;
                if (bal.vdir == BKAlignedLayout.VDirection.UP) {
                    m = high;
                    while (m >= low) {
                        if (bal.align[v_i_k.id].equals(v_i_k)) {
                            Pair<LNode, LEdge> u_m_pair = neighbors.get(m);
                            LNode u_m = u_m_pair.getFirst();
                            if (!markedEdges.contains(u_m_pair.getSecond()) && r > this.ni.nodeIndex[u_m.id]) {
                                bal.align[u_m.id] = v_i_k;
                                bal.root[v_i_k.id] = bal.root[u_m.id];
                                bal.align[v_i_k.id] = bal.root[v_i_k.id];
                                int n = bal.root[v_i_k.id].id;
                                bal.od[n] = bal.od[n] & v_i_k.getType() == LNode.NodeType.LONG_EDGE;
                                r = this.ni.nodeIndex[u_m.id];
                            }
                        }
                        --m;
                    }
                    continue;
                }
                m = low;
                while (m <= high) {
                    if (bal.align[v_i_k.id].equals(v_i_k)) {
                        Pair<LNode, LEdge> um_pair = neighbors.get(m);
                        LNode um = um_pair.getFirst();
                        if (!markedEdges.contains(um_pair.getSecond()) && r < this.ni.nodeIndex[um.id]) {
                            bal.align[um.id] = v_i_k;
                            bal.root[v_i_k.id] = bal.root[um.id];
                            bal.align[v_i_k.id] = bal.root[v_i_k.id];
                            int n = bal.root[v_i_k.id].id;
                            bal.od[n] = bal.od[n] & v_i_k.getType() == LNode.NodeType.LONG_EDGE;
                            r = this.ni.nodeIndex[um.id];
                        }
                    }
                    ++m;
                }
            }
        }
    }

    public void insideBlockShift(BKAlignedLayout bal) {
        Map<LNode, List<LNode>> blocks = BKNodePlacer.getBlocks(bal);
        for (LNode root : blocks.keySet()) {
            LNode next;
            double spaceAbove = 0.0;
            double spaceBelow = 0.0;
            spaceAbove = root.getMargin().top;
            spaceBelow = root.getSize().y + root.getMargin().bottom;
            bal.innerShift[root.id] = 0.0;
            LNode current = root;
            while ((next = bal.align[current.id]) != root) {
                LEdge edge = BKNodePlacer.getEdge(current, next);
                double portPosDiff = 0.0;
                portPosDiff = bal.hdir == BKAlignedLayout.HDirection.LEFT ? edge.getTarget().getPosition().y + edge.getTarget().getAnchor().y - edge.getSource().getPosition().y - edge.getSource().getAnchor().y : edge.getSource().getPosition().y + edge.getSource().getAnchor().y - edge.getTarget().getPosition().y - edge.getTarget().getAnchor().y;
                double nextInnerShift = bal.innerShift[current.id] + portPosDiff;
                bal.innerShift[next.id] = nextInnerShift;
                spaceAbove = Math.max(spaceAbove, next.getMargin().top - nextInnerShift);
                spaceBelow = Math.max(spaceBelow, nextInnerShift + next.getSize().y + next.getMargin().bottom);
                current = next;
            }
            current = root;
            do {
                bal.innerShift[current.id] = bal.innerShift[current.id] + spaceAbove;
            } while ((current = bal.align[current.id]) != root);
            bal.blockSize[root.id] = spaceAbove + spaceBelow;
        }
    }
}

