/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.AbstractInstruction;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileSplit;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtiles;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;

public class InstructionSplit
extends AbstractInstruction
implements Instruction {
    private final List<InstructionList> splits = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;
    private final Swimlane swimlaneIn;
    private Swimlane swimlaneOut;

    public InstructionSplit(Instruction parent, LinkRendering inlinkRendering, Swimlane swimlane) {
        this.parent = parent;
        this.swimlaneIn = swimlane;
        this.splits.add(new InstructionList(swimlane));
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
    }

    @Override
    public boolean containsBreak() {
        for (InstructionList split : this.splits) {
            if (!split.containsBreak()) continue;
            return true;
        }
        return false;
    }

    private InstructionList getLast() {
        return this.splits.get(this.splits.size() - 1);
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.getLast().add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        ArrayList<Gtile> all = new ArrayList<Gtile>();
        for (InstructionList list : this.splits) {
            Gtile tmp = list.createGtile(skinParam, stringBounder);
            tmp = Gtiles.withIncomingArrow(tmp, 20.0);
            tmp = Gtiles.withOutgoingArrow(tmp, 20.0);
            all.add(tmp);
        }
        return new GtileSplit(all, this.swimlaneIn, this.getInLinkRenderingColor(skinParam).getColor());
    }

    private Rainbow getInLinkRenderingColor(ISkinParam skinParam) {
        Rainbow color = Rainbow.build(skinParam);
        return color;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.splits) {
            all.add(list.createFtile(factory));
        }
        return factory.createParallel(all, ForkStyle.SPLIT, null, this.swimlaneIn, this.swimlaneOut);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void splitAgain(LinkRendering inlinkRendering) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        InstructionList list = new InstructionList(this.swimlaneIn);
        this.splits.add(list);
    }

    public void endSplit(LinkRendering inlinkRendering, Swimlane endSwimlane) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        this.swimlaneOut = endSwimlane;
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote, Stereotype stereotype) {
        return this.getLast().addNote(note, position, type, colors, swimlaneNote, stereotype);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.splits);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlaneOut;
    }
}

