/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.Bits;

class EmptyFilterLeafReader
extends FilterLeafReader {
    final Bits liveDocs;

    public EmptyFilterLeafReader(LeafReader in) {
        super(in);
        this.liveDocs = new Bits.MatchNoBits(in.maxDoc());
        assert (this.maxDoc() == 0 || this.hasDeletions());
    }

    public Bits getLiveDocs() {
        return this.liveDocs;
    }

    public int numDocs() {
        return 0;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    static class EmptyDirectoryReader
    extends FilterDirectoryReader {
        public EmptyDirectoryReader(DirectoryReader in) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new EmptySubReaderWrapper());
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new EmptyDirectoryReader(in);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class EmptySubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private EmptySubReaderWrapper() {
        }

        public LeafReader wrap(LeafReader reader) {
            return new EmptyFilterLeafReader(reader);
        }
    }
}

