/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HunspellTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, HunspellTokenFilter> {
    @Nullable
    private final Boolean dedup;
    @Nullable
    private final String dictionary;
    @Nonnull
    private final String locale;
    @Nullable
    private final Boolean longestOnly;
    public static final JsonpDeserializer<HunspellTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HunspellTokenFilter::setupHunspellTokenFilterDeserializer);

    private HunspellTokenFilter(Builder builder) {
        super(builder);
        this.dedup = builder.dedup;
        this.dictionary = builder.dictionary;
        this.locale = ApiTypeHelper.requireNonNull(builder.locale, this, "locale");
        this.longestOnly = builder.longestOnly;
    }

    public static HunspellTokenFilter of(Function<Builder, ObjectBuilder<HunspellTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Hunspell;
    }

    @Nullable
    public final Boolean dedup() {
        return this.dedup;
    }

    @Nullable
    public final String dictionary() {
        return this.dictionary;
    }

    @Nonnull
    public final String locale() {
        return this.locale;
    }

    @Nullable
    public final Boolean longestOnly() {
        return this.longestOnly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "hunspell");
        super.serializeInternal(generator, mapper);
        if (this.dedup != null) {
            generator.writeKey("dedup");
            generator.write(this.dedup.booleanValue());
        }
        if (this.dictionary != null) {
            generator.writeKey("dictionary");
            generator.write(this.dictionary);
        }
        generator.writeKey("locale");
        generator.write(this.locale);
        if (this.longestOnly != null) {
            generator.writeKey("longest_only");
            generator.write(this.longestOnly.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHunspellTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        HunspellTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dedup, JsonpDeserializer.booleanDeserializer(), "dedup");
        op.add(Builder::dictionary, JsonpDeserializer.stringDeserializer(), "dictionary");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::longestOnly, JsonpDeserializer.booleanDeserializer(), "longest_only");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.dedup);
        result = 31 * result + Objects.hashCode(this.dictionary);
        result = 31 * result + this.locale.hashCode();
        result = 31 * result + Objects.hashCode(this.longestOnly);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HunspellTokenFilter other = (HunspellTokenFilter)o;
        return Objects.equals(this.dedup, other.dedup) && Objects.equals(this.dictionary, other.dictionary) && this.locale.equals(other.locale) && Objects.equals(this.longestOnly, other.longestOnly);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HunspellTokenFilter> {
        @Nullable
        private Boolean dedup;
        @Nullable
        private String dictionary;
        private String locale;
        @Nullable
        private Boolean longestOnly;

        public Builder() {
        }

        private Builder(HunspellTokenFilter o) {
            super(o);
            this.dedup = o.dedup;
            this.dictionary = o.dictionary;
            this.locale = o.locale;
            this.longestOnly = o.longestOnly;
        }

        private Builder(Builder o) {
            super(o);
            this.dedup = o.dedup;
            this.dictionary = o.dictionary;
            this.locale = o.locale;
            this.longestOnly = o.longestOnly;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder dedup(@Nullable Boolean value) {
            this.dedup = value;
            return this;
        }

        @Nonnull
        public final Builder dictionary(@Nullable String value) {
            this.dictionary = value;
            return this;
        }

        @Nonnull
        public final Builder locale(String value) {
            this.locale = value;
            return this;
        }

        @Nonnull
        public final Builder longestOnly(@Nullable Boolean value) {
            this.longestOnly = value;
            return this;
        }

        @Override
        @Nonnull
        public HunspellTokenFilter build() {
            this._checkSingleUse();
            return new HunspellTokenFilter(this);
        }
    }
}

