/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTopology;

public class DescribeInstanceTopologyPublisher
implements SdkPublisher<DescribeInstanceTopologyResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceTopologyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceTopologyPublisher(Ec2AsyncClient client, DescribeInstanceTopologyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceTopologyPublisher(Ec2AsyncClient client, DescribeInstanceTopologyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceTopologyResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceTopologyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceTopology> instances() {
        Function<DescribeInstanceTopologyResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceTopologyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceTopologyResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceTopologyResponse> {
        private DescribeInstanceTopologyResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceTopologyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceTopologyResponse> nextPage(DescribeInstanceTopologyResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceTopologyPublisher.this.client.describeInstanceTopology(DescribeInstanceTopologyPublisher.this.firstRequest);
            }
            return DescribeInstanceTopologyPublisher.this.client.describeInstanceTopology((DescribeInstanceTopologyRequest)((Object)DescribeInstanceTopologyPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

