/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.credentials;

import com.microsoft.windowsazure.core.utils.KeyStoreCredential;
import com.microsoft.windowsazure.core.utils.SSLContextFactory;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class CertificateCloudCredentials
extends SubscriptionCloudCredentials {
    private String subscriptionId;
    private KeyStoreCredential keyStoreCredential;
    private URI uri;

    public CertificateCloudCredentials() {
    }

    @Inject
    public CertificateCloudCredentials(@Named(value="management.uri") URI uri, @Named(value="management.subscription.id") String subscriptionId, KeyStoreCredential keyStoreCredential) {
        this.uri = uri;
        this.subscriptionId = subscriptionId;
        this.keyStoreCredential = keyStoreCredential;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public KeyStoreCredential getKeyStoreCredential() {
        return this.keyStoreCredential;
    }

    public void setKeyStoreCredential(KeyStoreCredential keyStoreCredential) {
        this.keyStoreCredential = keyStoreCredential;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public <T> void applyConfig(String profile, Map<String, Object> properties) {
        try {
            SSLContext sslContext = SSLContextFactory.create(this.getKeyStoreCredential());
            properties.put(profile + "com.microsoft.windowsazure.Configuration.sslConnectionSocketFactory", new SSLConnectionSocketFactory(sslContext));
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(CertificateCloudCredentials.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CertificateCloudCredentials.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

