/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.stats.suppliers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.ad.caching.ADCacheProvider;
import org.opensearch.ad.caching.ADPriorityCache;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.timeseries.ml.ModelState;

public class ADModelsOnNodeSupplier
implements Supplier<List<Map<String, Object>>> {
    private ADModelManager modelManager;
    private ADCacheProvider adCache;
    private volatile int adNumModelsToReturn;
    public static Set<String> MODEL_STATE_STAT_KEYS = new HashSet<String>(Arrays.asList("model_id", "detector_id", ModelState.MODEL_TYPE_KEY, "entity", ModelState.LAST_USED_TIME_KEY, ModelState.LAST_CHECKPOINT_TIME_KEY));

    public ADModelsOnNodeSupplier(ADModelManager modelManager, ADCacheProvider adCache, Settings settings, ClusterService clusterService) {
        this.modelManager = modelManager;
        this.adCache = adCache;
        this.adNumModelsToReturn = (Integer)AnomalyDetectorSettings.AD_MAX_MODEL_SIZE_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_MAX_MODEL_SIZE_PER_NODE, it -> {
            this.adNumModelsToReturn = it;
        });
    }

    @Override
    public List<Map<String, Object>> get() {
        Stream<Map> adStream = Stream.concat(this.modelManager.getAllModels().stream(), ((ADPriorityCache)this.adCache.get()).getAllModels().stream()).limit(this.adNumModelsToReturn).map(modelState -> modelState.getModelStateAsMap().entrySet().stream().filter(entry -> MODEL_STATE_STAT_KEYS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return adStream.collect(Collectors.toList());
    }
}

