/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.AbstractObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.support.ValueType;

public class CompositeValuesSourceParserHelper {
    private static final int AGGREGATION_TYPE_REFERENCE = 127;

    public static <VB extends CompositeValuesSourceBuilder<VB>, T> void declareValuesSourceFields(AbstractObjectParser<VB, T> objectParser) {
        objectParser.declareField(CompositeValuesSourceBuilder::field, XContentParser::text, new ParseField("field", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareBoolean(CompositeValuesSourceBuilder::missingBucket, new ParseField("missing_bucket", new String[0]));
        objectParser.declareString(CompositeValuesSourceBuilder::missingOrder, new ParseField("missing_order", new String[0]));
        objectParser.declareField(CompositeValuesSourceBuilder::userValuetypeHint, p -> {
            ValueType valueType = ValueType.lenientParse(p.text());
            return valueType;
        }, new ParseField("value_type", new String[0]), ObjectParser.ValueType.STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::script, (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        objectParser.declareField(CompositeValuesSourceBuilder::order, XContentParser::text, new ParseField("order", new String[0]), ObjectParser.ValueType.STRING);
    }

    public static void writeTo(CompositeValuesSourceBuilder<?> builder, StreamOutput out) throws IOException {
        int code = -128;
        String aggregationType = null;
        if (builder.getClass() == TermsValuesSourceBuilder.class) {
            code = 0;
        } else if (builder.getClass() == DateHistogramValuesSourceBuilder.class) {
            code = 1;
        } else if (builder.getClass() == HistogramValuesSourceBuilder.class) {
            code = 2;
        } else {
            if (!CompositeAggregationBuilder.BUILDER_CLASS_TO_BYTE_CODE.containsKey(builder.getClass()) && !CompositeAggregationBuilder.BUILDER_CLASS_TO_AGGREGATION_TYPE.containsKey(builder.getClass())) {
                throw new IOException("invalid builder type: " + builder.getClass().getSimpleName());
            }
            aggregationType = CompositeAggregationBuilder.BUILDER_CLASS_TO_AGGREGATION_TYPE.get(builder.getClass());
            if (CompositeAggregationBuilder.BUILDER_CLASS_TO_BYTE_CODE.containsKey(builder.getClass())) {
                code = CompositeAggregationBuilder.BUILDER_CLASS_TO_BYTE_CODE.get(builder.getClass()).byteValue();
            }
        }
        if (code != -128) {
            out.writeByte((byte)code);
        } else if (!CompositeAggregationBuilder.BUILDER_CLASS_TO_BYTE_CODE.containsKey(builder.getClass())) {
            out.writeByte((byte)127);
            assert (aggregationType != null);
            out.writeString(aggregationType);
        }
        builder.writeTo(out);
    }

    public static CompositeValuesSourceBuilder<?> readFrom(StreamInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return new TermsValuesSourceBuilder(in);
            }
            case 1: {
                return new DateHistogramValuesSourceBuilder(in);
            }
            case 2: {
                return new HistogramValuesSourceBuilder(in);
            }
            case 127: {
                String aggregationType = in.readString();
                if (!CompositeAggregationBuilder.AGGREGATION_TYPE_TO_COMPOSITE_VALUE_SOURCE_READER.containsKey(aggregationType)) {
                    throw new IOException("Invalid aggregation type " + aggregationType);
                }
                return (CompositeValuesSourceBuilder)CompositeAggregationBuilder.AGGREGATION_TYPE_TO_COMPOSITE_VALUE_SOURCE_READER.get(aggregationType).read(in);
            }
        }
        if (!CompositeAggregationBuilder.BYTE_CODE_TO_COMPOSITE_VALUE_SOURCE_READER.containsKey(code)) {
            throw new IOException("Invalid code " + code);
        }
        return (CompositeValuesSourceBuilder)CompositeAggregationBuilder.BYTE_CODE_TO_COMPOSITE_VALUE_SOURCE_READER.get(code).read(in);
    }

    public static CompositeValuesSourceBuilder<?> fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String name = parser.currentName();
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String type = parser.currentName();
        token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        CompositeValuesSourceBuilder builder = switch (type) {
            case "terms" -> TermsValuesSourceBuilder.parse(name, parser);
            case "date_histogram" -> (CompositeValuesSourceBuilder)DateHistogramValuesSourceBuilder.PARSER.parse(parser, (Object)name);
            case "histogram" -> HistogramValuesSourceBuilder.parse(name, parser);
            default -> {
                if (!CompositeAggregationBuilder.BUILDER_TYPE_TO_PARSER.containsKey(type)) {
                    throw new ParsingException(parser.getTokenLocation(), "invalid source type: " + type, new Object[0]);
                }
                yield CompositeAggregationBuilder.BUILDER_TYPE_TO_PARSER.get(type).parse(name, parser);
            }
        };
        parser.nextToken();
        parser.nextToken();
        return builder;
    }

    public static XContentBuilder toXContent(CompositeValuesSourceBuilder<?> source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(source.name());
        source.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

