/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.block;

import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;
import org.eclipse.mylyn.internal.wikitext.markdown.core.util.LookAheadReader;
import org.eclipse.mylyn.internal.wikitext.markdown.core.util.ReadAheadBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;

public class UnderlinedHeadingBlock
extends NestableBlock
implements ReadAheadBlock {
    private static final Pattern h1pattern = Pattern.compile("=+\\s*");
    private static final Pattern h2pattern = Pattern.compile("-+\\s*");
    private int blockLineCount;
    private int level;

    @Override
    public boolean canStart(String line, int lineOffset, LookAheadReader lookAheadReader) {
        this.blockLineCount = 0;
        this.level = 0;
        String nextLine = lookAheadReader.lookAhead();
        if (nextLine == null || nextLine.length() < lineOffset) {
            return false;
        }
        String text = nextLine.substring(lineOffset);
        if (h1pattern.matcher(text).matches()) {
            this.level = 1;
            return true;
        }
        if (h2pattern.matcher(text).matches()) {
            this.level = 2;
            return true;
        }
        return false;
    }

    public boolean canStart(String line, int lineOffset) {
        String message = "Read-ahead required, call canStart(String, int, LookAheadReader) instead.";
        throw new UnsupportedOperationException(message);
    }

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            attributes.setId(this.state.getIdGenerator().newId("h" + this.level, line));
            this.builder.beginHeading(this.level, attributes);
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        } else {
            this.builder.endHeading();
            this.setClosed(true);
        }
        ++this.blockLineCount;
        return -1;
    }
}

