/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.utils.ElementSeekerTask;
import org.netbeans.modules.spring.java.Bundle;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaUtils {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";

    private JavaUtils() {
    }

    public static Collection<ExecutableElement> getMethodsFromHandles(CompilationInfo ci, Collection<ElementHandle<ExecutableElement>> methodHandles) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(methodHandles.size());
        for (ElementHandle<ExecutableElement> handle : methodHandles) {
            ExecutableElement ee = (ExecutableElement)handle.resolve(ci);
            if (ee == null) continue;
            methods.add(ee);
        }
        return methods;
    }

    public static boolean isGetter(ExecutableElement ee) {
        String methodName = ee.getSimpleName().toString();
        TypeMirror retType = ee.getReturnType();
        if (ee.getModifiers().contains((Object)Modifier.PRIVATE) || ee.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        boolean retVal = methodName.startsWith(GET_PREFIX) && methodName.length() > GET_PREFIX.length() && retType.getKind() != TypeKind.VOID;
        retVal = retVal || methodName.startsWith(IS_PREFIX) && methodName.length() > IS_PREFIX.length() && retType.getKind() == TypeKind.BOOLEAN;
        return retVal;
    }

    public static boolean isSetter(ExecutableElement ee) {
        String methodName = ee.getSimpleName().toString();
        TypeMirror retType = ee.getReturnType();
        if (ee.getModifiers().contains((Object)Modifier.PRIVATE) || ee.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return methodName.startsWith(SET_PREFIX) && methodName.length() > SET_PREFIX.length() && retType.getKind() == TypeKind.VOID && ee.getParameters().size() == 1;
    }

    public static String getPropertyName(String methodName) {
        String substring;
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith(GET_PREFIX) || methodName.startsWith(SET_PREFIX)) {
            String substring2 = methodName.substring(3);
            if (!"".equals(substring2)) {
                return JavaUtils.convertToPropertyName(substring2);
            }
        } else if (methodName.startsWith(IS_PREFIX) && !"".equals(substring = methodName.substring(2))) {
            return JavaUtils.convertToPropertyName(substring);
        }
        return null;
    }

    private static String convertToPropertyName(String name) {
        char[] vals = name.toCharArray();
        vals[0] = Character.toLowerCase(vals[0]);
        return String.valueOf(vals);
    }

    public static Collection<ElementHandle<ExecutableElement>> getOverridenMethodsAsHandles(ExecutableElement e, CompilationInfo info) {
        Collection<ExecutableElement> methods = JavaUtils.getOverridenMethods(e, info);
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementHandle<ExecutableElement>> handles = new ArrayList<ElementHandle<ExecutableElement>>(methods.size());
        for (ExecutableElement ee : methods) {
            handles.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)ee));
        }
        return handles;
    }

    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, CompilationInfo info) {
        return JavaUtils.getOverridenMethods(e, SourceUtils.getEnclosingTypeElement((Element)e), info);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, TypeElement parent, CompilationInfo info) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeMirror sup = parent.getSuperclass();
        if (sup.getKind() == TypeKind.DECLARED) {
            TypeElement next = (TypeElement)((DeclaredType)sup).asElement();
            ExecutableElement executableElement = JavaUtils.getMethod(e, next, info);
            result.addAll(JavaUtils.getOverridenMethods(e, next, info));
            if (executableElement != null) {
                result.add(executableElement);
            }
        }
        for (TypeMirror typeMirror : parent.getInterfaces()) {
            TypeElement next = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement overriden2 = JavaUtils.getMethod(e, next, info);
            result.addAll(JavaUtils.getOverridenMethods(e, next, info));
            if (overriden2 == null) continue;
            result.add(overriden2);
        }
        return result;
    }

    private static ExecutableElement getMethod(ExecutableElement method, TypeElement type, CompilationInfo info) {
        for (ExecutableElement met : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!info.getElements().overrides(method, met, type)) continue;
            return met;
        }
        return null;
    }

    public static ElementHandle<ExecutableElement> findMethod(FileObject fileObject, String classBinName, String methodName, int argCount, Public publicFlag, Static staticFlag) {
        JavaSource js = JavaUtils.getJavaSource(fileObject);
        if (js != null) {
            MethodFinder methodFinder = new MethodFinder(js, classBinName, methodName, argCount, publicFlag, staticFlag);
            methodFinder.runAsUserTask();
            if (methodFinder.getMethodHandle() == null && SourceUtils.isScanInProgress()) {
                if (!ScanDialog.runWhenScanFinished((Runnable)methodFinder, (String)Bundle.JavaUtils_title_method_searching())) {
                    return methodFinder.getMethodHandle();
                }
                return null;
            }
            return methodFinder.getMethodHandle();
        }
        return null;
    }

    public static JavaSource getJavaSource(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        int n = 0;
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup[] sourceGroupArray = sourceGroups;
        int n2 = sourceGroupArray.length;
        if (n < n2) {
            SourceGroup sourceGroup = sourceGroupArray[n];
            return JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroup.getRootFolder()), (FileObject[])new FileObject[0]);
        }
        return null;
    }

    public static JavaSource getJavaSource(Document doc) {
        return JavaUtils.getJavaSource(NbEditorUtilities.getFileObject((Document)doc));
    }

    public static TypeElement findClassElementByBinaryName(String binaryName, CompilationController cc) {
        PackageElement packElem;
        if (!binaryName.contains("$")) {
            return cc.getElements().getTypeElement(binaryName);
        }
        String packageName = "";
        int dotIndex = binaryName.lastIndexOf(".");
        if (dotIndex != -1) {
            packageName = binaryName.substring(0, dotIndex);
        }
        if ((packElem = cc.getElements().getPackageElement(packageName)) == null) {
            return null;
        }
        return (TypeElement)new BinaryNameTypeScanner().visit(packElem, binaryName);
    }

    public static void openMethodInEditor(FileObject fileObject, String classBinName, String methodName, int argCount, Public publicFlag, Static staticFlag) {
        if (classBinName == null || methodName == null || fileObject == null) {
            return;
        }
        final JavaSource js = JavaUtils.getJavaSource(fileObject);
        if (js == null) {
            return;
        }
        final ElementHandle<ExecutableElement> eh = JavaUtils.findMethod(fileObject, classBinName, methodName, argCount, publicFlag, staticFlag);
        if (eh != null) {
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        ExecutableElement ee = (ExecutableElement)eh.resolve((CompilationInfo)cc);
                        ElementOpen.open((ClasspathInfo)js.getClasspathInfo(), (Element)ee);
                    }
                }, true);
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static void findAndOpenJavaClass(String classBinaryName, FileObject fileObject) {
        if (classBinaryName == null || fileObject == null) {
            return;
        }
        JavaSource js = JavaUtils.getJavaSource(fileObject);
        if (js != null) {
            final AtomicBoolean cancel = new AtomicBoolean(false);
            final ClassFinder classFinder = new ClassFinder(js, classBinaryName, cancel);
            if (SourceUtils.isScanInProgress()) {
                ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProgressUtils.runOffEventDispatchThread((Runnable)classFinder, (String)Bundle.JavaUtils_title_class_searching(), (AtomicBoolean)cancel, (boolean)false);
                    }
                }, (String)Bundle.JavaUtils_title_class_searching());
            } else {
                ProgressUtils.runOffEventDispatchThread((Runnable)classFinder, (String)Bundle.JavaUtils_title_class_searching(), (AtomicBoolean)cancel, (boolean)false);
            }
        }
    }

    private static final class MethodFinder
    extends ElementSeekerTask {
        private String classBinName;
        private String methodName;
        private int argCount;
        private Public publicFlag;
        private Static staticFlag;
        private ElementHandle<ExecutableElement> methodHandle;

        public MethodFinder(JavaSource javaSource, String classBinName, String methodName, int argCount, Public publicFlag, Static staticFlag) {
            super(javaSource);
            this.classBinName = classBinName;
            this.methodName = methodName;
            this.argCount = argCount;
            this.publicFlag = publicFlag;
            this.staticFlag = staticFlag;
        }

        public void run(CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement element = JavaUtils.findClassElementByBinaryName(this.classBinName, cc);
            while (element != null) {
                List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
                for (ExecutableElement method : methods) {
                    boolean isPublic;
                    boolean isStatic;
                    int actualArgCount;
                    String mName = method.getSimpleName().toString();
                    if (!mName.equals(this.methodName) || this.argCount != -1 && (actualArgCount = method.getParameters().size()) != this.argCount || this.staticFlag != Static.DONT_CARE && ((isStatic = method.getModifiers().contains((Object)Modifier.STATIC)) && this.staticFlag == Static.NO || !isStatic && this.staticFlag == Static.YES) || this.publicFlag != Public.DONT_CARE && ((isPublic = method.getModifiers().contains((Object)Modifier.PUBLIC)) && this.publicFlag == Public.NO || !isPublic && this.publicFlag == Public.YES)) continue;
                    this.methodHandle = ElementHandle.create((Element)method);
                    return;
                }
                TypeMirror superClassMirror = element.getSuperclass();
                if (superClassMirror instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)superClassMirror;
                    Element elem = declaredType.asElement();
                    if (elem.getKind() != ElementKind.CLASS) continue;
                    element = (TypeElement)elem;
                    continue;
                }
                element = null;
            }
        }

        public ElementHandle<ExecutableElement> getMethodHandle() {
            return this.methodHandle;
        }
    }

    private static class BinaryNameTypeScanner
    extends SimpleElementVisitor6<TypeElement, String> {
        private BinaryNameTypeScanner() {
        }

        @Override
        public TypeElement visitPackage(PackageElement packElem, String binaryName) {
            for (Element element : packElem.getEnclosedElements()) {
                TypeElement ret;
                if (!element.getKind().isClass() || (ret = element.accept(this, binaryName)) == null) continue;
                return ret;
            }
            return null;
        }

        @Override
        public TypeElement visitType(TypeElement typeElement, String binaryName) {
            String bName = ElementUtilities.getBinaryName((TypeElement)typeElement);
            if (binaryName.equals(bName)) {
                return typeElement;
            }
            if (binaryName.startsWith(bName)) {
                for (Element element : typeElement.getEnclosedElements()) {
                    TypeElement retVal;
                    if (!element.getKind().isClass() || (retVal = element.accept(this, binaryName)) == null) continue;
                    return retVal;
                }
            }
            return null;
        }
    }

    private static final class ClassFinder
    extends ElementSeekerTask {
        private final String classBinaryName;
        private final AtomicBoolean cancel;

        public ClassFinder(JavaSource javaSource, String classBinaryName, AtomicBoolean cancel) {
            super(javaSource);
            this.classBinaryName = classBinaryName;
            this.cancel = cancel;
        }

        public void run(CompilationController controller) throws Exception {
            if (this.cancel.get()) {
                return;
            }
            boolean opened = false;
            if (this.classBinaryName == null) {
                return;
            }
            TypeElement element = JavaUtils.findClassElementByBinaryName(this.classBinaryName, controller);
            if (element != null) {
                this.elementFound.set(true);
                if (this.cancel.get()) {
                    return;
                }
                opened = ElementOpen.open((ClasspathInfo)this.javaSource.getClasspathInfo(), (Element)element);
            }
            if (!opened) {
                String msg = NbBundle.getMessage(JavaUtils.class, (String)"LBL_SourceNotFound", (Object)this.classBinaryName);
                StatusDisplayer.getDefault().setStatusText(msg);
            }
        }
    }
}

