/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringCompletionResult;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.completion.completors.BeansRefCompletor;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;

public class PNamespaceBeanRefCompletor
extends Completor {
    public PNamespaceBeanRefCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        return context.getCurrentTokenOffset() + 1;
    }

    @Override
    protected void compute(CompletionContext context) throws IOException {
        Token<XMLTokenId> attribToken = ContextUtilities.getAttributeToken(context.getDocumentContext());
        if (attribToken == null) {
            return;
        }
        String attribName = attribToken.text().toString();
        if (!ContextUtilities.isPNamespaceName(context.getDocumentContext(), attribName)) {
            return;
        }
        if (!attribName.endsWith("-ref")) {
            return;
        }
        BeansRefCompletor beansRefCompletor = new BeansRefCompletor(true, context.getCaretOffset());
        SpringCompletionResult result = beansRefCompletor.complete(context);
        for (SpringXMLConfigCompletionItem item : result.getItems()) {
            this.addCacheItem(item);
        }
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.BEAN_NAME_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }
}

