/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nashorn.execution.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.nashorn.execution.NashornPlatform;
import org.netbeans.modules.nashorn.execution.options.JavaScriptNashornOptionsPanelController;
import org.netbeans.modules.nashorn.execution.options.NashornPlatformComboBoxModel;
import org.netbeans.modules.nashorn.execution.options.Settings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JavaScriptNashornPanel
extends JPanel {
    private final JavaScriptNashornOptionsPanelController optionsController;
    private final String nashorn = NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"LBL_Nashorn");
    private final String graalJs = NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"LBL_GraalJs");
    private JLabel argumentsLabel;
    private JTextField argumentsTextField;
    private JLabel engineLabel;
    private JLabel engineOptionsLabel;
    private JTextField engineOptionsTextField;
    private JComboBox<String> engineSelector;
    private JPanel fillPanel;
    private JLabel infoLabel;
    private JLabel platformHintLabel;
    private JButton platformManageButton;
    private JComboBox platformsComboBox;
    private JLabel platformsLabel;

    public JavaScriptNashornPanel(JavaScriptNashornOptionsPanelController optionsController) {
        this.optionsController = optionsController;
        this.initComponents();
        this.platformsComboBox.setModel(new NashornPlatformComboBoxModel());
        this.platformsComboBox.addActionListener(new PlatformChangeListener(true));
        this.engineSelector.addActionListener(new PlatformChangeListener(false));
        this.setFieldsEnabled();
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.platformsLabel = new JLabel();
        this.platformsComboBox = new JComboBox();
        this.engineOptionsLabel = new JLabel();
        this.engineOptionsTextField = new JTextField();
        this.platformHintLabel = new JLabel();
        this.argumentsLabel = new JLabel();
        this.argumentsTextField = new JTextField();
        this.platformManageButton = new JButton();
        this.fillPanel = new JPanel();
        this.engineLabel = new JLabel();
        this.engineSelector = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.infoLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.platformsLabel.setLabelFor(this.platformsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.platformsLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.platformsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.add((Component)this.platformsLabel, gridBagConstraints);
        this.platformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptNashornPanel.this.platformsComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 284;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 24, 0, 0);
        this.add((Component)this.platformsComboBox, gridBagConstraints);
        this.engineOptionsLabel.setLabelFor(this.engineOptionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.engineOptionsLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.engineOptionsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.add((Component)this.engineOptionsLabel, gridBagConstraints);
        this.engineOptionsTextField.setText(NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.engineOptionsTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 312;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 24, 0, 0);
        this.add((Component)this.engineOptionsTextField, gridBagConstraints);
        this.platformHintLabel.setFont(this.platformHintLabel.getFont().deriveFont((float)this.platformHintLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.platformHintLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.platformHintLabel.text"));
        this.platformHintLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 329;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 24, 0, 0);
        this.add((Component)this.platformHintLabel, gridBagConstraints);
        this.argumentsLabel.setLabelFor(this.argumentsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argumentsLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.argumentsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.argumentsLabel, gridBagConstraints);
        this.argumentsTextField.setText(NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.argumentsTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 312;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 24, 172, 0);
        this.add((Component)this.argumentsTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.platformManageButton, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.platformManageButton.text"));
        this.platformManageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptNashornPanel.this.platformManageButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.platformManageButton, gridBagConstraints);
        this.fillPanel.setMinimumSize(new Dimension(0, 0));
        this.fillPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.fillPanel, gridBagConstraints);
        this.engineLabel.setLabelFor(this.engineSelector);
        Mnemonics.setLocalizedText((JLabel)this.engineLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.engineLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.engineLabel, gridBagConstraints);
        this.engineSelector.setModel(this.initEngineSelector());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 24, 0, 0);
        this.add(this.engineSelector, gridBagConstraints);
    }

    ComboBoxModel<String> initEngineSelector() {
        Vector<String> names = new Vector<String>();
        JavaPlatform p = this.getSelectedPlatform();
        if (NashornPlatform.isNashornSupported(p)) {
            names.add(this.nashorn);
        }
        if (NashornPlatform.isGraalJsSupported(p)) {
            if (NashornPlatform.isGraalJSPreferred(p)) {
                names.add(0, this.graalJs);
            } else {
                names.add(this.graalJs);
            }
        }
        return new DefaultComboBoxModel<String>(names);
    }

    private void platformManageButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer(null);
    }

    private void platformsComboBoxActionPerformed(ActionEvent evt) {
        this.setFieldsEnabled();
    }

    private JavaPlatform getSelectedPlatform() {
        Object selObj = this.platformsComboBox.getSelectedItem();
        if (selObj == null) {
            return null;
        }
        return PlatformUiSupport.getPlatform((Object)selObj);
    }

    private void selectPlatform(JavaPlatform platform) {
        int n = this.platformsComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.platformsComboBox.getItemAt(i);
            JavaPlatform p = PlatformUiSupport.getPlatform(obj);
            if (!platform.equals(p)) continue;
            this.platformsComboBox.setSelectedIndex(i);
            return;
        }
    }

    void load() {
        JavaPlatform njp = NashornPlatform.getDefault().getPlatform();
        if (njp != null) {
            this.selectPlatform(njp);
        }
        Preferences p = Settings.getPreferences();
        String options = p.get("nashornEngineOptions", null);
        String arguments = p.get("nashornScriptArguments", null);
        this.engineOptionsTextField.setText(options != null ? options : "");
        this.argumentsTextField.setText(arguments != null ? arguments : "");
        if (this.isSettingsNashorn(njp)) {
            this.engineSelector.setSelectedItem(this.nashorn);
        } else {
            this.engineSelector.setSelectedItem(this.graalJs);
        }
    }

    private boolean isSettingsNashorn(JavaPlatform njp) {
        Preferences p = Settings.getPreferences();
        String item = p.get("nashornIsPreferred", null);
        if (item == null) {
            return !NashornPlatform.isGraalJSPreferred(njp);
        }
        return p.getBoolean("nashornIsPreferred", false);
    }

    void store() {
        NashornPlatform.getDefault().setPlatform(this.getSelectedPlatform());
        String options = this.engineOptionsTextField.getText().trim();
        if (options.isEmpty()) {
            Settings.getPreferences().remove("nashornEngineOptions");
        } else {
            Settings.getPreferences().put("nashornEngineOptions", options);
        }
        String arguments = this.argumentsTextField.getText().trim();
        if (arguments.isEmpty()) {
            Settings.getPreferences().remove("nashornScriptArguments");
        } else {
            Settings.getPreferences().put("nashornScriptArguments", arguments);
        }
        Settings.getPreferences().putBoolean("nashornIsPreferred", this.isNashorn());
    }

    private boolean isNashorn() {
        Object item = this.engineSelector.getSelectedItem();
        return item == this.nashorn;
    }

    boolean valid() {
        return true;
    }

    boolean isChanged() {
        if (NashornPlatform.getDefault().getPlatform() != this.getSelectedPlatform()) {
            return true;
        }
        if (!this.engineOptionsTextField.getText().trim().equals(Settings.getPreferences().get("nashornEngineOptions", ""))) {
            return true;
        }
        if (!this.argumentsTextField.getText().trim().equals(Settings.getPreferences().get("nashornScriptArguments", ""))) {
            return true;
        }
        return this.isSettingsNashorn(this.getSelectedPlatform()) != this.isNashorn();
    }

    private void setFieldsEnabled() {
        boolean enabled = this.getSelectedPlatform() != null;
        this.engineOptionsTextField.setEnabled(enabled);
        this.argumentsTextField.setEnabled(enabled);
    }

    private class PlatformChangeListener
    implements ActionListener {
        private final boolean resetEngines;

        PlatformChangeListener(boolean resetEngines) {
            this.resetEngines = resetEngines;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JavaScriptNashornPanel.this.optionsController.changed();
            if (this.resetEngines) {
                JavaScriptNashornPanel.this.engineSelector.setModel(JavaScriptNashornPanel.this.initEngineSelector());
            }
        }
    }
}

