/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.exec.BowerExecutable;
import org.netbeans.modules.javascript.bower.file.BowerJson;
import org.netbeans.modules.javascript.bower.ui.actions.Bundle;
import org.netbeans.modules.javascript.bower.util.BowerUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class BowerInstallAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor RP = new RequestProcessor(BowerInstallAction.class);
    private final Project project;

    public BowerInstallAction() {
        this((Project)null);
    }

    public BowerInstallAction(Project project) {
        this.project = project;
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", Bundle.BowerInstallAction_name());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (this.project != null);
        final BowerExecutable bower = BowerExecutable.getDefault(this.project, true);
        if (bower == null) {
            return;
        }
        RP.post(new Runnable(){
            final /* synthetic */ BowerInstallAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                BowerUtils.logUsageBowerInstall();
                bower.install(new String[0]);
            }
        });
    }

    public Action createContextAwareInstance(Lookup context) {
        Project contextProject = (Project)context.lookup(Project.class);
        BowerJson bowerJson = null;
        if (contextProject != null) {
            bowerJson = new BowerJson(contextProject.getProjectDirectory());
        } else {
            DataObject dataObject;
            FileObject file = (FileObject)context.lookup(FileObject.class);
            if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
                file = dataObject.getPrimaryFile();
            }
            if (file != null) {
                bowerJson = new BowerJson(file.getParent());
            }
        }
        if (bowerJson == null) {
            return this;
        }
        if (!bowerJson.exists()) {
            return this;
        }
        if (bowerJson.getDependencies().isEmpty()) {
            return this;
        }
        return new BowerInstallAction(contextProject != null ? contextProject : FileOwnerQuery.getOwner((URI)Utilities.toURI((File)bowerJson.getFile())));
    }
}

