/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.Roots;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.impl.RootsAccessor;
import org.netbeans.modules.java.api.common.queries.MultiModuleGroupQuery;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

class MultiModuleGroupQueryImpl
implements MultiModuleGroupQuery,
ChangeListener,
PropertyChangeListener,
AntProjectListener {
    private final Collection<Roots> roots;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final Sources sources;
    private final AtomicInteger version = new AtomicInteger(1);
    private final Map<SourceGroup, MultiModuleGroupQuery.Result> cachedModuleInfo = new WeakHashMap<SourceGroup, MultiModuleGroupQuery.Result>();
    private final Set<String> watchedProperties = new HashSet<String>();
    private static final MultiModuleGroupQuery.Result NONE = new MultiModuleGroupQuery.Result(null, null);

    public MultiModuleGroupQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, Sources src, Roots ... roots) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.roots = Collections.unmodifiableList(Arrays.asList(roots));
        this.sources = src;
        for (Roots r : this.roots) {
            r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)r));
        }
        helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)helper));
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.sources) {
            this.flush();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
            this.flush();
        }
    }

    @Override
    public SourceGroup[] filterModuleGroups(String modName, SourceGroup[] original) {
        LinkedHashSet<SourceGroup> result = new LinkedHashSet<SourceGroup>(original.length);
        for (Roots r : this.roots) {
            if (!RootsAccessor.getInstance().isSourceRoot(r)) continue;
            String[] pathProps = RootsAccessor.getInstance().getRootPathProperties(r);
            String[] propNames = r.getRootProperties();
            for (int i = 0; i < propNames.length; ++i) {
                String prop = propNames[i];
                String pathProp = pathProps[i];
                String type = RootsAccessor.getInstance().getType(r);
                if (pathProp == null || "modules".equals(type)) continue;
                String pathToModules = this.evaluator.getProperty(prop);
                File file = this.helper.resolveFile(pathToModules);
                Collection spVariants = Arrays.stream(PropertyUtils.tokenizePath((String)this.evaluator.getProperty(pathProp))).map(p -> CommonModuleUtils.parseSourcePathVariants(p)).flatMap(lv -> lv.stream()).collect(Collectors.toList());
                Iterator iterator = spVariants.iterator();
                while (iterator.hasNext()) {
                    FileObject modDirFo;
                    String variant;
                    String pathInModule = variant = (String)iterator.next();
                    if (!file.exists()) continue;
                    File modDir = new File(new File(file, modName), pathInModule);
                    if (!file.exists() || !file.isDirectory() || (modDirFo = FileUtil.toFileObject((File)modDir)) == null || !modDirFo.isValid()) continue;
                    for (SourceGroup g : original) {
                        if (!g.getRootFolder().equals(modDirFo)) continue;
                        result.add(g);
                    }
                }
            }
        }
        return result.toArray(new SourceGroup[0]);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.flush();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        MultiModuleGroupQueryImpl multiModuleGroupQueryImpl = this;
        synchronized (multiModuleGroupQueryImpl) {
            this.cachedModuleInfo.clear();
            this.watchedProperties.clear();
            this.version.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiModuleGroupQuery.Result findModuleInfo(SourceGroup grp) {
        MultiModuleGroupQueryImpl multiModuleGroupQueryImpl = this;
        synchronized (multiModuleGroupQueryImpl) {
            MultiModuleGroupQuery.Result res = this.cachedModuleInfo.get(grp);
            if (res != null) {
                return res == NONE ? null : res;
            }
        }
        int ver = this.version.get();
        HashSet<String> props = new HashSet<String>();
        HashSet<FileObject> newmodRoots = new HashSet<FileObject>();
        for (Roots r : this.roots) {
            if (!RootsAccessor.getInstance().isSourceRoot(r)) continue;
            FileObject groot = grp.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)groot);
            Path rootPath = rootFile.toPath();
            String[] propNames = r.getRootProperties();
            String[] rootPathPropNames = RootsAccessor.getInstance().getRootPathProperties(r);
            for (int i = 0; i < propNames.length; ++i) {
                String prop = propNames[i];
                String pathProp = rootPathPropNames[i];
                String type = RootsAccessor.getInstance().getType(r);
                if (pathProp == null || "modules".equals(type)) continue;
                String pathToModules = this.evaluator.getProperty(prop);
                String loc = this.evaluator.getProperty(pathProp);
                File file = this.helper.resolveFile(pathToModules);
                props.add(prop);
                Collection spVariants = Arrays.stream(PropertyUtils.tokenizePath((String)loc)).map(p -> CommonModuleUtils.parseSourcePathVariants(p)).flatMap(lv -> lv.stream()).collect(Collectors.toList());
                for (File f : file.listFiles()) {
                    if (!f.isDirectory()) continue;
                    Iterator iterator = spVariants.iterator();
                    while (iterator.hasNext()) {
                        Path fPath;
                        String variant;
                        String pathInModule = variant = (String)iterator.next();
                        FileObject rfo = FileUtil.toFileObject((File)file);
                        if (rfo != null) {
                            newmodRoots.add(rfo);
                        }
                        if (!rootPath.startsWith(fPath = file.toPath())) continue;
                        Path rel = fPath.relativize(rootPath);
                        Path intra = Paths.get(pathInModule, new String[0]);
                        String modName = rel.getName(0).toString();
                        if (!pathInModule.isEmpty() && (rel.getNameCount() == 1 || !rel.subpath(1, rel.getNameCount()).equals(intra))) continue;
                        MultiModuleGroupQuery.Result fres = new MultiModuleGroupQuery.Result(modName, pathInModule);
                        MultiModuleGroupQueryImpl multiModuleGroupQueryImpl2 = this;
                        synchronized (multiModuleGroupQueryImpl2) {
                            if (ver == this.version.get()) {
                                return this.cachedModuleInfo.computeIfAbsent(grp, g -> fres);
                            }
                            return fres;
                        }
                    }
                }
            }
        }
        MultiModuleGroupQueryImpl multiModuleGroupQueryImpl3 = this;
        synchronized (multiModuleGroupQueryImpl3) {
            if (ver == this.version.get() && !this.cachedModuleInfo.containsKey(grp)) {
                this.cachedModuleInfo.put(grp, NONE);
                this.watchedProperties.addAll(props);
            }
        }
        return null;
    }
}

