/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

@Deprecated
public class ExplorerActions {
    private static CopyAction copy = null;
    private static CutAction cut = null;
    private static DeleteAction delete = null;
    private static PasteAction paste = null;
    private final CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private final CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private final DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private final OwnPaste pasteActionPerformer = new OwnPaste();
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;
    private Boolean confirmDelete;
    private boolean attachPerformers;

    public ExplorerActions() {
        this(true);
    }

    ExplorerActions(boolean attachPerformers) {
        this.attachPerformers = attachPerformers;
    }

    final Action copyAction() {
        return this.copyActionPerformer;
    }

    final Action cutAction() {
        return this.cutActionPerformer;
    }

    final Action deleteAction() {
        return this.deleteActionPerformer;
    }

    final Action pasteAction() {
        return this.pasteActionPerformer;
    }

    public synchronized void attach(ExplorerManager m) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = m;
        ExplorerPanel.associateActions(this, m);
        this.actionStateUpdater = new ActionStateUpdater();
        this.manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.actionStateUpdater, (Object)this.manager));
        Clipboard c = ExplorerActions.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.addClipboardListener((ClipboardListener)WeakListeners.create(ClipboardListener.class, (EventListener)this.actionStateUpdater, (Object)clip));
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.actionStateUpdater = null;
        this.stopActions();
        this.manager = null;
    }

    @Deprecated
    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    public final void setConfirmDelete(boolean yes) {
        this.confirmDelete = yes;
    }

    public final boolean isConfirmDelete() {
        return this.confirmDelete == null ? ExplorerPanel.isConfirmDelete() : this.confirmDelete;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            if (this.attachPerformers) {
                if (copy.getActionPerformer() instanceof CopyCutActionPerformer) {
                    copy.setActionPerformer(null);
                }
                if (cut.getActionPerformer() instanceof CopyCutActionPerformer) {
                    cut.setActionPerformer(null);
                }
                paste.setPasteTypes(null);
                if (delete.getActionPerformer() instanceof DeleteActionPerformer) {
                    delete.setActionPerformer(null);
                }
            } else {
                this.copyActionPerformer.setEnabled(false);
                this.cutActionPerformer.setEnabled(false);
                this.deleteActionPerformer.setEnabled(false);
                this.pasteActionPerformer.setEnabled(false);
            }
        }
    }

    private void updateActions() {
        int k;
        if (this.manager == null) {
            return;
        }
        Node[] path = this.manager.getSelectedNodes();
        if (copy == null) {
            copy = (CopyAction)CopyAction.findObject(CopyAction.class, (boolean)true);
            cut = (CutAction)CutAction.findObject(CutAction.class, (boolean)true);
            paste = (PasteAction)PasteAction.findObject(PasteAction.class, (boolean)true);
            delete = (DeleteAction)DeleteAction.findObject(DeleteAction.class, (boolean)true);
        }
        int n = k = path != null ? path.length : 0;
        if (k > 0) {
            int i;
            boolean incest = false;
            if (k > 1) {
                HashMap allNodes = new HashMap(101);
                for (i = 0; i < k; ++i) {
                    if (this.checkParents(path[i], allNodes)) continue;
                    incest = true;
                    break;
                }
            }
            for (i = 0; i < k; ++i) {
                if (!incest && path[i].canCopy()) continue;
                if (this.attachPerformers) {
                    copy.setActionPerformer(null);
                    break;
                }
                this.copyActionPerformer.setEnabled(false);
                break;
            }
            if (i == k) {
                if (this.attachPerformers) {
                    copy.setActionPerformer((ActionPerformer)this.copyActionPerformer);
                } else {
                    this.copyActionPerformer.setEnabled(true);
                }
            }
            for (i = 0; i < k; ++i) {
                if (!incest && path[i].canCut()) continue;
                if (this.attachPerformers) {
                    cut.setActionPerformer(null);
                    break;
                }
                this.cutActionPerformer.setEnabled(false);
                break;
            }
            if (i == k) {
                if (this.attachPerformers) {
                    cut.setActionPerformer((ActionPerformer)this.cutActionPerformer);
                } else {
                    this.cutActionPerformer.setEnabled(true);
                }
            }
            for (i = 0; i < k; ++i) {
                if (!incest && path[i].canDestroy()) continue;
                if (this.attachPerformers) {
                    delete.setActionPerformer(null);
                    break;
                }
                this.deleteActionPerformer.setEnabled(false);
                break;
            }
            if (i == k) {
                if (this.attachPerformers) {
                    delete.setActionPerformer((ActionPerformer)this.deleteActionPerformer);
                } else {
                    this.deleteActionPerformer.setEnabled(true);
                }
            }
        } else if (this.attachPerformers) {
            copy.setActionPerformer(null);
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
        } else {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformer.setEnabled(false);
        }
        this.updatePasteAction(path);
    }

    private boolean checkParents(Node node, Map set) {
        if (set.get(node) != null) {
            return false;
        }
        set.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (set.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] path) {
        ExplorerManager man = this.manager;
        if (man == null) {
            if (this.attachPerformers) {
                paste.setPasteTypes(null);
            } else {
                this.pasteActionPerformer.setPasteTypes(null);
            }
            return;
        }
        if (path != null && path.length > 1) {
            if (this.attachPerformers) {
                paste.setPasteTypes(null);
            } else {
                this.pasteActionPerformer.setPasteTypes(null);
            }
            return;
        }
        Node node = man.getExploredContext();
        Node[] selectedNodes = man.getSelectedNodes();
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        if (node != null) {
            Transferable trans = ExplorerActions.getClipboard().getContents(this);
            this.updatePasteTypes(trans, node);
        }
    }

    private void updatePasteTypes(Transferable trans, Node pan) {
        if (trans != null) {
            PasteType[] pasteTypes;
            PasteType[] pasteTypeArray = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                if (this.attachPerformers) {
                    paste.setPasteTypes(pasteTypes);
                } else {
                    this.pasteActionPerformer.setPasteTypes(pasteTypes);
                }
                return;
            }
            boolean flavorSupported = false;
            try {
                flavorSupported = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (flavorSupported) {
                try {
                    MultiTransferObject obj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int count = obj.getCount();
                    boolean ok = true;
                    Transferable[] t = new Transferable[count];
                    PasteType[] p = new PasteType[count];
                    for (int i = 0; i < count; ++i) {
                        t[i] = obj.getTransferableAt(i);
                        PasteType[] pasteTypeArray2 = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) {
                            ok = false;
                            break;
                        }
                        p[i] = pasteTypes[0];
                    }
                    if (ok) {
                        PasteType[] arrOfPaste = new PasteType[]{new MultiPasteType(t, p)};
                        if (this.attachPerformers) {
                            paste.setPasteTypes(arrOfPaste);
                        } else {
                            this.pasteActionPerformer.setPasteTypes(arrOfPaste);
                        }
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.attachPerformers) {
            if (paste != null) {
                paste.setPasteTypes(null);
            }
        } else {
            this.pasteActionPerformer.setPasteTypes(null);
        }
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionsState() {
        ActionStateUpdater asu;
        ExplorerActions explorerActions = this;
        synchronized (explorerActions) {
            asu = this.actionStateUpdater;
        }
        if (asu != null) {
            asu.update();
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean b) {
            this.copyCut = b;
        }

        @Override
        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction action) {
            Transferable trans = null;
            Node[] sel = ExplorerActions.this.manager.getSelectedNodes();
            if (sel.length != 1) {
                Transferable[] arrayTrans = new Transferable[sel.length];
                for (int i = 0; i < sel.length; ++i) {
                    arrayTrans[i] = this.getTransferableOwner(sel[i]);
                    if (arrayTrans[i] != null) continue;
                    return;
                }
                trans = new ExTransferable.Multi(arrayTrans);
            } else {
                trans = this.getTransferableOwner(sel[0]);
            }
            if (trans != null) {
                Clipboard clipboard = ExplorerActions.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                Logger.getLogger(ExplorerActions.class.getName()).log(Level.WARNING, null, e);
                return null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        DeleteActionPerformer() {
        }

        @Override
        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        public void performAction(SystemAction action) {
            Node[] sel = ExplorerActions.this.manager.getSelectedNodes();
            if (sel == null || sel.length == 0) {
                return;
            }
            if (!ExplorerActions.this.isConfirmDelete() || this.doConfirm(sel)) {
                try {
                    if (ExplorerActions.this.manager != null) {
                        ExplorerActions.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(sel);
                class Run
                implements Runnable {
                    Run() {
                    }

                    @Override
                    public void run() {
                        if (ExplorerActions.this.attachPerformers) {
                            delete.setActionPerformer(null);
                        } else {
                            DeleteActionPerformer.this.setEnabled(false);
                        }
                    }
                }
                Mutex.EVENT.readAccess((Runnable)new Run());
            }
        }

        private boolean doConfirm(Node[] sel) {
            String title;
            String message;
            boolean customDelete = true;
            for (int i = 0; i < sel.length; ++i) {
                if (Boolean.TRUE.equals(sel[i].getValue("customDelete"))) continue;
                customDelete = false;
                break;
            }
            if (customDelete) {
                return true;
            }
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.openide.explorer.Bundle");
            if (sel.length == 1) {
                message = MessageFormat.format(bundle.getString("MSG_ConfirmDeleteObject"), sel[0].getDisplayName());
                title = bundle.getString("MSG_ConfirmDeleteObjectTitle");
            } else {
                message = MessageFormat.format(bundle.getString("MSG_ConfirmDeleteObjects"), sel.length);
                title = bundle.getString("MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc));
        }

        private void doDestroy(final Node[] sel) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){
                    final /* synthetic */ DeleteActionPerformer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() throws IOException {
                        for (int i = 0; i < sel.length; ++i) {
                            try {
                                sel[i].destroy();
                                continue;
                            }
                            catch (IOException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    }
                });
            }
            catch (IOException ioe) {
                throw (IllegalStateException)new IllegalStateException(ioe.toString()).initCause(ioe);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }
    }

    private class OwnPaste
    extends AbstractAction {
        private PasteType[] pasteTypes = new PasteType[0];

        OwnPaste() {
        }

        @Override
        public boolean isEnabled() {
            ExplorerActions.this.updateActionsState();
            return super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPasteTypes(PasteType[] arr) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = arr;
            }
            this.setEnabled(arr != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.pasteTypes == null) {
                throw new IllegalStateException("Should not be invoked at all. Paste types: null");
            }
            throw new IllegalStateException("Should not be invoked at all. Paste types: " + Arrays.asList(this.pasteTypes));
        }

        @Override
        public Object getValue(String s) {
            ExplorerActions.this.updateActionsState();
            if ("delegates".equals(s)) {
                return this.pasteTypes;
            }
            return super.getValue(s);
        }
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener {
        private final Timer timer = new FixIssue29405Timer(150, this);
        private boolean planned;

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent e) {
            this.timer.restart();
            this.planned = true;
        }

        public void clipboardChanged(ClipboardEvent ev) {
            final ExplorerManager em = ExplorerActions.this.manager;
            if (!ev.isConsumed() && em != null) {
                Mutex.EVENT.writeAccess(new Runnable(){
                    final /* synthetic */ ActionStateUpdater this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.ExplorerActions.this.updatePasteAction(em.getSelectedNodes());
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            ExplorerActions.this.updateActions();
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                this.timer.stop();
                this.planned = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            boolean update;
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                update = this.planned;
                this.planned = false;
            }
            if (update) {
                this.timer.stop();
                ExplorerActions.this.updateActions();
            }
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.t = t;
            this.p = p;
        }

        public Transferable paste() throws IOException {
            int size = this.p.length;
            Transferable[] arr = new Transferable[size];
            for (int i = 0; i < size; ++i) {
                Transferable newTransferable = this.p[i].paste();
                arr[i] = newTransferable != null ? newTransferable : this.t[i];
            }
            return new ExTransferable.Multi(arr);
        }
    }

    private static class FixIssue29405Timer
    extends Timer {
        private boolean running;

        public FixIssue29405Timer(int delay, ActionListener l) {
            super(delay, l);
        }

        @Override
        public void restart() {
            super.restart();
            this.running = true;
        }

        @Override
        public void stop() {
            this.running = false;
            super.stop();
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }
    }
}

