/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.projects.AntFilesHelper;
import org.netbeans.modules.websvc.rest.projects.RestApplicationsPanel;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebProjectRestSupport
extends RestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public WebProjectRestSupport(Project project) {
        super(project);
    }

    protected void handleSpring() throws IOException {
        if (this.hasSpringSupport()) {
            this.addJerseySpringJar();
        }
    }

    public File getLocalTargetTestRest() {
        String path = "build/generated-sources/rest-test";
        AntProjectHelper helper = this.getAntProjectHelper();
        EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
        String path1 = projectProps.getProperty("restbeans.test.dir");
        if (path1 != null) {
            path = path1;
        }
        return helper.resolveFile(path);
    }

    public FileObject generateTestClient(File testdir, String url) throws IOException {
        FileObject fileObject = MiscUtilities.generateTestClient((File)testdir);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("___BASE_URL___", url);
        MiscUtilities.modifyFile((FileObject)fileObject, map);
        return fileObject;
    }

    public void deploy() throws IOException {
        FileObject buildFo = Utils.findBuildXml(this.getProject());
        if (buildFo != null) {
            ExecutorTask task = ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"run-deploy"}, (Properties)new Properties());
            task.waitFinished();
        }
    }

    public void logResourceCreation() {
        Object[] params = new Object[]{"JAX-RS", this.getProject().getClass().getName(), "REST RESOURCE"};
        LogUtils.logWsDetect((Object[])params);
    }

    public String getApplicationPathFromDialog(List<RestApplication> restApplications) {
        if (restApplications.size() == 1) {
            return restApplications.get(0).getApplicationPath();
        }
        RestApplicationsPanel panel = new RestApplicationsPanel(restApplications);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(WebProjectRestSupport.class, (String)"TTL_RestResourcesPath"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (NotifyDescriptor.OK_OPTION.equals(desc.getValue())) {
            return panel.getApplicationPath();
        }
        return null;
    }

    protected void extendBuildScripts() throws IOException {
        new AntFilesHelper(this).initRestBuildExtension();
    }
}

