/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.GroupUseScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.DeclareStatement;
import org.netbeans.modules.php.editor.parser.astnodes.EmptyStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public final class AutoImport {
    private static final Logger LOGGER = Logger.getLogger(AutoImport.class.getName());
    public static final String PARAM_NAME = "php-auto-import";
    public static final String PARAM_KEY_FQ_NAME = "fqName";
    public static final String PARAM_KEY_ALIAS_NAME = "aliasName";
    public static final String PARAM_KEY_USE_TYPE = "useType";
    public static final String USE_TYPE = "type";
    public static final String USE_FUNCTION = "function";
    public static final String USE_CONST = "const";
    private final PHPParseResult parserResult;

    public static boolean sameUseNameExists(String name, String fqName, UseScope.Type useScopeType, NamespaceScope namespaceScope) {
        Collection<? extends GroupUseScope> declaredGroupUses = namespaceScope.getDeclaredGroupUses();
        Collection<? extends UseScope> declaredSingleUses = namespaceScope.getDeclaredSingleUses();
        for (GroupUseScope groupUseScope : declaredGroupUses) {
            List<UseScope> useScopes = groupUseScope.getUseScopes();
            if (!AutoImport.hasSameNameInSingleUses(name, fqName, useScopeType, useScopes)) continue;
            return true;
        }
        return AutoImport.hasSameNameInSingleUses(name, fqName, useScopeType, declaredSingleUses);
    }

    private static boolean hasSameNameInSingleUses(String name, String fqName, UseScope.Type useScopeType, Collection<? extends UseScope> declaredSingleUses) {
        for (UseScope useScope : declaredSingleUses) {
            String elementName;
            UseScope.Type type = useScope.getType();
            if (type != useScopeType || fqName.equals(useScope.getName())) continue;
            AliasedName aliasedName = useScope.getAliasedName();
            if (aliasedName != null) {
                elementName = aliasedName.getAliasName();
            } else {
                QualifiedName qualifiedName = QualifiedName.create(useScope.getName());
                elementName = qualifiedName.getName();
            }
            if (!name.equals(elementName)) continue;
            return true;
        }
        return false;
    }

    public static UseScope.Type getUseScopeType(String useType) {
        UseScope.Type useScopeType = UseScope.Type.TYPE;
        switch (useType) {
            case "type": {
                useScopeType = UseScope.Type.TYPE;
                break;
            }
            case "function": {
                useScopeType = UseScope.Type.FUNCTION;
                break;
            }
            case "const": {
                useScopeType = UseScope.Type.CONST;
                break;
            }
            default: {
                assert (false) : "Unknown type: " + useType;
                break;
            }
        }
        return useScopeType;
    }

    public static AutoImport get(PHPParseResult parserResult) {
        return new AutoImport(parserResult);
    }

    private AutoImport(PHPParseResult parserResult) {
        this.parserResult = parserResult;
    }

    public void insert(Hints hints, int caretPosition) {
        this.insert(hints.getFqName(), hints.getAliasName(), hints.getUseScopeType(), caretPosition);
    }

    void insert(String fqInsertName, UseScope.Type type, int caretPosition) {
        this.insert(fqInsertName, "", type, caretPosition);
    }

    void insert(String fqInsertName, String aliasName, UseScope.Type type, int caretPosition) {
        BaseDocument baseDocument;
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.parserResult, caretPosition);
        if (!this.canInsert(fqInsertName, namespaceScope)) {
            return;
        }
        assert (namespaceScope != null);
        Document document = this.parserResult.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            document = this.parserResult.getSnapshot().getSource().getDocument(true);
            LOGGER.log(Level.INFO, "document was opened forcibly");
        }
        BaseDocument baseDocument2 = baseDocument = document instanceof BaseDocument ? (BaseDocument)document : null;
        if (baseDocument == null) {
            return;
        }
        Object aliasedName = fqInsertName;
        if (!aliasName.isEmpty()) {
            aliasedName = (String)aliasedName + " as " + aliasName;
        }
        AutoImportResolver resolver = AutoImportResolver.create((String)aliasedName, type, this.parserResult, namespaceScope, baseDocument);
        resolver.resolve();
        this.insertUseStatement(resolver, baseDocument);
    }

    private boolean canInsert(String fqInsertName, NamespaceScope namespaceScope) {
        boolean result = true;
        if (!fqInsertName.contains("\\") && StringUtils.isEmpty((String)namespaceScope.getName())) {
            result = false;
        } else {
            String name = namespaceScope.getName();
            if (name.equals(QualifiedName.create(fqInsertName).getNamespaceName())) {
                result = false;
            }
        }
        return result;
    }

    private void insertUseStatement(AutoImportResolver resolver, BaseDocument baseDocument) {
        if (!resolver.canImport()) {
            return;
        }
        int insertOffset = resolver.getInsertOffset();
        String insertString = resolver.getInsertString();
        EditList editList = new EditList(baseDocument);
        editList.replace(insertOffset, 0, insertString, true, 0);
        editList.apply();
    }

    public static final class Hints {
        private final String fqName;
        private final String useType;
        @NullAllowed
        private final String aliasName;

        public Hints(String fqName, String useType, @NullAllowed String aliasName) {
            this.fqName = fqName;
            assert (!useType.isEmpty());
            this.useType = useType;
            this.aliasName = aliasName;
        }

        public Hints(String fqName, String useType) {
            this(fqName, useType, null);
        }

        public String getFqName() {
            return this.fqName;
        }

        public String getUseType() {
            return this.useType;
        }

        public UseScope.Type getUseScopeType() {
            return AutoImport.getUseScopeType(this.useType);
        }

        @CheckForNull
        public String getAliasName() {
            return this.aliasName;
        }
    }

    private static final class AutoImportResolver {
        private static final Logger LOGGER = Logger.getLogger(AutoImportResolver.class.getName());
        private final String insertName;
        private final UseScope.Type type;
        private final PHPParseResult parserResult;
        private final NamespaceScope namespaceScope;
        private final BaseDocument baseDocument;
        private final TokenSequence<PHPTokenId> tokenSequence;
        private final List<GroupUseScope> declaredGroupUses;
        private final List<UseScope> declaredSingleUses;
        private final List<UseScope> typeUseScopes = new ArrayList<UseScope>();
        private final List<UseScope> constUseScopes = new ArrayList<UseScope>();
        private final List<UseScope> functionUseScopes = new ArrayList<UseScope>();
        private final Map<String, UseScope> typeNames = new LinkedHashMap<String, UseScope>();
        private final Map<String, UseScope> constNames = new LinkedHashMap<String, UseScope>();
        private final Map<String, UseScope> functionNames = new LinkedHashMap<String, UseScope>();
        private int insertOffset = -1;
        private String insertString = "";
        private int indexOfInsertName = -1;
        private boolean canImport = true;
        private boolean addNewLineBeforeUse = false;

        public static AutoImportResolver create(String insertName, UseScope.Type type, PHPParseResult parserResult, NamespaceScope namespaceScope, BaseDocument baseDocument) {
            Collection<? extends GroupUseScope> declaredGroupUses = namespaceScope.getDeclaredGroupUses();
            Collection<? extends UseScope> declaredSingleUses = namespaceScope.getDeclaredSingleUses();
            AutoImportResolver autoImportResolver = new AutoImportResolver(insertName, type, parserResult, namespaceScope, declaredGroupUses, declaredSingleUses, baseDocument);
            autoImportResolver.init();
            return autoImportResolver;
        }

        private AutoImportResolver(String insertName, UseScope.Type type, PHPParseResult parserResult, NamespaceScope namespaceScope, Collection<? extends GroupUseScope> declaredGroupUses, Collection<? extends UseScope> declaredSingleUses, BaseDocument baseDocument) {
            this.insertName = insertName;
            this.insertString = insertName;
            this.type = type;
            this.parserResult = parserResult;
            this.namespaceScope = namespaceScope;
            this.declaredGroupUses = new ArrayList<GroupUseScope>(declaredGroupUses);
            this.declaredSingleUses = new ArrayList<UseScope>(declaredSingleUses);
            this.baseDocument = baseDocument;
            this.tokenSequence = parserResult.getSnapshot().getTokenHierarchy().tokenSequence(PHPTokenId.language());
        }

        public int getInsertOffset() {
            return this.insertOffset;
        }

        public String getInsertString() {
            return this.insertString;
        }

        public boolean canImport() {
            return this.canImport && this.insertOffset != -1;
        }

        public void resolve() {
            Map<String, UseScope> useScopeNames = this.getNamedUseScopes(this.type);
            if (useScopeNames.keySet().contains(this.insertName)) {
                this.canImport = false;
                return;
            }
            List<String> names = this.getUseScopeNames(useScopeNames);
            this.indexOfInsertName = this.findInsertNameIndex(names);
            if (this.indexOfInsertName > 0) {
                String name = names.get(this.indexOfInsertName);
                if (this.canInsertIntoNextGroupUse(name, useScopeNames)) {
                    this.processInsertingBeforeNextUse(names, useScopeNames, this.indexOfInsertName);
                } else {
                    this.processInsertingAfterPreviousUse(names, useScopeNames, this.indexOfInsertName);
                }
            } else if (this.indexOfInsertName == 0) {
                this.processInsertingBeforeNextUse(names, useScopeNames, 0);
            } else {
                this.processInserting();
            }
        }

        private boolean canInsertIntoNextGroupUse(String name, Map<String, UseScope> useScopeNames) {
            String groupUseBaseName;
            UseScope useScope = useScopeNames.get(name);
            return useScope != null && useScope.isPartOfGroupUse() && this.insertName.startsWith(groupUseBaseName = this.getGroupUseBaseName(useScope));
        }

        private boolean isPartOfMultipleUse(UseScope useScope) {
            this.tokenSequence.move(useScope.getOffset());
            if (this.tokenSequence.moveNext()) {
                Token<? extends PHPTokenId> useToken = LexUtilities.findPreviousToken(this.tokenSequence, Arrays.asList(PHPTokenId.PHP_USE));
                assert (useToken != null) : "Use statement should start with \"use\", but not found it";
                while (this.tokenSequence.moveNext() && this.tokenSequence.token().id() != PHPTokenId.PHP_SEMICOLON) {
                    if (this.tokenSequence.token().id() != PHPTokenId.PHP_TOKEN || !TokenUtilities.equals((CharSequence)this.tokenSequence.token().text(), (Object)",")) continue;
                    return true;
                }
            }
            return false;
        }

        private int getEndOfUseStetement(UseScope useScope) {
            this.tokenSequence.move(useScope.getOffset());
            while (this.tokenSequence.moveNext()) {
                if (this.tokenSequence.token().id() != PHPTokenId.PHP_SEMICOLON) continue;
                return this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            return this.getLineEnd(useScope.getOffset());
        }

        private void processInsertingAfterPreviousUse(List<String> names, Map<String, UseScope> useScopeNames, int indexOfInsertName) {
            String previousName = names.get(indexOfInsertName - 1);
            UseScope previousUseScope = useScopeNames.get(previousName);
            if (previousUseScope.isPartOfGroupUse()) {
                String baseName = this.getGroupUseBaseName(previousUseScope);
                if (this.insertName.startsWith(baseName)) {
                    this.insertOffset = previousUseScope.getNameRange().getEnd();
                    this.insertString = ", " + this.insertName.substring(baseName.length() + "\\".length());
                } else {
                    GroupUseScope previousGroupUseScope = this.findGroupUseScope(previousUseScope);
                    if (previousGroupUseScope != null) {
                        this.insertOffset = this.getLineEnd(previousGroupUseScope.getNameRange().getEnd());
                        this.insertString = "\n" + this.createSingleUseStatement();
                    }
                }
            } else if (this.isPartOfMultipleUse(previousUseScope)) {
                this.insertOffset = this.getEndOfUseStetement(previousUseScope);
                this.insertString = "\n" + this.createSingleUseStatement();
            } else {
                this.insertOffset = this.getLineEnd(previousUseScope.getNameRange().getEnd());
                this.insertString = this.createSingleUseStatement();
            }
        }

        private void processInsertingBeforeNextUse(List<String> names, Map<String, UseScope> useScopeNames, int indexOfInsertName) {
            if (!names.isEmpty()) {
                String nextName = names.get(indexOfInsertName);
                UseScope nextUseScope = useScopeNames.get(nextName);
                if (nextUseScope.isPartOfGroupUse()) {
                    String groupUseBaseName = this.getGroupUseBaseName(nextUseScope);
                    if (this.insertName.startsWith(groupUseBaseName)) {
                        this.insertOffset = nextUseScope.getNameRange().getStart();
                        this.insertString = this.insertName.substring(groupUseBaseName.length() + "\\".length()) + ", ";
                    } else {
                        GroupUseScope nextGroupUseScope = this.findGroupUseScope(nextUseScope);
                        if (nextGroupUseScope != null) {
                            this.insertOffset = this.getLineStart(nextGroupUseScope.getNameRange().getStart());
                            this.insertString = this.createSingleUseStatement();
                        }
                    }
                } else {
                    this.insertOffset = this.getLineStart(nextUseScope.getOffset());
                    this.insertString = this.createSingleUseStatement();
                }
            }
        }

        private void processInserting() {
            List<UseScope> typeScopes = this.getUseScopes(UseScope.Type.TYPE);
            List<UseScope> functionScopes = this.getUseScopes(UseScope.Type.FUNCTION);
            List<UseScope> constScopes = this.getUseScopes(UseScope.Type.CONST);
            if (typeScopes.isEmpty() && functionScopes.isEmpty() && constScopes.isEmpty()) {
                this.processInsertingFirstUse();
            } else {
                this.processInsertingFirstUseKind(typeScopes, functionScopes, constScopes);
            }
        }

        private void processInsertingFirstUse() {
            List<? extends ModelElement> elements;
            int offset = this.namespaceScope.getBlockRange().getStart();
            String word = this.getWord(offset);
            if (word != null && word.equals("{")) {
                ++offset;
            }
            if (!(elements = this.namespaceScope.getElements()).isEmpty()) {
                int start;
                offset = this.getLineStart(elements.get(0).getOffset());
                int attributeStart = this.findAttributeStart(offset);
                while (attributeStart != -1) {
                    offset = attributeStart;
                    attributeStart = this.findAttributeStart(attributeStart);
                }
                int phpDocStart = this.findPhpDocStart(offset);
                if (phpDocStart != -1) {
                    offset = phpDocStart;
                }
                if ((start = this.findInsertStart(offset)) != -1) {
                    offset = start;
                }
                offset = this.getLineStart(offset);
            } else {
                DeclareStatement lastDeclareStatement = this.findLastDeclareStatement();
                if (lastDeclareStatement != null) {
                    Statement body = lastDeclareStatement.getBody();
                    if (!(body instanceof EmptyStatement)) {
                        this.addNewLineBeforeUse = true;
                    }
                    offset = lastDeclareStatement.getEndOffset();
                }
            }
            this.insertOffset = offset;
            this.insertString = this.createSingleUseStatement();
        }

        private int findAttributeStart(int offset) {
            Token<? extends PHPTokenId> attributeToken;
            List<PHPTokenId> ignores;
            Token<? extends PHPTokenId> findPrevious;
            int result = -1;
            this.tokenSequence.move(offset);
            if (this.tokenSequence.movePrevious() && (findPrevious = LexUtilities.findPrevious(this.tokenSequence, ignores = Arrays.asList(PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT_END, PHPTokenId.WHITESPACE))) != null && TokenUtilities.textEquals((CharSequence)findPrevious.text(), (CharSequence)"]") && (attributeToken = LexUtilities.findPreviousToken(this.tokenSequence, Arrays.asList(PHPTokenId.PHP_ATTRIBUTE))) != null) {
                return this.tokenSequence.offset();
            }
            return result;
        }

        private int findPhpDocStart(int offset) {
            Token<? extends PHPTokenId> phpDocStart;
            List<PHPTokenId> ignores;
            Token<? extends PHPTokenId> findPrevious;
            int result = -1;
            this.tokenSequence.move(offset);
            if (this.tokenSequence.movePrevious() && (findPrevious = LexUtilities.findPrevious(this.tokenSequence, ignores = Arrays.asList(PHPTokenId.WHITESPACE))) != null && findPrevious.id() == PHPTokenId.PHPDOC_COMMENT_END && (phpDocStart = LexUtilities.findPreviousToken(this.tokenSequence, Arrays.asList(PHPTokenId.PHPDOC_COMMENT_START))) != null) {
                return this.tokenSequence.offset();
            }
            return result;
        }

        private int findInsertStart(int offset) {
            int result = -1;
            this.tokenSequence.move(offset);
            while (this.tokenSequence.movePrevious()) {
                PHPTokenId id = (PHPTokenId)this.tokenSequence.token().id();
                if (id == PHPTokenId.WHITESPACE && this.hasBlankLine((Token<PHPTokenId>)this.tokenSequence.token())) {
                    result = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    break;
                }
                if (id != PHPTokenId.WHITESPACE && id != PHPTokenId.PHPDOC_COMMENT_START && id != PHPTokenId.PHPDOC_COMMENT && id != PHPTokenId.PHPDOC_COMMENT_END && id != PHPTokenId.PHP_COMMENT_START && id != PHPTokenId.PHP_COMMENT && id != PHPTokenId.PHP_COMMENT_END && id != PHPTokenId.PHP_LINE_COMMENT) break;
                if (id != PHPTokenId.PHPDOC_COMMENT_START && id != PHPTokenId.PHP_COMMENT_START && id != PHPTokenId.PHP_LINE_COMMENT) continue;
                result = this.tokenSequence.offset();
            }
            return result;
        }

        @CheckForNull
        private DeclareStatement findLastDeclareStatement() {
            Program program = this.parserResult.getProgram();
            if (program != null) {
                CheckVisitor checkVisitor = new CheckVisitor();
                program.accept(checkVisitor);
                List<DeclareStatement> declareStatements = checkVisitor.getDeclareStatements();
                if (!declareStatements.isEmpty()) {
                    return declareStatements.get(declareStatements.size() - 1);
                }
            }
            return null;
        }

        private void processInsertingFirstUseKind(List<UseScope> typeScopes, List<UseScope> functionScopes, List<UseScope> constScopes) {
            List<UseScope> allUseScopes = this.getAllUseScopes();
            CodeStyle codeStyle = CodeStyle.get((Document)this.baseDocument);
            boolean isPSR12 = codeStyle.putInPSR12Order();
            switch (this.type) {
                case TYPE: {
                    this.setInsertOffsetBeforeTop(allUseScopes);
                    break;
                }
                case CONST: {
                    if (isPSR12) {
                        this.setInsertOffsetAfterBottom(allUseScopes);
                        break;
                    }
                    if (!typeScopes.isEmpty()) {
                        this.setInsertOffsetAfterBottom(typeScopes);
                        break;
                    }
                    this.setInsertOffsetBeforeTop(functionScopes);
                    break;
                }
                case FUNCTION: {
                    if (isPSR12) {
                        if (!typeScopes.isEmpty()) {
                            this.setInsertOffsetAfterBottom(typeScopes);
                            break;
                        }
                        this.setInsertOffsetBeforeTop(constScopes);
                        break;
                    }
                    this.setInsertOffsetAfterBottom(allUseScopes);
                    break;
                }
                default: {
                    assert (false) : "Unknown type: " + String.valueOf((Object)this.type);
                    break;
                }
            }
            this.insertString = this.createSingleUseStatement();
        }

        private void setInsertOffsetBeforeTop(List<UseScope> useScopes) {
            UseScope topScope = useScopes.get(0);
            this.setInsertOffsetBefore(topScope);
        }

        private void setInsertOffsetBefore(UseScope topUseScope) {
            if (topUseScope.isPartOfGroupUse()) {
                GroupUseScope groupUseScope = this.findGroupUseScope(topUseScope);
                if (groupUseScope != null) {
                    this.insertOffset = this.getLineStart(groupUseScope.getNameRange().getStart());
                }
            } else {
                this.insertOffset = this.getLineStart(topUseScope.getNameRange().getStart());
            }
        }

        private void setInsertOffsetAfterBottom(List<UseScope> useScopes) {
            UseScope bottomScope = useScopes.get(useScopes.size() - 1);
            this.setInsertOffsetAfter(bottomScope);
        }

        private void setInsertOffsetAfter(UseScope bottomUseScope) {
            if (bottomUseScope.isPartOfGroupUse()) {
                GroupUseScope groupUseScope = this.findGroupUseScope(bottomUseScope);
                if (groupUseScope != null) {
                    this.insertOffset = this.getLineEnd(groupUseScope.getNameRange().getEnd());
                    this.addNewLineBeforeUse = true;
                }
            } else if (this.isPartOfMultipleUse(bottomUseScope)) {
                this.insertOffset = this.getEndOfUseStetement(bottomUseScope);
                this.addNewLineBeforeUse = true;
            } else {
                this.insertOffset = this.getLineEnd(bottomUseScope.getNameRange().getEnd());
            }
        }

        private List<String> getUseScopeNames(Map<String, UseScope> useScopeNames) {
            ArrayList<String> names = new ArrayList<String>(useScopeNames.keySet());
            if (!names.isEmpty()) {
                names.add(this.insertName);
            }
            return names;
        }

        private int findInsertNameIndex(List<String> names) {
            int insertNameIndex = -1;
            for (String name : names) {
                int currentIndex = names.indexOf(name);
                if (this.insertName.compareToIgnoreCase(name) <= 0) {
                    insertNameIndex = currentIndex;
                    break;
                }
                if (name.compareToIgnoreCase(names.get(currentIndex + 1)) <= 0) continue;
                insertNameIndex = currentIndex + 1;
                break;
            }
            if (insertNameIndex == -1 && !names.isEmpty()) {
                insertNameIndex = 0;
            }
            return insertNameIndex;
        }

        @CheckForNull
        private String getWord(int offset) {
            try {
                return LineDocumentUtils.getWord((LineDocument)this.baseDocument, (int)offset);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
                return null;
            }
        }

        private int getLineStart(int offset) {
            return LineDocumentUtils.getLineStart((LineDocument)this.baseDocument, (int)offset);
        }

        private int getLineEnd(int offset) {
            try {
                return LineDocumentUtils.getLineEnd((LineDocument)this.baseDocument, (int)offset);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
                return offset;
            }
        }

        private boolean hasOtherTypeUseAbove() {
            if (this.insertOffset != -1) {
                List<UseScope> useScopes = this.getUseScopesExceptFor(this.type);
                this.sortByOffset(useScopes);
                if (!useScopes.isEmpty()) {
                    for (UseScope useScope : useScopes) {
                        if (useScope.getOffset() >= this.insertOffset) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean hasBlankLinesBeforeInsertOffset() {
            if (this.insertOffset != -1) {
                Token token;
                this.tokenSequence.move(this.insertOffset);
                if (this.tokenSequence.moveNext()) {
                    token = this.tokenSequence.token();
                    if (token.id() == PHPTokenId.WHITESPACE) {
                        return this.hasBlankLine((Token<PHPTokenId>)token);
                    }
                    if (token.id() != PHPTokenId.PHP_USE) {
                        return false;
                    }
                }
                if (this.tokenSequence.movePrevious() && (token = this.tokenSequence.token()).id() == PHPTokenId.WHITESPACE) {
                    return this.hasBlankLine((Token<PHPTokenId>)token);
                }
            }
            return false;
        }

        private boolean hasBlankLine(Token<PHPTokenId> token) {
            return token.text().chars().filter(c -> c == 10).count() >= 2L;
        }

        private String getBlankLinesBeteenUseTypes() {
            StringBuilder sb = new StringBuilder();
            CodeStyle codeStyle = CodeStyle.get((Document)this.baseDocument);
            if (codeStyle.getBlankLinesBetweenUseTypes() > 0 && this.hasOtherTypeUseAbove()) {
                for (int i = 0; i < codeStyle.getBlankLinesBetweenUseTypes(); ++i) {
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        private String createSingleUseStatement() {
            StringBuilder extraSpaces = new StringBuilder();
            if (this.addToTopOfUseType() && !this.hasBlankLinesBeforeInsertOffset()) {
                extraSpaces.append(this.getBlankLinesBeteenUseTypes());
            }
            if (extraSpaces.length() == 0 && this.addNewLineBeforeUse) {
                extraSpaces.append("\n");
            }
            OffsetRange blockRange = this.namespaceScope.getBlockRange();
            String blockStartWord = null;
            if (blockRange != null) {
                blockStartWord = this.getWord(blockRange.getStart());
            }
            if (blockStartWord != null && blockStartWord.startsWith("{")) {
                CodeStyle codeStyle = CodeStyle.get((Document)this.baseDocument);
                extraSpaces.append(IndentUtils.createIndentString((int)codeStyle.getIndentSize(), (boolean)codeStyle.expandTabToSpaces(), (int)codeStyle.getTabSize()));
            }
            return this.createSingleUseStatement(extraSpaces.toString());
        }

        private String createSingleUseStatement(String extraSpaces) {
            StringBuilder sb = new StringBuilder();
            if (this.insertOffset == 0) {
                sb.append("<?php").append("\n");
            }
            sb.append(extraSpaces);
            sb.append("use ");
            switch (this.type) {
                case TYPE: {
                    break;
                }
                case CONST: {
                    sb.append("const ");
                    break;
                }
                case FUNCTION: {
                    sb.append("function ");
                    break;
                }
                default: {
                    assert (false) : "Unknown Type: " + String.valueOf((Object)this.type);
                    break;
                }
            }
            sb.append(this.insertName).append(";");
            if (this.insertOffset == 0) {
                sb.append("\n").append("?>");
            }
            sb.append("\n");
            return sb.toString();
        }

        private boolean addToTopOfUseType() {
            return this.indexOfInsertName == 0;
        }

        private String getGroupUseBaseName(UseScope useScope) {
            GroupUseScope groupUseScope;
            String baseNamespaceName = QualifiedName.create(useScope.getName()).getNamespaceName();
            if (useScope.isPartOfGroupUse() && (groupUseScope = this.findGroupUseScope(useScope)) != null) {
                boolean find = false;
                while (!find && !StringUtils.isEmpty((String)baseNamespaceName)) {
                    find = true;
                    for (UseScope useScope1 : groupUseScope.getUseScopes()) {
                        if (useScope1.getName().startsWith(baseNamespaceName)) continue;
                        find = false;
                        break;
                    }
                    if (find) break;
                    baseNamespaceName = QualifiedName.create(baseNamespaceName).getNamespaceName();
                }
            }
            return baseNamespaceName;
        }

        @CheckForNull
        private GroupUseScope findGroupUseScope(UseScope useScope) {
            for (GroupUseScope declaredGroupUse : this.declaredGroupUses) {
                for (UseScope declaredUseScope : declaredGroupUse.getUseScopes()) {
                    if (useScope != declaredUseScope) continue;
                    return declaredGroupUse;
                }
            }
            return null;
        }

        private List<UseScope> getAllUseScopes() {
            ArrayList<UseScope> allUseScopes = new ArrayList<UseScope>();
            allUseScopes.addAll(this.getUseScopes(UseScope.Type.TYPE));
            allUseScopes.addAll(this.getUseScopes(UseScope.Type.FUNCTION));
            allUseScopes.addAll(this.getUseScopes(UseScope.Type.CONST));
            this.sortByOffset(allUseScopes);
            return allUseScopes;
        }

        private List<UseScope> getUseScopes(UseScope.Type type) {
            switch (type) {
                case TYPE: {
                    return Collections.unmodifiableList(this.typeUseScopes);
                }
                case FUNCTION: {
                    return Collections.unmodifiableList(this.functionUseScopes);
                }
                case CONST: {
                    return Collections.unmodifiableList(this.constUseScopes);
                }
            }
            assert (false) : "Unknown type: " + String.valueOf((Object)type);
            return Collections.emptyList();
        }

        private List<UseScope> getUseScopesExceptFor(UseScope.Type type) {
            ArrayList<UseScope> useScopes = new ArrayList<UseScope>();
            switch (type) {
                case TYPE: {
                    useScopes.addAll(this.getUseScopes(UseScope.Type.FUNCTION));
                    useScopes.addAll(this.getUseScopes(UseScope.Type.CONST));
                    break;
                }
                case FUNCTION: {
                    useScopes.addAll(this.getUseScopes(UseScope.Type.TYPE));
                    useScopes.addAll(this.getUseScopes(UseScope.Type.CONST));
                    break;
                }
                case CONST: {
                    useScopes.addAll(this.getUseScopes(UseScope.Type.TYPE));
                    useScopes.addAll(this.getUseScopes(UseScope.Type.FUNCTION));
                    break;
                }
                default: {
                    assert (false) : "Unknown type: " + String.valueOf((Object)type);
                    return Collections.emptyList();
                }
            }
            return useScopes;
        }

        private Map<String, UseScope> getNamedUseScopes(UseScope.Type type) {
            LinkedHashMap<String, UseScope> names = new LinkedHashMap<String, UseScope>();
            switch (type) {
                case TYPE: {
                    names.putAll(this.typeNames);
                    break;
                }
                case CONST: {
                    names.putAll(this.constNames);
                    break;
                }
                case FUNCTION: {
                    names.putAll(this.functionNames);
                    break;
                }
                default: {
                    assert (false) : "Unknown type: " + String.valueOf((Object)type);
                    break;
                }
            }
            return names;
        }

        private void init() {
            this.processGroupUses();
            this.processSingleUses();
            this.sortEachUseKindScope();
            for (UseScope useScope : this.typeUseScopes) {
                this.addUseScope(this.typeNames, useScope);
            }
            for (UseScope useScope : this.constUseScopes) {
                this.addUseScope(this.constNames, useScope);
            }
            for (UseScope useScope : this.functionUseScopes) {
                this.addUseScope(this.functionNames, useScope);
            }
        }

        private void addUseScope(Map<String, UseScope> useScopeNames, UseScope useScope) {
            Object name = useScope.getName();
            AliasedName aliasedName = useScope.getAliasedName();
            if (aliasedName != null) {
                name = (String)name + " as " + aliasedName.getAliasName();
            }
            useScopeNames.put((String)name, useScope);
        }

        private void processGroupUses() {
            block5: for (GroupUseScope declaredGroupUse : this.declaredGroupUses) {
                switch (declaredGroupUse.getType()) {
                    case TYPE: {
                        this.typeUseScopes.addAll(declaredGroupUse.getUseScopes());
                        continue block5;
                    }
                    case CONST: {
                        this.constUseScopes.addAll(declaredGroupUse.getUseScopes());
                        continue block5;
                    }
                    case FUNCTION: {
                        this.functionUseScopes.addAll(declaredGroupUse.getUseScopes());
                        continue block5;
                    }
                }
                assert (false) : "Unhandled Type: " + String.valueOf((Object)declaredGroupUse.getType());
            }
        }

        private void processSingleUses() {
            block5: for (UseScope declaredSingleUse : this.declaredSingleUses) {
                switch (declaredSingleUse.getType()) {
                    case TYPE: {
                        this.typeUseScopes.add(declaredSingleUse);
                        continue block5;
                    }
                    case CONST: {
                        this.constUseScopes.add(declaredSingleUse);
                        continue block5;
                    }
                    case FUNCTION: {
                        this.functionUseScopes.add(declaredSingleUse);
                        continue block5;
                    }
                }
                assert (false) : "Unhandled Type: " + String.valueOf((Object)declaredSingleUse.getType());
            }
        }

        private void sortEachUseKindScope() {
            this.sortByOffset(this.typeUseScopes);
            this.sortByOffset(this.constUseScopes);
            this.sortByOffset(this.functionUseScopes);
        }

        private void sortByOffset(List<UseScope> useScopes) {
            useScopes.sort((use1, use2) -> Integer.compare(use1.getOffset(), use2.getOffset()));
        }
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private final List<DeclareStatement> declareStatements = new ArrayList<DeclareStatement>();

        private CheckVisitor() {
        }

        @Override
        public void visit(DeclareStatement node) {
            this.declareStatements.add(node);
            super.visit(node);
        }

        public List<DeclareStatement> getDeclareStatements() {
            return Collections.unmodifiableList(this.declareStatements);
        }
    }
}

