/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api.elements;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.openide.filesystems.FileObject;

public class AliasedElement
implements FullyQualifiedElement {
    protected final FullyQualifiedElement element;
    private final AliasedName aliasedName;
    private QualifiedName aliasFqn;
    private Trait trait = Trait.ELEMENT;

    public AliasedElement(AliasedName aliasedName, FullyQualifiedElement element) {
        this.aliasedName = aliasedName;
        this.element = element;
    }

    public final QualifiedName getNamespaceName(Trait traitOfName) {
        return this.getFullyQualifiedName(traitOfName).toNamespaceName();
    }

    public final String getName(Trait traitOfName) {
        return this.getFullyQualifiedName(traitOfName).getName();
    }

    public final synchronized QualifiedName getFullyQualifiedName(Trait traitOfName) {
        if (traitOfName.equals((Object)Trait.ALIAS)) {
            if (this.aliasFqn == null) {
                this.aliasFqn = this.element.getFullyQualifiedName();
                LinkedList<String> originalSegments = this.aliasFqn.getSegments();
                LinkedList<String> toReplaceSegments = this.aliasedName.getRealName().getSegments();
                LinkedList<String> resultSegments = new LinkedList<String>();
                assert (toReplaceSegments.size() > 0);
                String firstSegment = toReplaceSegments.get(0);
                for (int i = 0; i < originalSegments.size(); ++i) {
                    String nextSegment = originalSegments.get(i);
                    if (i <= originalSegments.size() - toReplaceSegments.size() && NameKind.exact(nextSegment).matchesName(PhpElementKind.INDEX, firstSegment)) {
                        List subList = originalSegments.subList(i, i + toReplaceSegments.size());
                        if (subList.equals(toReplaceSegments)) {
                            resultSegments.add(this.aliasedName.getAliasName());
                            i += subList.size() - 1;
                            continue;
                        }
                        resultSegments.add(nextSegment);
                        continue;
                    }
                    resultSegments.add(nextSegment);
                }
                this.aliasFqn = QualifiedName.create(true, resultSegments);
            }
            return this.aliasFqn;
        }
        return this.element.getFullyQualifiedName();
    }

    @Override
    public final QualifiedName getNamespaceName() {
        return this.getNamespaceName(this.trait);
    }

    public final String getName() {
        return this.getName(this.trait);
    }

    public final boolean isNameAliased() {
        return !NameKind.exact(this.getName(Trait.ALIAS)).matchesName(this.element);
    }

    public final boolean isNamespaceNameAliased() {
        return !NameKind.exact(this.getNamespaceName(Trait.ALIAS)).matchesName(this.element);
    }

    @Override
    public final QualifiedName getFullyQualifiedName() {
        return this.getFullyQualifiedName(this.trait);
    }

    @Override
    public final boolean isAliased() {
        return true;
    }

    @Override
    public final ElementQuery getElementQuery() {
        return this.element.getElementQuery();
    }

    @Override
    public final String getFilenameUrl() {
        return this.element.getFilenameUrl();
    }

    @Override
    public final PhpModifiers getPhpModifiers() {
        return this.element.getPhpModifiers();
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return this.element.getPhpElementKind();
    }

    @Override
    public final int getOffset() {
        return this.element.getOffset();
    }

    @Override
    public final int getFlags() {
        return this.element.getFlags();
    }

    @Override
    public final boolean isPlatform() {
        return this.element.isPlatform();
    }

    @Override
    public final boolean isDeprecated() {
        return this.element.isDeprecated();
    }

    public final FileObject getFileObject() {
        return this.element.getFileObject();
    }

    public final String getMimeType() {
        return this.element.getMimeType();
    }

    public final String getIn() {
        return this.element.getIn();
    }

    public final ElementKind getKind() {
        return this.element.getKind();
    }

    public final Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public final boolean signatureEquals(ElementHandle handle) {
        return this.element.signatureEquals(handle);
    }

    public final OffsetRange getOffsetRange(ParserResult result) {
        return this.element.getOffsetRange(result);
    }

    public AliasedName getAliasedName() {
        return this.aliasedName;
    }

    public Trait getTrait() {
        return this.trait;
    }

    public void setTrait(Trait trait) {
        this.trait = trait;
    }

    public static enum Trait {
        ALIAS,
        ELEMENT;

    }
}

