/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.ContextNamesCommand;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.modules.php.dbgp.packets.StackGetResponse;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Mutex;

public class CallStackModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private final ContextProvider myContextProvider;
    private AtomicReference<List<Stack>> myStack;
    private AtomicReference<Stack> myCurrentStack;

    public CallStackModel(ContextProvider contextProvider) {
        this.myContextProvider = contextProvider;
        this.myStack = new AtomicReference();
        this.myCurrentStack = new AtomicReference();
    }

    @Override
    public void clearModel() {
        this.setCallStack(new ArrayList<Stack>());
    }

    public Object getRoot() {
        return "Root";
    }

    public void setCallStack(List<Stack> stacks) {
        ArrayList<Stack> list = new ArrayList<Stack>(stacks);
        this.myStack.set(list);
        if (list.size() > 0) {
            this.myCurrentStack.set((Stack)list.get(0));
        }
        this.refresh();
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            List<Stack> list = this.myStack.get();
            if (list == null) {
                return new Object[0];
            }
            if (from >= list.size()) {
                return new Object[0];
            }
            int end = Math.min(list.size(), to);
            List<Stack> stack = list.subList(from, end);
            return stack.toArray();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Stack) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            List<Stack> list = this.myStack.get();
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Stack) {
            Stack stack = (Stack)node;
            String commandName = stack.getCurrentCommandName();
            if (commandName == null) {
                return this.getFile(stack) + ":" + stack.getLine();
            }
            return this.getFile(stack) + "." + commandName + ":" + stack.getLine();
        }
        if (node == "Root") {
            return "Root".toString();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof Stack) {
            Stack curStack = this.myCurrentStack.get();
            if (curStack == node) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Stack) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof Stack) {
            Stack stack = (Stack)node;
            this.updateDependentViews(stack);
            final Line line = Utils.getLine(stack.getLine(), stack.getFileName(), this.getSessionId());
            if (line != null) {
                Mutex.EVENT.readAccess(new Runnable(){
                    final /* synthetic */ CallStackModel this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
                    }
                });
            }
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Stack) {
            if ("CallStackFrameLocation".equals(columnID)) {
                Stack stack = (Stack)node;
                return this.getFile(stack);
            }
            return "?! unknown column";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return true;
        }
        if (node instanceof Stack) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    private ContextProvider getContextProvider() {
        return this.myContextProvider;
    }

    private SessionId getSessionId() {
        return (SessionId)this.getContextProvider().lookupFirst(null, SessionId.class);
    }

    private String getFile(Stack stack) {
        String retval;
        String fileName = stack.getFileName();
        FileObject fileObject = this.getSessionId().toSourceFile(fileName);
        if (fileObject == null) {
            return fileName;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (retval = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fileObject)) != null) {
            return retval;
        }
        File f = FileUtil.toFile((FileObject)fileObject);
        return f != null ? f.getAbsolutePath() : fileName;
    }

    private DebugSession getSession() {
        return SessionManager.getInstance().getSession(this.getSessionId());
    }

    private void updateDependentViews(Stack stack) {
        this.myCurrentStack.set(stack);
        DebugSession session = this.getSession();
        if (session == null) {
            return;
        }
        int depth = stack.getLevel();
        ContextNamesCommand command = new ContextNamesCommand(session.getTransactionId());
        command.setDepth(depth);
        session.sendCommandLater(command);
        StackGetResponse.updateWatchView(session);
        this.refresh();
    }
}

