/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.sun.api.ExtendedClassLoader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class ServerLocationManager {
    public static final int SJSAS_90 = 900;
    public static final int SJSAS_91 = 910;
    public static final int SJSAS_82 = 820;
    public static final int GF_V1 = 900;
    public static final int GF_V2 = 910;
    public static final int GF_V2point1 = 911;
    public static final int GF_V2point1point1 = 912;
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private static final String JAR_BRIGDES_DEFINITION_LAYER = "/J2EE/SunAppServer/Bridge";
    private static Map serverLocationAndClassLoaderMap = Collections.synchronizedMap(new HashMap(2, 1.0f));
    private static Collection fileColl = new ArrayList();

    private static void updatePluginLoader(File platformLocation, ExtendedClassLoader loader) throws Exception {
        try {
            File f = platformLocation;
            if (null == f || !f.exists()) {
                return;
            }
            String installRoot = f.getAbsolutePath();
            FileObject bridgesDir = FileUtil.getConfigFile((String)JAR_BRIGDES_DEFINITION_LAYER);
            FileObject[] ch = new FileObject[]{};
            if (bridgesDir != null) {
                ch = bridgesDir.getChildren();
            }
            for (int i = 0; i < ch.length; ++i) {
                String location = (String)ch[i].getAttribute("jar.location");
                InstalledFileLocator fff = InstalledFileLocator.getDefault();
                f = fff.locate(location, null, true);
                if (f != null) {
                    loader.addURL(f);
                    ServerLocationManager.loadLocaleSpecificJars(f, loader);
                    continue;
                }
                System.out.println("cannot locate file " + location);
            }
            f = new File(installRoot + "/lib/appserver-deployment-client.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/appserv-admin.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/appserv-ext.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/appserv-rt.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/appserv-cmp.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/commons-logging.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/admin-cli.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/common-laucher.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/j2ee.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/install/applications/jmsra/imqjmsra.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/jaxrpc-api.jar");
            loader.addURL(f);
            f = new File(installRoot + "/lib/jaxrpc-impl.jar");
            loader.addURL(f);
        }
        catch (Exception ex2) {
            throw new Exception(ex2.getLocalizedMessage());
        }
    }

    public static File getLatestPlatformLocation() {
        Iterator i = serverLocationAndClassLoaderMap.entrySet().iterator();
        File ret = null;
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String loc = (String)e.getKey();
            File possibleOne = new File(loc);
            if (ret == null) {
                ret = possibleOne;
            }
            if (!ServerLocationManager.isGlassFish(possibleOne)) continue;
            ret = possibleOne;
        }
        return ret;
    }

    public static ClassLoader getServerOnlyClassLoader(File platformLocation) {
        CacheData data = (CacheData)serverLocationAndClassLoaderMap.get(platformLocation.getAbsolutePath());
        if (data == null) {
            ServerLocationManager.getNetBeansAndServerClassLoader(platformLocation);
            data = (CacheData)serverLocationAndClassLoaderMap.get(platformLocation.getAbsolutePath());
            if (data == null) {
                return null;
            }
        }
        return data.serverOnlyClassLoader;
    }

    public static synchronized DeploymentFactory getDeploymentFactory(File platformLocation) {
        CacheData data = (CacheData)serverLocationAndClassLoaderMap.get(platformLocation.getAbsolutePath());
        if (data == null) {
            ServerLocationManager.getNetBeansAndServerClassLoader(platformLocation);
            data = (CacheData)serverLocationAndClassLoaderMap.get(platformLocation.getAbsolutePath());
            if (data == null) {
                return null;
            }
        }
        return data.deploymentFactory;
    }

    public static synchronized ClassLoader getNetBeansAndServerClassLoader(File platformLocation) {
        CacheData data = (CacheData)serverLocationAndClassLoaderMap.get(platformLocation.getAbsolutePath());
        if (data == null) {
            if (!ServerLocationManager.isGoodAppServerLocation(platformLocation)) {
                return null;
            }
            data = new CacheData();
            serverLocationAndClassLoaderMap.put(platformLocation.getAbsolutePath(), data);
        }
        if (data.cachedClassLoader == null) {
            if (!ServerLocationManager.isGoodAppServerLocation(platformLocation)) {
                return null;
            }
            try {
                data.cachedClassLoader = new ExtendedClassLoader(new Empty().getClass().getClassLoader());
                ServerLocationManager.updatePluginLoader(platformLocation, data.cachedClassLoader);
                data.deploymentFactory = (DeploymentFactory)data.cachedClassLoader.loadClass("com.sun.enterprise.deployapi.SunDeploymentFactory").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                data.serverOnlyClassLoader = new ExtendedClassLoader();
                ServerLocationManager.updatePluginLoader(platformLocation, data.serverOnlyClassLoader);
            }
            catch (Exception ex2) {
                Logger.getLogger(ServerLocationManager.class.getName()).log(Level.FINER, null, ex2);
            }
        }
        return data.cachedClassLoader;
    }

    public static boolean isGlassFish(File candidate) {
        File as9 = new File(candidate.getAbsolutePath() + "/lib/dtds/sun-web-app_2_5-0.dtd");
        return as9.exists();
    }

    public static boolean isJavaDBPresent(File installdir) {
        File derbyInstall = new File(installdir, "derby");
        if (!derbyInstall.exists()) {
            derbyInstall = new File(installdir, "javadb");
        }
        return derbyInstall.exists();
    }

    public static boolean isGoodAppServerLocation(File candidate) {
        if (!(null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && ServerLocationManager.hasRequiredChildren(candidate, fileColl))) {
            return false;
        }
        File f = new File(candidate.getAbsolutePath() + "/lib/appserv-rt.jar");
        if (!f.exists()) {
            return false;
        }
        if (ServerLocationManager.isGlassFish(candidate)) {
            return true;
        }
        return true;
    }

    private static void loadLocaleSpecificJars(File file, ExtendedClassLoader loader) {
        File parentDir = file.getParentFile();
        File localeDir = new File(parentDir, "locale");
        if (localeDir.exists()) {
            File[] localeFiles = localeDir.listFiles();
            String fileName = file.getName();
            fileName = ServerLocationManager.getFileNameWithoutExt(fileName);
            assert (fileName.length() > 0);
            for (int i = 0; i < localeFiles.length; ++i) {
                File localeFile = localeFiles[i];
                String localeFileName = localeFile.getName();
                assert (localeFileName.length() > 0);
                if (!localeFileName.startsWith(fileName)) continue;
                try {
                    loader.addURL(localeFile);
                    continue;
                }
                catch (Exception ex2) {
                    System.out.println(ex2.getLocalizedMessage());
                }
            }
        }
    }

    private static String getFileNameWithoutExt(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    private static boolean hasRequiredChildren(File candidate, Collection requiredChildren) {
        if (null == candidate) {
            return false;
        }
        String[] children = candidate.list();
        if (null == children) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        List<String> kidsList = Arrays.asList(children);
        return kidsList.containsAll(requiredChildren);
    }

    public static int getAppServerPlatformVersion(File asInstallRoot) {
        int version = 0;
        if (asInstallRoot != null && asInstallRoot.exists()) {
            File sunDomain11Dtd = new File(asInstallRoot, "lib/dtds/sun-domain_1_1.dtd");
            File as90 = new File(asInstallRoot + "/lib/dtds/sun-domain_1_2.dtd");
            File as91 = new File(asInstallRoot + "/lib/dtds/sun-domain_1_3.dtd");
            File as911 = new File(asInstallRoot + "/lib/dtds/sun-ejb-jar_3_0-1.dtd");
            File as211 = new File(asInstallRoot + "/lib/install/applications/jmsra/imqstomp.jar");
            if (as211.exists()) {
                version = 912;
            } else if (as911.exists()) {
                version = 911;
            } else if (as91.exists()) {
                version = 910;
            } else if (as90.exists()) {
                version = 900;
            } else if (sunDomain11Dtd.exists()) {
                version = 820;
            }
        }
        return version;
    }

    public static boolean hasUpdateCenter(File asInstallRoot) {
        return ServerLocationManager.getUpdateCenterLauncher(asInstallRoot) != null;
    }

    public static File getUpdateCenterLauncher(File asInstallRoot) {
        File updateCenterBin;
        File result = null;
        if (asInstallRoot != null && asInstallRoot.exists() && (updateCenterBin = new File(asInstallRoot, "updatecenter/bin")).exists()) {
            File launcherPath;
            String launcher = "updatetool";
            if (Utilities.isWindows()) {
                launcher = launcher + ".BAT";
            }
            result = (launcherPath = new File(updateCenterBin, launcher)).exists() ? launcherPath : null;
        }
        return result;
    }

    static {
        fileColl.add("bin");
        fileColl.add("lib");
        fileColl.add("config");
    }

    static class CacheData {
        public ExtendedClassLoader cachedClassLoader;
        public ExtendedClassLoader serverOnlyClassLoader;
        public DeploymentFactory deploymentFactory;
    }

    static class Empty {
        Empty() {
        }
    }
}

