/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class FailedPatchResolver {
    private boolean failure;
    private static final String PREFIX_APPLYING = "applying ";
    private static final String PREFIX_PATCHING_FILE = "patching file ";
    private static final String SAVING_REJECTS = "saving rejects to file ";
    private static final String MISSING_FILE = "unable to find ";
    private static final Pattern MISSING_FILE_PATTERN = Pattern.compile("unable to find '(.*)' for patching");
    private String failedPatch;
    private Map<File, File> rejects;
    private final File root;
    private final OutputLogger logger;

    FailedPatchResolver(File root, List<String> output, OutputLogger logger) {
        this.root = root;
        this.logger = logger;
        this.initialize(output);
    }

    boolean isFailure() {
        return this.failure;
    }

    private void initialize(List<String> unfilteredOutput) {
        String patchedFile = null;
        for (String line : unfilteredOutput) {
            String normalizedLine = line.toLowerCase();
            if (normalizedLine.startsWith(PREFIX_APPLYING)) {
                patchedFile = null;
                this.failedPatch = line.substring(PREFIX_APPLYING.length());
                continue;
            }
            if (normalizedLine.startsWith(PREFIX_PATCHING_FILE)) {
                patchedFile = line.substring(PREFIX_PATCHING_FILE.length());
                continue;
            }
            if (normalizedLine.contains(MISSING_FILE)) {
                Matcher m = MISSING_FILE_PATTERN.matcher(line);
                if (!m.matches()) continue;
                patchedFile = m.group(1);
                continue;
            }
            if (!normalizedLine.contains(SAVING_REJECTS)) continue;
            this.failure = true;
            if (patchedFile == null) continue;
            this.addToRejects(patchedFile, line.substring(normalizedLine.indexOf(SAVING_REJECTS) + SAVING_REJECTS.length()));
        }
    }

    private void addToRejects(String patchedFilePath, String rejectedFilePath) {
        if (this.rejects == null) {
            this.rejects = new LinkedHashMap<File, File>(5);
        }
        this.rejects.put(new File(this.root, patchedFilePath.replace("/", File.separator)), new File(this.root, rejectedFilePath.replace("/", File.separator)));
    }

    void resolveFailure() {
        if (this.isFailure()) {
            HgUtils.openOutput(this.logger);
            if (JOptionPane.showConfirmDialog(Utilities.findDialogParent(), NbBundle.getMessage(FailedPatchResolver.class, (String)"MSG_FailedPatchResolver_patchApplyFailed", (Object)this.failedPatch), NbBundle.getMessage(FailedPatchResolver.class, (String)"LBL_FailedPatchResolver_patchApplyFailed"), 0, 2) == 0) {
                for (Map.Entry<File, File> e : this.rejects.entrySet()) {
                    Utils.openFile((File)e.getKey());
                    Utils.openFile((File)e.getValue());
                }
            }
        }
    }
}

