/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDatabaseSoftwareImageRequest
extends BmcRequest<Void> {
    private String databaseSoftwareImageId;
    private String ifMatch;

    public String getDatabaseSoftwareImageId() {
        return this.databaseSoftwareImageId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().databaseSoftwareImageId(this.databaseSoftwareImageId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseSoftwareImageId=").append(String.valueOf(this.databaseSoftwareImageId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDatabaseSoftwareImageRequest)) {
            return false;
        }
        DeleteDatabaseSoftwareImageRequest other = (DeleteDatabaseSoftwareImageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseSoftwareImageId, other.databaseSoftwareImageId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseSoftwareImageId == null ? 43 : this.databaseSoftwareImageId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDatabaseSoftwareImageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseSoftwareImageId = null;
        private String ifMatch = null;

        public Builder databaseSoftwareImageId(String databaseSoftwareImageId) {
            this.databaseSoftwareImageId = databaseSoftwareImageId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDatabaseSoftwareImageRequest o) {
            this.databaseSoftwareImageId(o.getDatabaseSoftwareImageId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDatabaseSoftwareImageRequest build() {
            DeleteDatabaseSoftwareImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDatabaseSoftwareImageRequest buildWithoutInvocationCallback() {
            DeleteDatabaseSoftwareImageRequest request = new DeleteDatabaseSoftwareImageRequest();
            request.databaseSoftwareImageId = this.databaseSoftwareImageId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

