/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.neon.completion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CompletionUtils {
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("([a-zA-Z0-9_\\\\]+)::[a-zA-Z0-9_]*");
    private static final Pattern METHOD_PREFIX_PATTERN = Pattern.compile("[a-zA-Z0-9_\\\\]+::([a-zA-Z0-9_]*)");

    private CompletionUtils() {
    }

    public static boolean startsWith(String theString, String prefix) {
        return prefix.length() == 0 ? true : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static String extractTypeName(String prefix) {
        String result = null;
        Matcher matcher = TYPE_NAME_PATTERN.matcher(prefix);
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        return result;
    }

    public static String extractMethodPrefix(String prefix) {
        String result = null;
        Matcher matcher = METHOD_PREFIX_PATTERN.matcher(prefix);
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        return result;
    }
}

