/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.JavaI18nFinder;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaPropertyPanel;
import org.netbeans.modules.i18n.java.JavaReplacePanel;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class JavaI18nSupport
extends I18nSupport {
    protected Set<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
    protected String identifier;
    protected boolean generateField;
    protected String initFormat = I18nUtil.getOptions().getInitJavaCode();
    private JavaReplacePanel additionalCustomizer;
    private static final String octalDigitChars = "01234567";
    private static final String hexaDigitChars = "0123456789abcdefABCDEF";

    public JavaI18nSupport(DataObject sourceDataObject) {
        super(sourceDataObject);
    }

    @Override
    protected I18nSupport.I18nFinder createFinder() {
        return new JavaI18nFinder(this.document);
    }

    @Override
    protected I18nSupport.I18nReplacer createReplacer() {
        return new JavaI18nReplacer();
    }

    @Override
    protected ResourceHolder createResourceHolder() {
        return new JavaResourceHolder();
    }

    @Override
    public I18nString getDefaultI18nString(HardCodedString hcString) {
        DataObject lastResource;
        JavaI18nString i18nString = new JavaI18nString(this);
        ResourceHolder resourceHolder = i18nString.getSupport().getResourceHolder();
        if (resourceHolder.getResource() == null && (lastResource = I18nUtil.getOptions().getLastResource2(this.sourceDataObject)) != null) {
            FileObject sourceFile = this.sourceDataObject.getPrimaryFile();
            FileObject bundleFile = lastResource.getPrimaryFile();
            ClassPath execClassPath = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/execute");
            if (execClassPath != null && execClassPath.getResourceName(bundleFile) != null) {
                resourceHolder.setResource(lastResource);
            }
        }
        if (hcString == null) {
            return i18nString;
        }
        String text = JavaI18nSupport.decodeUnicodeSeq(hcString.getText());
        String key = text.toUpperCase();
        String hcStr = hcString.getText();
        String strAndVar = ((JavaI18nFinder)this.getFinder()).strAndVarFound;
        int strAndVarLength = strAndVar.length();
        if (hcStr.contains(strAndVar)) {
            ArrayList<String> variables = new ArrayList<String>();
            int startVar = hcStr.indexOf(strAndVar);
            int endVar = -1;
            int counterVar = 0;
            text = hcStr.substring(0, startVar);
            while (startVar != -1) {
                if (counterVar > 0) {
                    text = text.concat(hcStr.substring(endVar + strAndVarLength, startVar));
                }
                if (startVar + strAndVarLength == (endVar = hcStr.indexOf(strAndVar, startVar + strAndVarLength))) {
                    --counterVar;
                } else {
                    text = text.concat("{").concat(Integer.toString(counterVar)).concat("}");
                    variables.add(hcStr.substring(startVar + strAndVarLength, endVar).trim());
                }
                startVar = hcStr.indexOf(strAndVar, endVar + strAndVarLength);
                ++counterVar;
                if (startVar != -1) continue;
                text = text.concat(hcStr.substring(endVar + strAndVarLength));
            }
            key = text.toUpperCase();
            i18nString.setKey(key);
            i18nString.setValue(text);
            i18nString.setComment("");
            i18nString.setReplaceFormat(I18nUtil.getReplaceFormatItems().get(4));
            String[] arguments = new String[variables.size()];
            for (int i = 0; i < variables.size(); ++i) {
                arguments[i] = (String)variables.get(i);
            }
            i18nString.setArguments(arguments);
        } else {
            i18nString.setKey(key);
            i18nString.setValue(text);
            i18nString.setComment("");
            if (this.isGenerateField() && i18nString.getReplaceFormat().indexOf("{identifier}") == -1) {
                i18nString.setReplaceFormat(I18nUtil.getReplaceFormatItems().get(0));
            }
        }
        return i18nString;
    }

    private static String decodeUnicodeSeq(String text) {
        StringBuilder result = new StringBuilder(text.length());
        char[] chars = text.toCharArray();
        boolean stateInitial = false;
        boolean stateBackSlash = true;
        int stateUnicode = 2;
        int stateOctalValue = 3;
        int state = 0;
        int unicodeValue = 0;
        char[] unicodeValueChars = new char[3];
        int valueBytesRead = 0;
        int charIndex = 0;
        block12: while (charIndex < chars.length) {
            char c = chars[charIndex++];
            switch (state) {
                case 0: {
                    if (c == '\\') {
                        state = 1;
                        continue block12;
                    }
                    result.append(c);
                    continue block12;
                }
                case 1: {
                    if (c == 'u') {
                        state = 2;
                        continue block12;
                    }
                    if (c >= '0' && c <= '3') {
                        unicodeValue = c - 48;
                        assert (unicodeValue >= 0 && unicodeValue <= 3);
                        valueBytesRead = 1;
                        state = 3;
                        continue block12;
                    }
                    result.append('\\').append(c);
                    state = 0;
                    continue block12;
                }
                case 3: {
                    int position = octalDigitChars.indexOf(c);
                    if (position >= 0) {
                        unicodeValue = unicodeValue << 3 | position;
                        ++valueBytesRead;
                    } else {
                        --charIndex;
                    }
                    if (position >= 0 && valueBytesRead != 3) continue block12;
                    JavaI18nSupport.appendChar(result, unicodeValue);
                    state = 0;
                    valueBytesRead = 0;
                    unicodeValue = 0;
                    continue block12;
                }
                case 2: {
                    int position = hexaDigitChars.indexOf(c);
                    if (position >= 0) {
                        if (position > 15) {
                            position -= 6;
                        }
                        assert (position <= 15);
                        unicodeValue = unicodeValue << 4 | position;
                        if (++valueBytesRead == 4) {
                            JavaI18nSupport.appendChar(result, unicodeValue);
                            state = 0;
                        } else {
                            unicodeValueChars[valueBytesRead - 1] = c;
                        }
                    } else if (c != 'u') {
                        result.append('\\');
                        result.append('u');
                        for (int i = 0; i < valueBytesRead; ++i) {
                            result.append(unicodeValueChars[i]);
                        }
                        result.append(c);
                        state = 0;
                    }
                    if (state == 2) continue block12;
                    valueBytesRead = 0;
                    unicodeValue = 0;
                    continue block12;
                }
            }
            assert (false);
            throw new IllegalStateException();
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                result.append('\\');
                break;
            }
            case 3: {
                assert (valueBytesRead >= 0 && valueBytesRead < 3);
                JavaI18nSupport.appendChar(result, unicodeValue);
                break;
            }
            case 2: {
                assert (valueBytesRead >= 0 && valueBytesRead < 4);
                result.append('\\').append('u');
                for (int i = 0; i < valueBytesRead; ++i) {
                    result.append(unicodeValueChars[i]);
                }
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        return result.toString();
    }

    private static final StringBuilder appendChar(StringBuilder buf, int unicodeValue) throws IllegalArgumentException {
        if (unicodeValue < 0 || unicodeValue > 65535) {
            throw new IllegalArgumentException("value out of range: " + unicodeValue);
        }
        if (unicodeValue >= 32 && unicodeValue != 127) {
            buf.append((char)unicodeValue);
        } else {
            buf.append('\\');
            switch (unicodeValue) {
                case 8: {
                    buf.append('b');
                    break;
                }
                case 9: {
                    buf.append('t');
                    break;
                }
                case 10: {
                    buf.append('n');
                    break;
                }
                case 12: {
                    buf.append('f');
                    break;
                }
                case 13: {
                    buf.append('r');
                    break;
                }
                default: {
                    buf.append('u');
                    for (int shift = 12; shift >= 0; shift -= 4) {
                        buf.append(hexaDigitChars.charAt(unicodeValue >> shift & 0xF));
                    }
                }
            }
        }
        return buf;
    }

    @Override
    public JPanel getInfo(HardCodedString hcString) {
        return new JavaInfoPanel(hcString, this.document);
    }

    public String getIdentifier() {
        if (this.identifier == null || this.identifier == "") {
            this.createIdentifier();
        }
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isGenerateField() {
        return this.generateField;
    }

    public void setGenerateField(boolean generateField) {
        this.generateField = generateField;
    }

    public String getInitFormat() {
        return this.initFormat;
    }

    public void setInitFormat(String initFormat) {
        this.initFormat = initFormat;
    }

    @Override
    public PropertyPanel getPropertyPanel() {
        return new JavaPropertyPanel();
    }

    @Override
    public boolean hasAdditionalCustomizer() {
        return true;
    }

    @Override
    public JPanel getAdditionalCustomizer() {
        if (this.additionalCustomizer == null) {
            this.additionalCustomizer = new JavaReplacePanel(this);
        }
        return this.additionalCustomizer;
    }

    @Override
    public void performAdditionalChanges() {
        this.createField();
    }

    public void createIdentifier() {
        String name;
        try {
            name = this.resourceHolder.getResource().getName();
        }
        catch (NullPointerException npe) {
            this.identifier = "";
            return;
        }
        name = name.length() > 0 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        this.identifier = name;
    }

    private void createField() {
        if (!this.isGenerateField()) {
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)this.document);
        try {
            ModificationResult result = javaSource.runModificationTask((Task)new AddFieldTask(this.getIdentifier()));
            result.commit();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
    }

    public String getInitString() {
        String initJavaFormat = this.getInitFormat();
        FileObject fo = this.resourceHolder.getResource().getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("bundleNameSlashes", cp.getResourceName(fo, '/', false));
        map.put("bundleNameDots", cp.getResourceName(fo, '.', false));
        map.put("sourceFileName", this.sourceDataObject != null ? this.sourceDataObject.getPrimaryFile().getName() : "");
        return MapFormat.format((String)initJavaFormat, map);
    }

    public static class JavaI18nReplacer
    implements I18nSupport.I18nReplacer {
        @Override
        public void replace(final HardCodedString hcString, I18nString i18nString) {
            if (i18nString.getKey() == null) {
                final StyledDocument document = i18nString.getSupport().getDocument();
                NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){
                    final /* synthetic */ JavaI18nReplacer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            int idx = hcString.getEndPosition().getOffset() + 1;
                            String text = document.getText(idx, document.getLength() - idx);
                            int i = idx;
                            while (idx - i < text.length() && text.charAt(idx - i) != '\n') {
                                ++idx;
                            }
                            document.insertString(idx, " //NOI18N", null);
                        }
                        catch (BadLocationException ble) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_CouldNotReplace"), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        }
                    }
                });
                return;
            }
            if (!(i18nString instanceof JavaI18nString)) {
                throw new IllegalArgumentException("I18N module: i18nString have to be an instance of JavaI18nString.");
            }
            final String newCode = i18nString.getReplaceString();
            final StyledDocument document = i18nString.getSupport().getDocument();
            NbDocument.runAtomic((StyledDocument)document, (Runnable)new Runnable(){
                final /* synthetic */ JavaI18nReplacer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        if (hcString.getLength() > 0) {
                            document.remove(hcString.getStartPosition().getOffset(), hcString.getLength());
                        }
                        if (newCode != null && newCode.length() > 0) {
                            document.insertString(hcString.getEndPosition().getOffset(), newCode, null);
                        }
                    }
                    catch (BadLocationException ble) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_CouldNotReplace"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
        }
    }

    private static class JavaInfoPanel
    extends InfoPanel {
        public JavaInfoPanel(HardCodedString hcString, StyledDocument document) {
            super(hcString, document);
        }

        @Override
        protected void setHardCodedString(HardCodedString hcString, StyledDocument document) {
            String hardLine;
            this.getStringText().setText(hcString == null ? "" : hcString.getText());
            if (hcString.getStartPosition() == null) {
                hardLine = "";
            } else {
                int pos = hcString.getStartPosition().getOffset();
                try {
                    Element paragraph = document.getParagraphElement(pos);
                    hardLine = document.getText(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset()).trim();
                }
                catch (BadLocationException ble) {
                    hardLine = "";
                }
            }
            this.getFoundInText().setText(hardLine);
            this.remove(this.getComponentLabel());
            this.remove(this.getComponentText());
            this.remove(this.getPropertyLabel());
            this.remove(this.getPropertyText());
        }
    }

    private final class AddFieldTask
    implements Task<WorkingCopy> {
        private final String fieldName;

        AddFieldTask(String fieldName) {
            this.fieldName = fieldName;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            TypeElement sourceClassElem = this.getClass(workingCopy);
            if (sourceClassElem == null) {
                return;
            }
            List<? extends javax.lang.model.element.Element> classMembers = sourceClassElem.getEnclosedElements();
            List<VariableElement> fields = ElementFilter.fieldsIn(classMembers);
            if (this.containsField(fields, this.fieldName)) {
                return;
            }
            int targetPosition = this.findTargetPosition(classMembers, fields);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            Elements elements = workingCopy.getElements();
            Trees trees = workingCopy.getTrees();
            TreeUtilities treeUtilities = workingCopy.getTreeUtilities();
            TypeElement resourceBundleTypeElem = elements.getTypeElement("java.util.ResourceBundle");
            assert (resourceBundleTypeElem != null);
            ExpressionTree fieldDefaultValue = treeUtilities.parseVariableInitializer(JavaI18nSupport.this.getInitString(), new SourcePositions[1]);
            TreePath classTreePath = trees.getPath(sourceClassElem);
            Scope classScope = trees.getScope(classTreePath);
            if (classScope != null) {
                treeUtilities.attributeTree((Tree)fieldDefaultValue, classScope);
            }
            VariableTree field = treeMaker.Variable(treeMaker.Modifiers(JavaI18nSupport.this.modifiers), (CharSequence)this.fieldName, (Tree)treeMaker.QualIdent((javax.lang.model.element.Element)resourceBundleTypeElem), (ExpressionTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)fieldDefaultValue));
            ClassTree oldClassTree = (ClassTree)classTreePath.getLeaf();
            ClassTree newClassTree = targetPosition != -1 ? treeMaker.insertClassMember(oldClassTree, targetPosition, (Tree)field) : treeMaker.addClassMember(oldClassTree, (Tree)field);
            workingCopy.rewrite((Tree)oldClassTree, (Tree)newClassTree);
        }

        private int findTargetPosition(List<? extends javax.lang.model.element.Element> classMembers, List<? extends VariableElement> fields) {
            if (fields.isEmpty()) {
                return 0;
            }
            int target = 0;
            boolean skippingStaticFields = false;
            Iterator<? extends javax.lang.model.element.Element> membersIt = classMembers.iterator();
            int index = 0;
            while (membersIt.hasNext()) {
                javax.lang.model.element.Element member = membersIt.next();
                ElementKind kind = member.getKind();
                if (kind.isField() && kind != ElementKind.ENUM_CONSTANT && member.getModifiers().contains((Object)Modifier.STATIC)) {
                    skippingStaticFields = true;
                } else if (skippingStaticFields) {
                    skippingStaticFields = false;
                    target = index;
                }
                ++index;
            }
            return !skippingStaticFields ? target : -1;
        }

        private TypeElement getClass(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            String preferredName = JavaI18nSupport.this.sourceDataObject.getName();
            TypeElement firstPublicNestedClass = null;
            List topClasses = workingCopy.getTopLevelElements();
            for (TypeElement topElement : topClasses) {
                ElementKind elementKind = topElement.getKind();
                if (!elementKind.isClass()) continue;
                if (topElement.getSimpleName().contentEquals(preferredName)) {
                    return topElement;
                }
                if (firstPublicNestedClass != null || !topElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                firstPublicNestedClass = topElement;
            }
            return firstPublicNestedClass;
        }

        private boolean containsField(List<? extends VariableElement> fields, String fieldName) {
            if (!fields.isEmpty()) {
                for (VariableElement variableElement : fields) {
                    if (!variableElement.getSimpleName().contentEquals(fieldName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class Factory
    extends I18nSupport.Factory {
        @Override
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JavaI18nSupport(dataObject);
        }

        @Override
        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.java.JavaDataObject", false, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
    }
}

