/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.model.api.AtRule;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.BodyItem;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.FontFace;
import org.netbeans.modules.css.model.api.GenericAtRule;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.MozDocument;
import org.netbeans.modules.css.model.api.Page;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.VendorAtRule;
import org.netbeans.modules.css.model.api.WebkitKeyframes;
import org.netbeans.modules.css.model.impl.ModelElement;
import org.netbeans.modules.css.model.impl.ModelElementListener;

public class BodyI
extends ModelElement
implements Body {
    private final List<BodyItem> bodyItems = new ArrayList<BodyItem>();
    private final ModelElementListener elementListener = new ModelElementListener.Adapter(){

        @Override
        public void elementAdded(BodyItem bodyItem) {
            BodyI.this.bodyItems.add(bodyItem);
        }

        @Override
        public void elementRemoved(BodyItem bodyItem) {
            BodyI.this.bodyItems.remove(bodyItem);
        }
    };

    public BodyI(Model model) {
        super(model);
    }

    public BodyI(Model model, Node node) {
        super(model, node);
        this.initChildrenElements();
    }

    @Override
    public List<BodyItem> getBodyItems() {
        return Collections.unmodifiableList(this.bodyItems);
    }

    @Override
    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (BodyItem bi : this.getBodyItems()) {
            if (!(bi.getElement() instanceof Rule)) continue;
            rules.add((Rule)bi.getElement());
        }
        return Collections.unmodifiableList(rules);
    }

    @Override
    public void addRule(Rule rule) {
        BodyItem bi = this.model.getElementFactory().createBodyItem();
        bi.setElement(rule);
        this.addElement(bi);
    }

    @Override
    public boolean removeRule(Rule rule) {
        return this.removeBodyItemChild(rule);
    }

    private List<AtRule> getAtRules() {
        ArrayList<AtRule> atRules = new ArrayList<AtRule>();
        for (Element element : this.getBodyItems()) {
            Element biElement;
            if (!(element instanceof BodyItem) || !((biElement = ((BodyItem)element).getElement()) instanceof AtRule)) continue;
            AtRule atr = (AtRule)biElement;
            atRules.add(atr);
        }
        return atRules;
    }

    @Override
    public List<Media> getMedias() {
        ArrayList<Media> rules = new ArrayList<Media>();
        for (AtRule bi : this.getAtRules()) {
            if (!(bi.getElement() instanceof Media)) continue;
            rules.add((Media)bi.getElement());
        }
        return Collections.unmodifiableList(rules);
    }

    @Override
    public void addMedia(Media media) {
        BodyItem bi = this.model.getElementFactory().createBodyItem();
        AtRule atr = this.model.getElementFactory().createAtRule();
        atr.setElement(media);
        bi.setElement(atr);
        this.addElement(bi);
    }

    @Override
    public boolean removeMedia(Media media) {
        return this.removeBodyItemChild(media);
    }

    @Override
    public List<Page> getPages() {
        ArrayList<Page> rules = new ArrayList<Page>();
        for (AtRule bi : this.getAtRules()) {
            if (!(bi.getElement() instanceof Page)) continue;
            rules.add((Page)bi.getElement());
        }
        return Collections.unmodifiableList(rules);
    }

    @Override
    public void addPage(Page page) {
        BodyItem bi = this.model.getElementFactory().createBodyItem();
        AtRule atr = this.model.getElementFactory().createAtRule();
        atr.setElement(page);
        bi.setElement(atr);
        this.addElement(bi);
    }

    @Override
    public boolean removePage(Page page) {
        return this.removeBodyItemChild(page);
    }

    @Override
    public List<FontFace> getFontFaces() {
        ArrayList<FontFace> rules = new ArrayList<FontFace>();
        for (AtRule bi : this.getAtRules()) {
            if (!(bi.getElement() instanceof FontFace)) continue;
            rules.add((FontFace)bi.getElement());
        }
        return Collections.unmodifiableList(rules);
    }

    @Override
    public void addFontFace(FontFace fontFace) {
        BodyItem bi = this.model.getElementFactory().createBodyItem();
        AtRule atr = this.model.getElementFactory().createAtRule();
        atr.setElement(fontFace);
        bi.setElement(atr);
        this.addElement(bi);
    }

    @Override
    public boolean removeFontFace(FontFace fontFace) {
        return this.removeBodyItemChild(fontFace);
    }

    private boolean removeBodyItemChild(Element element) {
        Element atRule = element.getParent();
        assert (atRule != null);
        Element bodyItem = atRule.getParent();
        assert (bodyItem != null);
        boolean removed = atRule.removeElement(element);
        assert (removed);
        removed = bodyItem.removeElement(atRule);
        assert (removed);
        return this.removeElement(bodyItem);
    }

    @Override
    protected ModelElementListener getElementListener() {
        return this.elementListener;
    }

    @Override
    protected Class getModelClass() {
        return Body.class;
    }

    private List<VendorAtRule> getVendorAtRules() {
        ArrayList<VendorAtRule> rules = new ArrayList<VendorAtRule>();
        for (AtRule bi : this.getAtRules()) {
            if (!(bi.getElement() instanceof VendorAtRule)) continue;
            rules.add((VendorAtRule)bi.getElement());
        }
        return Collections.unmodifiableList(rules);
    }

    private <T extends Element> List<T> getVendorAtRuleElements(Class<T> ofType) {
        ArrayList<Element> rules = new ArrayList<Element>();
        for (VendorAtRule var : this.getVendorAtRules()) {
            Element element = var.getElement();
            if (!ofType.isAssignableFrom(element.getClass())) continue;
            Element t = (Element)ofType.cast(element);
            rules.add(t);
        }
        return Collections.unmodifiableList(rules);
    }

    private void addVendorAtRuleMember(Element element) {
        VendorAtRule vendorAtRule = this.model.getElementFactory().createVendorAtRule();
        vendorAtRule.setElement(element);
        AtRule atr = this.model.getElementFactory().createAtRule();
        atr.setElement(vendorAtRule);
        BodyItem bi = this.model.getElementFactory().createBodyItem();
        bi.setElement(atr);
        this.addElement(bi);
    }

    @Override
    public List<GenericAtRule> getGenericAtRules() {
        return this.getVendorAtRuleElements(GenericAtRule.class);
    }

    @Override
    public void addGenericAtRule(GenericAtRule genericAtRule) {
        this.addVendorAtRuleMember(genericAtRule);
    }

    private boolean removeVendorAtRuleChild(Element element) {
        Element vendorAtRule = element.getParent();
        assert (vendorAtRule != null);
        assert (vendorAtRule instanceof VendorAtRule);
        return this.removeBodyItemChild(vendorAtRule);
    }

    @Override
    public boolean removeGenericAtRule(GenericAtRule genericAtRule) {
        return this.removeVendorAtRuleChild(genericAtRule);
    }

    @Override
    public List<MozDocument> getMozDocuments() {
        return this.getVendorAtRuleElements(MozDocument.class);
    }

    @Override
    public void addMozDocument(MozDocument mozDocument) {
        this.addVendorAtRuleMember(mozDocument);
    }

    @Override
    public boolean removeMozDocument(MozDocument mozDocument) {
        return this.removeVendorAtRuleChild(mozDocument);
    }

    @Override
    public List<WebkitKeyframes> getWebkitKeyFrames() {
        return this.getVendorAtRuleElements(WebkitKeyframes.class);
    }

    @Override
    public void addWebkitKeyFrames(WebkitKeyframes webkitKeyFrames) {
        this.addVendorAtRuleMember(webkitKeyFrames);
    }

    @Override
    public boolean removeWebkitKeyFrames(WebkitKeyframes webkitKeyFrames) {
        return this.removeVendorAtRuleChild(webkitKeyFrames);
    }
}

