/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.awt.Image;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.IssuePrioritySupport;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.spi.IssuePriorityProvider;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.IssueScheduleProvider;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public final class BugtrackingSupport<R, Q, I> {
    private final RepositoryProvider<R, Q, I> repositoryProvider;
    private final QueryProvider<Q, I> queryProvider;
    private final IssueProvider<I> issueProvider;

    public BugtrackingSupport(RepositoryProvider<R, Q, I> repositoryProvider, QueryProvider<Q, I> queryProvider, IssueProvider<I> issueProvider) {
        this.repositoryProvider = repositoryProvider;
        this.queryProvider = queryProvider;
        this.issueProvider = issueProvider;
    }

    public Repository createRepository(R r, IssueStatusProvider<R, I> issueStatusProvider, IssueScheduleProvider<I> issueSchedulingProvider, IssuePriorityProvider<I> issuePriorityProvider, IssueFinder issueFinder) {
        Repository repo;
        RepositoryRegistry registry = RepositoryRegistry.getInstance();
        Repository repository = repo = registry.isInitializing() ? null : this.getRepository(r);
        if (repo != null) {
            return repo;
        }
        RepositoryImpl<R, Q, I> impl = new RepositoryImpl<R, Q, I>(r, this.repositoryProvider, this.queryProvider, this.issueProvider, issueStatusProvider, issueSchedulingProvider, issuePriorityProvider, issueFinder);
        RepositoryInfo info = impl.getInfo();
        if (info != null && !registry.isInitializing() && this.getRepositoryImpl(r, false) == null) {
            registry.addRepository(impl);
        }
        return impl.getRepository();
    }

    public void editQuery(R r, Q q) {
        QueryImpl query = this.getQueryImpl(r, q);
        if (query != null) {
            query.open(QueryController.QueryMode.EDIT);
        }
    }

    public void openIssue(R r, I i) {
        IssueImpl issue = this.getIssueImpl(r, i);
        if (issue != null) {
            issue.open();
        }
    }

    public void addToCategory(final R r, final I i) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ BugtrackingSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                IssueImpl issue = this.this$0.getIssueImpl(r, i);
                if (issue != null) {
                    DashboardTopComponent.findInstance().addTask(issue);
                }
            }
        });
    }

    public void setQueryAutoRefresh(R r, Q q, boolean autoRefresh) {
        QueryImpl queryImpl = this.getQueryImpl(r, q);
        DashboardUtils.setQueryAutoRefresh(queryImpl, autoRefresh);
    }

    public boolean editRepository(R r, String errorMessage) {
        RepositoryImpl impl = this.getRepositoryImpl(r, false);
        return impl != null ? BugtrackingUtil.editRepository(impl, errorMessage) : false;
    }

    public Image[] getPriorityIcons() {
        return IssuePrioritySupport.getIcons();
    }

    private QueryImpl getQueryImpl(R r, Q q) {
        RepositoryImpl impl = this.getRepositoryImpl(r, true);
        return impl != null ? impl.getQuery(q) : null;
    }

    private IssueImpl getIssueImpl(R r, I i) {
        RepositoryImpl impl = this.getRepositoryImpl(r, true);
        return impl != null ? impl.getIssue(i) : null;
    }

    private Repository getRepository(String connectorId, String repositoryId) {
        RepositoryImpl impl = this.getRepositoryImpl(connectorId, repositoryId, false);
        return impl != null ? impl.getRepository() : null;
    }

    private RepositoryImpl getRepositoryImpl(R r, boolean allKnown) {
        RepositoryInfo info = this.repositoryProvider.getInfo(r);
        return info != null ? this.getRepositoryImpl(info.getConnectorId(), info.getID(), allKnown) : null;
    }

    private RepositoryImpl getRepositoryImpl(String connectorId, String repositoryId, boolean allKnown) {
        RepositoryRegistry registry = RepositoryRegistry.getInstance();
        return !registry.isInitializing() ? registry.getRepository(connectorId, repositoryId, allKnown) : null;
    }

    private Repository getRepository(R r) {
        RepositoryInfo info = this.repositoryProvider.getInfo(r);
        if (info != null) {
            String repositoryId = info.getID();
            String connectorId = this.repositoryProvider.getInfo(r).getConnectorId();
            Repository repo = this.getRepository(connectorId, repositoryId);
            return repo;
        }
        return null;
    }
}

