/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.text.Line;
import org.openide.util.Lookup;

public class FindUsagesPainter {
    public static String colorASTNode(ASTNode node, Line line) {
        ASTNode originalNode;
        int columnStart = node.getColumnNumber();
        int columnEnd = node.getLastColumnNumber();
        if (node instanceof ClassNode) {
            return FindUsagesPainter.colorLine(line, ((ClassNode)node).getNameWithoutPackage());
        }
        if (node instanceof ConstructorNode) {
            return FindUsagesPainter.colorLine(line, ((ConstructorNode)node).getDeclaringClass().getNameWithoutPackage());
        }
        if (node instanceof ConstructorCallExpression) {
            return FindUsagesPainter.colorLine(line, ((ConstructorCallExpression)node).getType().getNameWithoutPackage());
        }
        if (node instanceof MethodNode) {
            return FindUsagesPainter.colorLine(line, ((MethodNode)node).getName());
        }
        if (node instanceof FieldNode) {
            return FindUsagesPainter.colorLine(line, ((FieldNode)node).getName());
        }
        if (node instanceof ASTUtils.FakeASTNode && (originalNode = ((ASTUtils.FakeASTNode)node).getOriginalNode()) instanceof ImportNode) {
            return FindUsagesPainter.colorLine(line, ((ImportNode)originalNode).getAlias());
        }
        String beforePart = line.createPart(0, columnStart - 1).getText();
        String usagePart = line.createPart(columnStart - 1, columnEnd - columnStart).getText();
        String afterPart = line.createPart(columnEnd - 1, line.getText().length()).getText();
        return FindUsagesPainter.buildHTML(beforePart, usagePart, afterPart);
    }

    private static String colorLine(Line line, String name) {
        int start = line.getText().lastIndexOf(name);
        String beforePart = line.createPart(0, start).getText();
        String usagePart = line.createPart(start, name.length()).getText();
        String afterPart = line.createPart(start + name.length(), line.getText().length()).getText();
        return FindUsagesPainter.buildHTML(beforePart, usagePart, afterPart);
    }

    private static String buildHTML(String beforePart, String usagePart, String afterPart) {
        StringBuilder sb = new StringBuilder();
        sb.append(FindUsagesPainter.getHtml(FindUsagesPainter.trimStart(beforePart)));
        sb.append("<b>");
        sb.append(usagePart);
        sb.append("</b>");
        sb.append(FindUsagesPainter.getHtml(FindUsagesPainter.trimEnd(afterPart)));
        return sb.toString().trim();
    }

    private static String trimStart(String s) {
        for (int x = 0; x < s.length(); ++x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(x);
        }
        return "";
    }

    private static String trimEnd(String s) {
        for (int x = s.length() - 1; x >= 0; --x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(0, x + 1);
        }
        return "";
    }

    private static String getHtml(String text) {
        StringBuilder buf = new StringBuilder();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)GroovyTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-groovy"));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = ((GroovyTokenId)token.id()).primaryCategory();
            if (category == null) {
                category = "whitespace";
            }
            AttributeSet set = settings.getTokenFontColors(category);
            buf.append(FindUsagesPainter.color(FindUsagesPainter.htmlize(token.text().toString()), set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuffer buf = new StringBuffer(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + FindUsagesPainter.getHTMLColor(LFCustoms.getForeground((AttributeSet)set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    private static String htmlize(String input) {
        String temp = input.replace("<", "&lt;");
        temp = temp.replace(">", "&gt;");
        return temp;
    }
}

