/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing;

import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.SigningStrategy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RequestSigningFilter
extends AuthnClientFilter {
    public RequestSigningFilter(@Nonnull RequestSigner requestSigner, @Nonnull Map<SigningStrategy, RequestSigner> requestSigners) {
        super(requestSigner, requestSigners);
        if (requestSigner == null) {
            throw new NullPointerException("requestSigner is marked non-null but is null");
        }
        if (requestSigners == null) {
            throw new NullPointerException("requestSigners is marked non-null but is null");
        }
    }

    public RequestSigningFilter(@Nonnull RequestSigner requestSigner) {
        this(requestSigner, Collections.unmodifiableMap(new HashMap()));
    }

    public static RequestSigningFilter fromAuthProvider(@Nonnull BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        return new RequestSigningFilter(DefaultRequestSigner.createRequestSigner(authenticationDetailsProvider));
    }

    public static RequestSigningFilter fromConfigFile(@Nonnull String configurationFilePath, @Nullable String profile) throws IOException {
        if (configurationFilePath == null) {
            throw new NullPointerException("configurationFilePath is marked non-null but is null");
        }
        return RequestSigningFilter.fromAuthProvider(new ConfigFileAuthenticationDetailsProvider(configurationFilePath, profile));
    }

    @Override
    public void intercept(HttpRequest request) {
        super.intercept(request);
        request.header("User-Agent", ClientRuntime.getRuntime().getUserAgent() + " RequestSigningFilter");
    }
}

