/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class JsxElementNode
extends Expression {
    private final String name;
    private final List<Expression> attributes;
    private final List<Expression> children;

    public JsxElementNode(String name, List<Expression> attributes, List<Expression> children, long token, int finish) {
        super(token, finish);
        this.name = name;
        this.attributes = attributes;
        this.children = children;
    }

    private JsxElementNode(JsxElementNode node, String name, List<Expression> attributes, List<Expression> children) {
        super(node);
        this.name = name;
        this.attributes = attributes;
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public List<Expression> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public JsxElementNode setAttributes(List<Expression> attributes) {
        if (this.attributes == attributes) {
            return this;
        }
        return new JsxElementNode(this, this.name, attributes, this.children);
    }

    public List<Expression> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public JsxElementNode setChildren(List<Expression> children) {
        if (this.children == children) {
            return this;
        }
        return new JsxElementNode(this, this.name, this.attributes, children);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterJsxElementNode(this)) {
            return visitor.leaveJsxElementNode(this.setAttributes(Node.accept(visitor, this.attributes)).setChildren(Node.accept(visitor, this.children)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterJsxElementNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append('<').append(this.name);
        for (Expression attr : this.attributes) {
            sb.append(' ');
            attr.toString(sb, printType);
        }
        if (this.children.isEmpty()) {
            sb.append("/>");
        } else {
            sb.append('>');
            for (Expression child : this.children) {
                child.toString(sb, printType);
            }
            sb.append("</").append(this.name).append('>');
        }
    }
}

