/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.awt.Color;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.refactoring.api.CssRefactoring;
import org.netbeans.modules.css.refactoring.api.EntryHandle;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.editor.HtmlExtensions;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.modules.web.common.api.WebPageMetadata;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HtmlDeclarationFinder
implements DeclarationFinder {
    private static final Logger LOG = Logger.getLogger(HtmlDeclarationFinder.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(HtmlDeclarationFinder.class);
    private static final Map<Document, String> DOC_TO_WEB_MIMETYPE_CACHE = new WeakHashMap<Document, String>();
    private static final Map<Document, Reference<RequestProcessor.Task>> DOC_TO_UPDATE_TASK_MAP = new WeakHashMap<Document, Reference<RequestProcessor.Task>>();
    private static final CssSelectorElementHandle CSS_SELECTOR_ELEMENT_HANDLE_SINGLETON = new CssSelectorElementHandle();

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        HtmlParserResult result = (HtmlParserResult)info;
        DeclarationFinder.DeclarationLocation loc = this.findCoreHtmlDeclaration(info, caretOffset);
        if (loc != null) {
            return loc;
        }
        String sourceMimetype = WebPageMetadata.getContentMimeType((Parser.Result)result, (boolean)true);
        for (HtmlExtension htmlExtension : HtmlExtensions.getRegisteredExtensions(sourceMimetype)) {
            loc = htmlExtension.findDeclaration(info, caretOffset);
            if (loc == null) continue;
            return loc;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        final AtomicReference<OffsetRange> result_ref = new AtomicReference<OffsetRange>(OffsetRange.NONE);
        doc.render(new Runnable(){
            final /* synthetic */ HtmlDeclarationFinder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String mimeType;
                RequestProcessor.Task task;
                OffsetRange range = this.this$0.getCoreHtmlReferenceSpan(doc, caretOffset);
                if (range != null) {
                    result_ref.set(range);
                    return;
                }
                Reference taskReference = (Reference)DOC_TO_UPDATE_TASK_MAP.get(doc);
                RequestProcessor.Task task2 = task = taskReference == null ? null : (RequestProcessor.Task)taskReference.get();
                if (task == null) {
                    task = RP.create((Runnable)new DocumentMimeTypeCacheUpdateTask(doc));
                    DOC_TO_UPDATE_TASK_MAP.put(doc, new WeakReference<RequestProcessor.Task>(task));
                }
                if ((mimeType = (String)DOC_TO_WEB_MIMETYPE_CACHE.get(doc)) == null) {
                    task.schedule(0);
                    mimeType = NbEditorUtilities.getMimeType((Document)doc);
                } else {
                    task.schedule(5000);
                }
                for (HtmlExtension htmlExtension : HtmlExtensions.getRegisteredExtensions(mimeType)) {
                    range = htmlExtension.getReferenceSpan(doc, caretOffset);
                    if (range == null || range == OffsetRange.NONE) continue;
                    result_ref.set(range);
                    return;
                }
            }
        });
        return result_ref.get();
    }

    private OffsetRange getCoreHtmlReferenceSpan(Document doc, int caretOffset) {
        OffsetRange offsetRange;
        Object cssTokenType;
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(hi, caretOffset);
        if (ts == null) {
            return null;
        }
        if (ts.token().id() == HTMLTokenId.VALUE) {
            return (OffsetRange)new AttributeValueAction<OffsetRange>(hi, ts){

                @Override
                public OffsetRange resolve() {
                    ValueCompletion<HtmlCompletionItem> support;
                    if (this.tagName != null && this.attrName != null && AttrValuesCompletion.FILE_NAME_SUPPORT == (support = AttrValuesCompletion.getSupport(this.tagName, this.attrName))) {
                        return this.valueRange;
                    }
                    return null;
                }
            }.run();
        }
        if (ts.token().id() == HTMLTokenId.VALUE_CSS && (cssTokenType = ts.token().getProperty((Object)"valueCssType")) != null && (offsetRange = this.getPointedRange(ts, hi, caretOffset)) != null) {
            return offsetRange;
        }
        return null;
    }

    private OffsetRange getPointedRange(TokenSequence<HTMLTokenId> ts, TokenHierarchy hi, int caretOffset) {
        OffsetRange offsetRange = null;
        List<Token> parts = ts.token().joinedParts();
        if (parts == null) {
            parts = Collections.singletonList(ts.token());
        }
        for (Token partToken : parts) {
            int tokenOffset = partToken.offset(hi);
            int tokenLength = partToken.length();
            int offsetIntoToken = caretOffset - tokenOffset;
            if (offsetIntoToken <= 0 || offsetIntoToken >= tokenLength) continue;
            CharSequence tokenText = partToken.text();
            int startToken = offsetIntoToken;
            int endToken = offsetIntoToken;
            char currentChar = tokenText.charAt(offsetIntoToken);
            if (currentChar == '\"' || currentChar == '\'' || Character.isWhitespace(currentChar)) continue;
            while ((currentChar = tokenText.charAt(startToken - 1)) != '\"' && currentChar != '\'' && !Character.isWhitespace(currentChar) && --startToken > 0) {
            }
            while ((currentChar = tokenText.charAt(endToken + 1)) != '\"' && currentChar != '\'' && !Character.isWhitespace(currentChar) && ++endToken < tokenLength) {
            }
            offsetRange = new OffsetRange(tokenOffset + startToken, tokenOffset + endToken + 1);
        }
        return offsetRange;
    }

    private DeclarationFinder.DeclarationLocation findCoreHtmlDeclaration(final ParserResult info, final int caretOffset) {
        FileObject file = info.getSnapshot().getSource().getFileObject();
        final TokenHierarchy hi = info.getSnapshot().getTokenHierarchy();
        TokenSequence ts = hi.tokenSequence(HTMLTokenId.language());
        if (ts == null) {
            return null;
        }
        int astCaretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (astCaretOffset == -1) {
            return null;
        }
        ts.move(astCaretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.token().id() == HTMLTokenId.VALUE) {
            return (DeclarationFinder.DeclarationLocation)new AttributeValueAction<DeclarationFinder.DeclarationLocation>(this, hi, ts){
                final /* synthetic */ HtmlDeclarationFinder this$0;
                {
                    this.this$0 = this$0;
                    super(hi, (TokenSequence<HTMLTokenId>)ts);
                }

                @Override
                public DeclarationFinder.DeclarationLocation resolve() {
                    FileObject resolved;
                    ValueCompletion<HtmlCompletionItem> support;
                    if (this.tagName != null && this.attrName != null && AttrValuesCompletion.FILE_NAME_SUPPORT == (support = AttrValuesCompletion.getSupport(this.tagName, this.attrName)) && (resolved = WebUtils.resolve((FileObject)info.getSnapshot().getSource().getFileObject(), (String)this.unquotedValue)) != null) {
                        return new DeclarationFinder.DeclarationLocation(resolved, 0);
                    }
                    return null;
                }
            }.run();
        }
        if (ts.token().id() == HTMLTokenId.VALUE_CSS) {
            final Document doc = info.getSnapshot().getSource().getDocument(true);
            final AtomicReference type = new AtomicReference();
            final AtomicReference unquotedValue = new AtomicReference();
            doc.render(new Runnable(){
                final /* synthetic */ HtmlDeclarationFinder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    Token valueToken;
                    TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, caretOffset);
                    if (ts != null && ts.token() != null && (valueToken = ts.token()).id() == HTMLTokenId.VALUE_CSS) {
                        try {
                            String cssTokenType = (String)valueToken.getProperty((Object)"valueCssType");
                            if (cssTokenType == null) {
                                return;
                            }
                            OffsetRange offsetRange = this.this$0.getPointedRange((TokenSequence<HTMLTokenId>)ts, hi, caretOffset);
                            unquotedValue.set(doc.getText(offsetRange.getStart(), offsetRange.getLength()));
                            switch (cssTokenType) {
                                case "class": {
                                    type.set(RefactoringElementType.CLASS);
                                    break;
                                }
                                case "id": {
                                    type.set(RefactoringElementType.ID);
                                    break;
                                }
                                default: {
                                    assert (false);
                                    break;
                                }
                            }
                        }
                        catch (BadLocationException ex) {
                            LOG.log(Level.WARNING, "Failed to get text for declaration", ex);
                        }
                    }
                }
            });
            if (unquotedValue.get() == null || type.get() == null) {
                return null;
            }
            Map occurances = CssRefactoring.findAllOccurances((String)((String)unquotedValue.get()), (RefactoringElementType)((RefactoringElementType)type.get()), (FileObject)file, (boolean)true);
            if (occurances == null) {
                return null;
            }
            DeclarationFinder.DeclarationLocation dl = null;
            for (Map.Entry entry : occurances.entrySet()) {
                FileObject f = (FileObject)entry.getKey();
                Collection entries = (Collection)entry.getValue();
                for (EntryHandle entryHandle : entries) {
                    DeclarationFinder.DeclarationLocation dloc = new DeclarationFinder.DeclarationLocation(f, entryHandle.entry().getDocumentRange().getStart());
                    if (dl == null) {
                        dl = dloc;
                    }
                    AlternativeLocationImpl aloc = new AlternativeLocationImpl(dloc, entryHandle, (RefactoringElementType)type.get());
                    dl.addAlternative((DeclarationFinder.AlternativeLocation)aloc);
                }
            }
            if (dl != null && dl.getAlternativeLocations().size() == 1) {
                dl.getAlternativeLocations().clear();
            }
            return dl;
        }
        return null;
    }

    private static class CssSelectorElementHandle
    implements ElementHandle {
        private CssSelectorElementHandle() {
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final DeclarationFinder.DeclarationLocation location;
        private final EntryHandle entryHandle;
        private final RefactoringElementType type;
        private static final int SELECTOR_TEXT_MAX_LENGTH = 50;
        private static final Color SELECTOR_COLOR = new Color(0, 124, 0);

        public AlternativeLocationImpl(DeclarationFinder.DeclarationLocation location, EntryHandle entry, RefactoringElementType type) {
            this.location = location;
            this.entryHandle = entry;
            this.type = type;
        }

        public ElementHandle getElement() {
            return CSS_SELECTOR_ELEMENT_HANDLE_SINGLETON;
        }

        private static String hexColorCode(Color c) {
            Color tweakedToLookAndFeel = LFCustoms.shiftColor((Color)c);
            return Integer.toHexString(tweakedToLookAndFeel.getRGB()).substring(2);
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            String elementTextPrefix;
            StringBuilder b = new StringBuilder();
            String lineText = this.entryHandle.entry().getLineText().toString();
            assert (lineText != null);
            switch (this.type) {
                case CLASS: {
                    elementTextPrefix = ".";
                    break;
                }
                case ID: {
                    elementTextPrefix = "#";
                    break;
                }
                default: {
                    elementTextPrefix = "";
                }
            }
            String elementText = elementTextPrefix + this.entryHandle.entry().getName();
            String prefix = "";
            String postfix = "";
            int elementIndex = lineText.indexOf(elementText);
            if (elementIndex >= 0) {
                char ch;
                int from;
                char c;
                int to;
                for (to = elementIndex; to < lineText.length() && (c = lineText.charAt(to)) != '{' && c != '\n'; ++to) {
                }
                for (from = elementIndex; from >= 0 && (ch = lineText.charAt(from)) != '}' && ch != '\n'; --from) {
                }
                prefix = lineText.substring(from + 1, elementIndex).trim();
                postfix = lineText.substring(elementIndex + elementText.length(), to).trim();
                int overlap = prefix.length() + elementText.length() + postfix.length() - 50;
                if (overlap > 0) {
                    int stripFromPrefix = Math.min(overlap / 2, prefix.length());
                    prefix = ".." + prefix.substring(stripFromPrefix);
                    int stripFromPostfix = Math.min(overlap - stripFromPrefix, postfix.length());
                    postfix = postfix.substring(0, postfix.length() - stripFromPostfix) + "..";
                }
            }
            b.append("<font color=");
            b.append(AlternativeLocationImpl.hexColorCode(SELECTOR_COLOR));
            b.append(">");
            b.append(prefix);
            b.append(' ');
            b.append("<b>");
            b.append(elementText);
            b.append("</b>");
            b.append(' ');
            b.append(postfix);
            b.append("</font> in ");
            FileObject file = this.location.getFileObject();
            FileObject pathRoot = ProjectWebRootQuery.getWebRoot((FileObject)file);
            String path = null;
            String resolveTo = null;
            if (file != null) {
                Project project;
                if (pathRoot != null) {
                    path = FileUtil.getRelativePath((FileObject)pathRoot, (FileObject)file);
                }
                if (path == null && (project = FileOwnerQuery.getOwner((FileObject)file)) != null && (path = FileUtil.getRelativePath((FileObject)(pathRoot = project.getProjectDirectory()), (FileObject)file)) != null) {
                    resolveTo = "${project.home}/";
                }
                if (path == null) {
                    path = file.getPath();
                }
            }
            if (resolveTo != null) {
                b.append("<i>");
                b.append(resolveTo);
                b.append("</i>");
            }
            b.append(path == null ? "???" : path);
            int lineOffset = this.entryHandle.entry().getLineOffset();
            if (lineOffset != -1) {
                b.append(":");
                b.append(lineOffset + 1);
            }
            if (!this.entryHandle.isRelatedEntry()) {
                b.append(" <font color=ff0000>(");
                b.append(NbBundle.getMessage(HtmlDeclarationFinder.class, (String)"MSG_Unrelated"));
                b.append(")</font>");
            }
            return b.toString();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            return AlternativeLocationImpl.getComparableString(this).compareTo(AlternativeLocationImpl.getComparableString(o));
        }

        private static String getComparableString(DeclarationFinder.AlternativeLocation loc) {
            FileObject file = loc.getLocation().getFileObject();
            return loc.getLocation().getOffset() + (file == null ? "???" : file.getPath());
        }
    }

    private abstract class AttributeValueAction<T> {
        private final TokenHierarchy hi;
        private final TokenSequence<HTMLTokenId> ts;
        protected String tagName;
        protected String attrName;
        protected String unquotedValue;
        protected OffsetRange valueRange;

        public AttributeValueAction(TokenHierarchy hi, TokenSequence<HTMLTokenId> ts) {
            this.hi = hi;
            this.ts = ts;
        }

        public abstract T resolve();

        public T run() {
            this.parseSquence();
            return this.resolve();
        }

        private void parseSquence() {
            int quotesDiff = WebUtils.isValueQuoted((CharSequence)this.ts.token().text().toString()) ? 1 : 0;
            this.unquotedValue = WebUtils.unquotedValue((CharSequence)this.ts.token().text().toString());
            Token token = this.ts.token();
            List tokenParts = token.joinedParts();
            if (tokenParts == null) {
                this.valueRange = new OffsetRange(this.ts.offset() + quotesDiff, this.ts.offset() + this.ts.token().length() - quotesDiff);
            } else {
                Token first = (Token)tokenParts.get(0);
                Token last = (Token)tokenParts.get(tokenParts.size() - 1);
                this.valueRange = new OffsetRange(first.offset(this.hi), last.offset(this.hi) + last.length());
            }
            while (this.ts.movePrevious()) {
                HTMLTokenId id = (HTMLTokenId)this.ts.token().id();
                if (id == HTMLTokenId.ARGUMENT && this.attrName == null) {
                    this.attrName = this.ts.token().text().toString();
                    continue;
                }
                if (id == HTMLTokenId.TAG_OPEN) {
                    this.tagName = this.ts.token().text().toString();
                    break;
                }
                if (id != HTMLTokenId.TAG_OPEN_SYMBOL && id != HTMLTokenId.TAG_CLOSE_SYMBOL && id != HTMLTokenId.TEXT) continue;
                break;
            }
        }
    }

    private static final class DocumentMimeTypeCacheUpdateTask
    implements Runnable {
        private final Document document;

        public DocumentMimeTypeCacheUpdateTask(Document document) {
            this.document = document;
        }

        @Override
        public void run() {
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)this.document)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        HtmlParserResult result;
                        ResultIterator htmlRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                        if (htmlRi != null && (result = (HtmlParserResult)htmlRi.getParserResult()) != null) {
                            String sourceMimetype = WebPageMetadata.getContentMimeType((Parser.Result)result, (boolean)true);
                            DOC_TO_WEB_MIMETYPE_CACHE.put(document, sourceMimetype);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

