/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.completion;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.latte.completion.LatteCompletionContext;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;
import org.netbeans.modules.php.latte.parser.LatteParserResult;
import org.netbeans.modules.php.latte.utils.LatteLexerUtils;

public final class LatteCompletionContextFinder {
    private static final List<Object[]> FILTER_TOKEN_CHAINS = Arrays.asList({ValuedTokenId.HELPER_TOKEN}, {ValuedTokenId.HELPER_TOKEN, LatteMarkupTokenId.T_SYMBOL});
    private static final List<Object[]> ITERATOR_ITEMS_TOKEN_CHAINS = Arrays.asList({ValuedTokenId.ITERATOR_TOKEN, ValuedTokenId.OBJECT_ACCESS_TOKEN}, {ValuedTokenId.ITERATOR_TOKEN, ValuedTokenId.OBJECT_ACCESS_TOKEN, LatteMarkupTokenId.T_SYMBOL});
    private static final List<Object[]> VARIABLE_TOKEN_CHAINS = Arrays.asList({ValuedTokenId.VARIABLE_TOKEN}, {LatteMarkupTokenId.T_VARIABLE});
    private static final List<Object[]> END_MACRO_TOKEN_CHAINS = Arrays.asList({LatteMarkupTokenId.T_MACRO_END}, {LatteMarkupTokenId.T_MACRO_END, LatteMarkupTokenId.T_SYMBOL});
    private static final List<Object[]> CONTROL_MACRO_TOKEN_CHAINS = Arrays.asList({LatteMarkupTokenId.T_MACRO_START}, {LatteMarkupTokenId.T_MACRO_START, LatteMarkupTokenId.T_WHITESPACE}, {LatteMarkupTokenId.T_MACRO_START, LatteMarkupTokenId.T_WHITESPACE, LatteMarkupTokenId.T_SYMBOL});

    private LatteCompletionContextFinder() {
    }

    public static LatteCompletionContext find(LatteParserResult parserResult, int caretOffset) {
        LatteCompletionContext result = LatteCompletionContext.NONE;
        TokenSequence<? extends LatteMarkupTokenId> ts = LatteLexerUtils.getLatteMarkupTokenSequence(parserResult.getSnapshot(), caretOffset);
        if (ts != null) {
            ts.move(caretOffset);
            if (ts.moveNext() || ts.movePrevious()) {
                result = LatteCompletionContextFinder.findContext(ts);
            }
        } else {
            TokenSequence<LatteTopTokenId> tts = LatteLexerUtils.getTokenSequence(parserResult.getSnapshot().getTokenHierarchy(), caretOffset, LatteTopTokenId.language());
            if (tts != null) {
                result = LatteCompletionContext.EMPTY_DELIMITERS;
            }
        }
        return result;
    }

    private static LatteCompletionContext findContext(TokenSequence<? extends LatteMarkupTokenId> ts) {
        Token token;
        LatteCompletionContext result = LatteCompletionContext.ALL;
        while ((token = ts.token()) != null) {
            LatteMarkupTokenId tokenId = (LatteMarkupTokenId)token.id();
            if (LatteCompletionContextFinder.acceptTokenChains(ts, FILTER_TOKEN_CHAINS, false)) {
                result = LatteCompletionContext.HELPER;
                break;
            }
            if (LatteCompletionContextFinder.acceptTokenChains(ts, ITERATOR_ITEMS_TOKEN_CHAINS, false)) {
                result = LatteCompletionContext.ITERATOR_ITEM;
                break;
            }
            if (LatteCompletionContextFinder.acceptTokenChains(ts, VARIABLE_TOKEN_CHAINS, false)) {
                result = LatteCompletionContext.VARIABLE;
                break;
            }
            if (LatteCompletionContextFinder.acceptTokenChains(ts, END_MACRO_TOKEN_CHAINS, false)) {
                result = LatteCompletionContext.END_MACRO;
                break;
            }
            if (LatteCompletionContextFinder.acceptTokenChains(ts, CONTROL_MACRO_TOKEN_CHAINS, false)) {
                result = LatteCompletionContext.CONTROL_MACRO;
                break;
            }
            if (LatteMarkupTokenId.T_SYMBOL.equals((Object)tokenId) || LatteMarkupTokenId.T_MACRO_START.equals((Object)tokenId)) {
                result = LatteCompletionContext.MACRO;
                break;
            }
            if (ts.movePrevious()) continue;
        }
        return result;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        boolean result = false;
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!LatteCompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int originalPosition = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenId = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenId instanceof LatteMarkupTokenId) {
                if (tokenSequence.token().id() == tokenId) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            if (tokenId instanceof ValuedTokenId) {
                ValuedTokenId valuedToken = (ValuedTokenId)((Object)tokenId);
                Token token = tokenSequence.token();
                if (token != null && valuedToken.getId().equals(token.id()) && token.text().equals(valuedToken.getValue())) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenId.getClass().getName();
        }
        tokenSequence.move(originalPosition);
        tokenSequence.moveNext();
        return accept;
    }

    private static enum ValuedTokenId {
        HELPER_TOKEN(LatteMarkupTokenId.T_CHAR, "|"),
        ITERATOR_TOKEN(LatteMarkupTokenId.T_VARIABLE, "$iterator"),
        OBJECT_ACCESS_TOKEN(LatteMarkupTokenId.T_CHAR, "->"),
        VARIABLE_TOKEN(LatteMarkupTokenId.T_CHAR, "$");

        private final LatteMarkupTokenId id;
        private final String value;

        private ValuedTokenId(LatteMarkupTokenId id, String value) {
            this.id = id;
            this.value = value;
        }

        public LatteMarkupTokenId getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }
    }
}

