/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ScanUtils;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.lsp.CallHierarchyEntry;
import org.netbeans.api.lsp.Range;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTasks;
import org.netbeans.modules.refactoring.java.callhierarchy.CallOccurrence;
import org.netbeans.spi.lsp.CallHierarchyProvider;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class LspCallHierarchyProvider
implements CallHierarchyProvider {
    private static final Logger LOG = Logger.getLogger(LspCallHierarchyProvider.class.getName());
    private static final RequestProcessor HIERARCHY_RP = new RequestProcessor();
    private static final String CUSTOM_DATA_SEPARATOR = "##";

    private static TreePath findEnclosingMethorOrInvocation(CompilationInfo ci, TreePath tp) {
        boolean immediateBody = false;
        while (tp != null && tp.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            switch (tp.getLeaf().getKind()) {
                case METHOD: 
                case METHOD_INVOCATION: {
                    return tp;
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return null;
                }
                case BLOCK: {
                    if (immediateBody) {
                        return null;
                    }
                    immediateBody = true;
                    break;
                }
                case NEW_CLASS: {
                    return tp;
                }
                default: {
                    if (tp.getLeaf() instanceof StatementTree) {
                        return null;
                    }
                    immediateBody = false;
                }
            }
            tp = tp.getParentPath();
        }
        return null;
    }

    public CompletableFuture<List<CallHierarchyEntry>> findCallOrigin(Document doc, final int offset) {
        CompletableFuture<List<CallHierarchyEntry>> res = new CompletableFuture<List<CallHierarchyEntry>>();
        HIERARCHY_RP.post(() -> {
            try {
                class OriginT
                extends UserTask {
                    private final CompletableFuture<List<CallHierarchyEntry>> control;
                    final /* synthetic */ LspCallHierarchyProvider this$0;

                    public OriginT(CompletableFuture<List<CallHierarchyEntry>> control) {
                        this.this$0 = this$0;
                        this.control = control;
                    }

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result r = resultIterator.getParserResult(offset);
                        if ("text/x-java".equals(r.getSnapshot().getMimeType())) {
                            CompilationController ci = CompilationController.get((Parser.Result)r);
                            if (ci == null || r.getSnapshot().getSource().getFileObject() == null) {
                                this.control.complete(null);
                                return;
                            }
                            ci.toPhase(JavaSource.Phase.PARSED);
                            TreePath tp = ci.getTreeUtilities().pathFor(offset);
                            if (tp == null) {
                                this.control.complete(null);
                                return;
                            }
                            TreePath origin = LspCallHierarchyProvider.findEnclosingMethorOrInvocation((CompilationInfo)ci, tp);
                            if (origin == null) {
                                this.control.complete(null);
                                return;
                            }
                            Element e = ci.getTrees().getElement(origin);
                            if (e == null || e.getKind() != ElementKind.CONSTRUCTOR && e.getKind() != ElementKind.METHOD) {
                                this.control.complete(null);
                                return;
                            }
                            ExecutableElement exec = (ExecutableElement)e;
                            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                                String name = e.getEnclosingElement().getSimpleName().toString();
                            } else {
                                String name = e.getSimpleName().toString();
                            }
                            StructureElement se = ElementHeaders.convertElement((CompilationInfo)ci, (Element)e, (che, t) -> false, (boolean)true);
                            if (se == null) {
                                this.control.complete(null);
                            }
                            CallHierarchyEntry item = new CallHierarchyEntry(se, LspCallHierarchyProvider.signature(e));
                            this.control.complete(Collections.singletonList(item));
                            return;
                        }
                        for (Embedding e : resultIterator.getEmbeddings()) {
                            if (this.control.isDone()) {
                                return;
                            }
                            this.run(resultIterator.getResultIterator(e));
                        }
                    }
                }
                ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new OriginT(this, res));
            }
            catch (ParseException ex) {
                res.completeExceptionally(ex);
            }
        });
        return res;
    }

    private static String signature(Element e) {
        ElementHandle h = ElementHandle.create((Element)e);
        Element parent = e.getEnclosingElement();
        String k = parent == null ? "" : parent.getKind().name();
        String extra = h.getKind().name() + CUSTOM_DATA_SEPARATOR + k + CUSTOM_DATA_SEPARATOR + String.join((CharSequence)CUSTOM_DATA_SEPARATOR, SourceUtils.getJVMSignature((ElementHandle)h));
        return extra;
    }

    public CompletableFuture<List<CallHierarchyEntry.Call>> findIncomingCalls(CallHierarchyEntry callTarget) {
        class T
        extends CallTask {
            public T(CallHierarchyEntry callTarget) {
                super(callTarget, CallHierarchyModel.HierarchyType.CALLER);
            }

            @Override
            protected CallHierarchyEntry.Call createCall(StructureElement se, Call c, String signature) {
                CallHierarchyEntry i = new CallHierarchyEntry(se, signature);
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (CallOccurrence oc : c.getOccurrences()) {
                    PositionBounds pb = oc.getSelectionBounds();
                    ranges.add(new Range(pb.getBegin().getOffset(), pb.getEnd().getOffset()));
                }
                return new CallHierarchyEntry.Call(i, ranges);
            }
        }
        return new T(callTarget).process();
    }

    public CompletableFuture<List<CallHierarchyEntry.Call>> findOutgoingCalls(CallHierarchyEntry callSource) {
        class T
        extends CallTask {
            public T(CallHierarchyEntry callTarget) {
                super(callTarget, CallHierarchyModel.HierarchyType.CALLEE);
            }

            @Override
            protected CallHierarchyEntry.Call createCall(StructureElement se, Call c, String signature) {
                CallHierarchyEntry i = new CallHierarchyEntry(se, signature);
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (CallOccurrence oc : c.getOccurrences()) {
                    PositionBounds pb = oc.getSelectionBounds();
                    ranges.add(new Range(pb.getBegin().getOffset(), pb.getEnd().getOffset()));
                }
                return new CallHierarchyEntry.Call(i, ranges);
            }
        }
        return new T(callSource).process();
    }

    static abstract class CallTask
    implements Task<CompilationController>,
    Cancellable {
        final CallHierarchyModel.HierarchyType type;
        final CancellableF<List<CallHierarchyEntry.Call>> res = new CancellableF();
        final CallHierarchyEntry callTarget;
        final AtomicBoolean cancelled = new AtomicBoolean();
        final FileObject fo;
        protected volatile CompletableFuture toCancel;

        public CallTask(CallHierarchyEntry callTarget, CallHierarchyModel.HierarchyType type) {
            this.callTarget = callTarget;
            this.type = type;
            this.fo = callTarget.getElement().getFile();
            this.res.c = this;
        }

        public boolean cancel() {
            CompletableFuture tc = this.toCancel;
            return this.cancelled.getAndSet(true) && (tc == null || tc.cancel(true));
        }

        public void run(CompilationController parameter) throws Exception {
            ElementHandle typeHandle;
            ElementKind targetKind;
            if (this.callTarget.getCustomData() == null) {
                this.res.complete(null);
                return;
            }
            String[] data = this.callTarget.getCustomData().split(LspCallHierarchyProvider.CUSTOM_DATA_SEPARATOR);
            if (data.length < 3) {
                this.res.complete(null);
                return;
            }
            if (data[1].equals("")) {
                this.res.complete(null);
                return;
            }
            try {
                targetKind = ElementKind.valueOf(data[1]);
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.SEVERE, "Unexpected call entry kind: {0}", data[1]);
                this.res.complete(null);
                return;
            }
            try {
                typeHandle = ElementHandle.createTypeElementHandle((ElementKind)targetKind, (String)data[2]);
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.SEVERE, "Could not convert signature {0} to Element", this.callTarget.getCustomData());
                LOG.log(Level.SEVERE, "Exception thrown:", ex);
                this.res.complete(null);
                return;
            }
            int s = this.callTarget.getElement().getSelectionStartOffset();
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TreePath p = parameter.getTreeUtilities().pathFor(s);
            TypeElement typeEl = (TypeElement)typeHandle.resolve((CompilationInfo)parameter);
            ExecutableElement e = this.callTarget.getElement().getKind() == StructureElement.Kind.Method ? (ExecutableElement)ElementFilter.methodsIn(typeEl.getEnclosedElements()).stream().filter(m -> this.callTarget.getCustomData().equals(LspCallHierarchyProvider.signature(m))).findFirst().orElse(null) : (ExecutableElement)ElementFilter.constructorsIn(typeEl.getEnclosedElements()).stream().filter(m -> this.callTarget.getCustomData().equals(LspCallHierarchyProvider.signature(m))).findFirst().orElse(null);
            if (e == null || e.getKind() != ElementKind.METHOD && e.getKind() != ElementKind.CONSTRUCTOR) {
                this.res.complete(null);
                return;
            }
            TreePathHandle tph = TreePathHandle.create((Element)e, (CompilationInfo)parameter);
            if (tph == null) {
                this.res.complete(null);
                return;
            }
            CallHierarchyTasks.RootResolver rr = new CallHierarchyTasks.RootResolver(tph, this.type == CallHierarchyModel.HierarchyType.CALLER, true);
            rr.run(parameter);
            CallHierarchyModel m2 = CallHierarchyModel.create(tph, EnumSet.of(CallHierarchyModel.Scope.ALL, CallHierarchyModel.Scope.BASE), this.type);
            m2.replaceRoot(rr.getRoot());
            Call rootCall = m2.getRoot();
            if (rootCall == null) {
                this.res.complete(null);
                return;
            }
            m2.computeCalls(m2.getRoot(), () -> {
                JavaSource js = JavaSource.forFileObject((FileObject)this.fo);
                if (js == null) {
                    this.res.complete(null);
                    return;
                }
                try {
                    js.runUserActionTask(nested -> this.processComputedCall((CompilationController)nested, rootCall), true);
                }
                catch (IOException ex) {
                    this.res.completeExceptionally(ex);
                }
            });
        }

        protected abstract CallHierarchyEntry.Call createCall(StructureElement var1, Call var2, String var3);

        protected CompletableFuture<List<CallHierarchyEntry.Call>> processAsync(CompilationInfo info, List<Call> refs, List<CallHierarchyEntry.Call> calls) {
            ArrayList<CompletableFuture> delayed = new ArrayList<CompletableFuture>();
            ArrayList<String> signatures = new ArrayList<String>();
            ArrayList<Call> delayedRefs = new ArrayList<Call>();
            for (Call c : refs) {
                TreePathHandle targetH = c.selection;
                Element target = targetH.getElementHandle().resolve(info);
                CompletableFuture elementFuture = ElementHeaders.resolveStructureElement((CompilationInfo)info, (Element)target, (boolean)true);
                if (elementFuture.isDone()) {
                    try {
                        StructureElement sel = (StructureElement)elementFuture.get();
                        if (sel == null) continue;
                        calls.add(this.createCall(sel, c, LspCallHierarchyProvider.signature(target)));
                        continue;
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof CancellationException) {
                            throw (CancellationException)cause;
                        }
                        throw new IllegalStateException(ex);
                    }
                    catch (InterruptedException ex) {
                        CancellationException t = new CancellationException();
                        t.initCause(ex);
                        throw t;
                    }
                }
                signatures.add(LspCallHierarchyProvider.signature(target));
                delayedRefs.add(c);
                delayed.add(elementFuture);
            }
            if (delayed.isEmpty()) {
                return CompletableFuture.completedFuture(calls);
            }
            return CompletableFuture.allOf((CompletableFuture[])delayed.stream().filter(Objects::nonNull).toArray(CompletableFuture[]::new)).thenApply(x -> {
                int index = 0;
                for (CompletableFuture f : delayed) {
                    StructureElement se;
                    if (f != null && (se = (StructureElement)f.getNow(null)) != null) {
                        calls.add(this.createCall(se, (Call)refs.get(index), (String)signatures.get(index)));
                    }
                    ++index;
                }
                return calls;
            });
        }

        public CompletableFuture<List<CallHierarchyEntry.Call>> process() {
            JavaSource js = JavaSource.forFileObject((FileObject)this.fo);
            if (js == null) {
                return null;
            }
            HIERARCHY_RP.post(() -> {
                try {
                    ScanUtils.waitUserActionTask((JavaSource)js, (Task)this);
                }
                catch (IOException | RuntimeException ex) {
                    this.res.completeExceptionally(ex);
                }
            });
            return this.toCancel != null ? this.toCancel : this.res;
        }

        protected void processComputedCall(CompilationController info, Call rootCall) throws IOException {
            ArrayList<CallHierarchyEntry.Call> calls = new ArrayList<CallHierarchyEntry.Call>();
            List<Call> refs = rootCall.getReferences();
            if (this.cancelled.get()) {
                return;
            }
            info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            this.toCancel = this.processAsync((CompilationInfo)info, refs, calls);
            this.toCancel.handle((r, ex) -> {
                if (ex != null) {
                    this.res.completeExceptionally((Throwable)ex);
                } else {
                    this.res.complete(calls);
                }
                return null;
            });
        }
    }

    private static class CancellableF<T>
    extends CompletableFuture<T> {
        private volatile Cancellable c;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Cancellable c2 = this.c;
            if (mayInterruptIfRunning && c2 != null) {
                return c2.cancel();
            }
            return false;
        }
    }
}

