/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.RequestProcessor;

public class ServiceModel {
    public static final int STATUS_OK = 0;
    public static final int STATUS_NOT_SERVICE = 1;
    public static final int STATUS_INCORRECT_SERVICE = 2;
    String serviceName;
    String portName;
    String name;
    String endpointInterface;
    String wsdlLocation;
    String targetNamespace;
    int status = 0;
    List<MethodModel> operations;
    private FileObject implementationClass;
    private FileChangeListener fcl;
    private List<ServiceChangeListener> serviceChangeListeners = new ArrayList<ServiceChangeListener>();
    private static final RequestProcessor FILE_CHANGE_RP = new RequestProcessor(ServiceModel.class);
    private boolean changeSource = true;

    private ServiceModel(FileObject implementationClass, boolean populate) {
        this.implementationClass = implementationClass;
        if (populate) {
            assert (implementationClass != null);
            this.populateModel();
        }
    }

    public static ServiceModel getServiceModel(FileObject implClass) {
        return new ServiceModel(implClass, true);
    }

    static ServiceModel getServiceModel() {
        return new ServiceModel(null, false);
    }

    public FileObject getImplementationClass() {
        return this.implementationClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null && !this.name.equals(name)) {
            if (this.changeSource) {
                JaxWsUtils.setWebServiceAttrValue((FileObject)this.implementationClass, (String)"name", (String)name);
            }
            String oldName = this.name;
            this.name = name == null ? this.implementationClass.getName() : name;
            this.firePropertyChanged("name", oldName, name);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (this.serviceName != null && !this.serviceName.equals(serviceName)) {
            if (this.changeSource) {
                JaxWsUtils.setWebServiceAttrValue((FileObject)this.implementationClass, (String)"serviceName", (String)serviceName);
            }
            String oldName = this.serviceName;
            this.serviceName = serviceName == null ? this.implementationClass.getName() + "Service" : serviceName;
            this.firePropertyChanged("serviceName", oldName, this.serviceName);
        }
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        if (this.portName != null && !this.portName.equals(portName)) {
            if (this.changeSource) {
                JaxWsUtils.setWebServiceAttrValue((FileObject)this.implementationClass, (String)"portName", (String)portName);
            }
            String oldName = this.portName;
            this.portName = portName == null ? this.serviceName + "Port" : portName;
            this.firePropertyChanged("portName", oldName, portName);
        }
    }

    public String getEndpointInterface() {
        return this.endpointInterface;
    }

    void setEndpointInterface(String endpointInterface) {
        if (this.endpointInterface == null) {
            if (endpointInterface != null) {
                this.endpointInterface = endpointInterface;
                this.firePropertyChanged("endpointInterface", null, endpointInterface);
            }
        } else if (!this.endpointInterface.equals(endpointInterface)) {
            String oldName = this.endpointInterface;
            this.endpointInterface = endpointInterface;
            this.firePropertyChanged("endpointInterface", oldName, endpointInterface);
        }
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    void setWsdlLocation(String wsdlLocation) {
        if (this.wsdlLocation == null) {
            if (wsdlLocation != null) {
                this.wsdlLocation = wsdlLocation;
                this.firePropertyChanged("wsdlLocation", null, wsdlLocation);
            }
        } else if (!this.wsdlLocation.equals(wsdlLocation)) {
            String oldName = this.wsdlLocation;
            this.wsdlLocation = wsdlLocation;
            this.firePropertyChanged("wsdlLocation", oldName, wsdlLocation);
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        if (this.targetNamespace == null) {
            if (targetNamespace != null) {
                this.targetNamespace = targetNamespace;
                this.firePropertyChanged("targetNamespace", null, targetNamespace);
            }
        } else if (!this.targetNamespace.equals(targetNamespace)) {
            String oldName = this.targetNamespace;
            this.targetNamespace = targetNamespace;
            this.firePropertyChanged("targetNamespace", oldName, targetNamespace);
        }
    }

    public List<MethodModel> getOperations() {
        return this.operations;
    }

    void addOperation(MethodModel operation) {
        this.operations.add(operation);
        this.fireOperationAdded(operation);
    }

    void removeOperation(MethodModel operation) {
        this.operations.remove(operation);
        this.fireOperationRemoved(operation);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        if (this.status != status) {
            int oldStatus = this.status;
            this.status = status;
            this.firePropertyChanged("status", String.valueOf(oldStatus), String.valueOf(status));
        }
        this.status = status;
    }

    void setOperations(List<MethodModel> operations) {
        if (this.operations == null) {
            this.operations = new ArrayList<MethodModel>();
            if (operations != null) {
                for (MethodModel op : operations) {
                    this.addOperation(op);
                }
            }
        } else {
            HashMap<String, MethodModel> op1 = new HashMap<String, MethodModel>();
            HashMap<String, MethodModel> op2 = new HashMap<String, MethodModel>();
            for (MethodModel model : this.operations) {
                op1.put(model.getOperationName(), model);
            }
            if (operations != null) {
                for (MethodModel model : operations) {
                    op2.put(model.getOperationName(), model);
                }
            }
            HashSet<String> commonOperations = new HashSet<String>();
            Set keys1 = op1.keySet();
            Set keys2 = op2.keySet();
            for (String key : keys1) {
                if (!keys2.contains(key)) continue;
                commonOperations.add(key);
            }
            for (String key : commonOperations) {
                MethodModel method1 = (MethodModel)op1.get(key);
                MethodModel method2 = (MethodModel)op2.get(key);
                op1.remove(key);
                op2.remove(key);
                if (method1.isEqualTo(method2)) continue;
                this.operations.set(this.operations.indexOf(method1), method2);
                this.fireOperationChanged(method1, method2);
            }
            op1.values().forEach(this::removeOperation);
            op2.values().forEach(this::addOperation);
        }
    }

    public synchronized void addServiceChangeListener(ServiceChangeListener pcl) {
        if (this.serviceChangeListeners.size() == 0) {
            this.fcl = new AnnotationChangeListener();
            this.implementationClass.addFileChangeListener(this.fcl);
            if (this.getEndpointInterface() != null) {
                String endpoint = this.getEndpointInterface();
                ClassPath sourceCP = ClassPath.getClassPath((FileObject)this.implementationClass, (String)"classpath/source");
                FileObject endpointFo = sourceCP.findResource(endpoint.replace('.', '/') + ".java");
                if (endpointFo != null) {
                    endpointFo.addFileChangeListener(this.fcl);
                }
            }
        }
        this.serviceChangeListeners.add(pcl);
    }

    public synchronized void removeServiceChangeListener(ServiceChangeListener pcl) {
        this.serviceChangeListeners.remove(pcl);
        if (this.serviceChangeListeners.size() == 0) {
            this.implementationClass.removeFileChangeListener(this.fcl);
            if (this.getEndpointInterface() != null) {
                String endpoint = this.getEndpointInterface();
                ClassPath sourceCP = ClassPath.getClassPath((FileObject)this.implementationClass, (String)"classpath/source");
                FileObject endpointFo = sourceCP.findResource(endpoint.replace('.', '/') + ".java");
                if (endpointFo != null) {
                    endpointFo.removeFileChangeListener(this.fcl);
                }
            }
        }
    }

    void firePropertyChanged(String propName, String oldValue, String newValue) {
        for (ServiceChangeListener listener : this.serviceChangeListeners) {
            listener.propertyChanged(propName, oldValue, newValue);
        }
    }

    void fireOperationAdded(MethodModel method) {
        for (ServiceChangeListener listener : this.serviceChangeListeners) {
            listener.operationAdded(method);
        }
    }

    void fireOperationRemoved(MethodModel method) {
        for (ServiceChangeListener listener : this.serviceChangeListeners) {
            listener.operationRemoved(method);
        }
    }

    void fireOperationChanged(MethodModel oldMethod, MethodModel newMethod) {
        for (ServiceChangeListener listener : this.serviceChangeListeners) {
            listener.operationChanged(oldMethod, newMethod);
        }
    }

    private void populateModel() {
        ServiceModel model = Utils.populateModel(this.implementationClass);
        if (model == null) {
            return;
        }
        this.serviceName = model.serviceName;
        this.portName = model.portName;
        this.name = model.name;
        this.endpointInterface = model.endpointInterface;
        this.wsdlLocation = model.wsdlLocation;
        this.targetNamespace = model.targetNamespace;
        this.status = model.status;
        this.operations = model.operations;
    }

    void mergeModel(ServiceModel model2) {
        if (model2.status == 2 || model2.status == 1) {
            if (this.operations != null && (model2.operations == null || model2.operations.size() == 0)) {
                int size = this.operations.size();
                for (int i = size - 1; i >= 0; --i) {
                    this.removeOperation(this.operations.get(i));
                }
            }
        } else {
            this.changeSource = false;
            this.setStatus(model2.status);
            this.setName(model2.name);
            this.setServiceName(model2.serviceName);
            this.setPortName(model2.portName);
            this.setEndpointInterface(model2.endpointInterface);
            this.setWsdlLocation(model2.wsdlLocation);
            this.setTargetNamespace(model2.targetNamespace);
            this.setOperations(model2.operations);
            this.changeSource = true;
        }
    }

    private class AnnotationChangeListener
    extends FileChangeAdapter {
        private AnnotationChangeListener() {
        }

        public void fileChanged(final FileEvent fe) {
            Runnable runnable = new Runnable(){
                final /* synthetic */ AnnotationChangeListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    FileObject implClass = fe.getFile();
                    ServiceModel newModel = new ServiceModel(implClass, true);
                    this.this$1.ServiceModel.this.mergeModel(newModel);
                }
            };
            FILE_CHANGE_RP.post(runnable);
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }
    }
}

