/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MultiTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String DEFAULT_NEW_PACKAGE_NAME = NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultNewPackageName");
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_NewJavaClassPrefix");
    private static final String NEW_CLASS_SUFFIX = NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_NewJavaClassSuffix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private Project project;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int type;
    private SourceGroup[] groups;
    private boolean ignoreRootCombo;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;
    private RequestProcessor.Task updatePackagesTask = null;
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_PleaseWait")});

    public MultiTargetChooserPanelGUI(Project p, SourceGroup[] groups, Component bottomPanel, int type) {
        Component packageEditor;
        this.type = type;
        this.project = p;
        this.groups = groups;
        this.initComponents();
        if (type == 1) {
            this.packageComboBox.setVisible(false);
            this.packageLabel.setVisible(false);
            Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_Label"));
            this.documentNameTextField.getDocument().addDocumentListener(this);
        } else if (type == 2) {
            this.documentNameTextField.setEditable(false);
        } else {
            this.packageComboBox.getEditor().addActionListener(this);
            this.documentNameTextField.getDocument().addDocumentListener(this);
        }
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        if ((packageEditor = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(MultiTargetChooserPanelGUI.class).getString("LBL_JavaTargetChooserPanelGUI_Name"));
    }

    @Override
    public void addNotify() {
        Dimension panel2Size = this.jPanel2.getPreferredSize();
        Dimension bottomPanelSize = this.bottomPanelContainer.getPreferredSize();
        Dimension splitterSize = this.targetSeparator.getPreferredSize();
        int vmax = panel2Size.height + bottomPanelSize.height + splitterSize.height + 12;
        if (vmax > MultiTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(MultiTargetChooserPanelGUI.PREF_DIM.width, vmax));
        }
        super.addNotify();
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (template != null);
        String displayName = null;
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        SourceGroup preselectedGroup = this.getPreselectedGroup(preselectedFolder);
        this.ignoreRootCombo = true;
        this.rootComboBox.setSelectedItem(preselectedGroup);
        this.ignoreRootCombo = false;
        Object preselectedPackage = this.getPreselectedPackage(preselectedGroup, preselectedFolder, this.packageComboBox.getModel());
        if (this.type == 1) {
            String docName = preselectedPackage == null || preselectedPackage.toString().length() == 0 ? DEFAULT_NEW_PACKAGE_NAME : preselectedPackage.toString() + "." + DEFAULT_NEW_PACKAGE_NAME;
            this.documentNameTextField.setText(docName);
            int docNameLen = docName.length();
            int defPackageNameLen = DEFAULT_NEW_PACKAGE_NAME.length();
            this.documentNameTextField.setSelectionEnd(docNameLen - 1);
            this.documentNameTextField.setSelectionStart(docNameLen - defPackageNameLen);
        } else {
            if (preselectedPackage != null) {
                this.packageComboBox.getEditor().setItem(preselectedPackage);
            }
            if (template != null && this.documentNameTextField.getText().trim().length() == 0) {
                if (this.type == 2) {
                    this.documentNameTextField.setText(template.getName());
                } else {
                    this.documentNameTextField.setText(NEW_CLASS_PREFIX + template.getName() + NEW_CLASS_SUFFIX);
                    this.documentNameTextField.selectAll();
                }
            }
            this.updatePackages(false);
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        this.updateText();
    }

    public FileObject getRootFolder() {
        SourceGroup sourceGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        return sourceGroup == null ? null : sourceGroup.getRootFolder();
    }

    public String getPackageFileName() {
        if (this.type == 1) {
            return "";
        }
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    String getPackageName() {
        if (this.type == 1) {
            return "";
        }
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_projectTextField"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_rootComboBox"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(MultiTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_packageComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_JavaTargetChooserPanelGUI"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rootComboBox == e.getSource()) {
            if (!this.ignoreRootCombo && this.type != 1) {
                this.updatePackages(true);
            }
            this.updateText();
        } else if (this.packageComboBox == e.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updatePackages(final boolean clean) {
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            private ComboBoxModel model;
            final /* synthetic */ MultiTargetChooserPanelGUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SourceGroup sourceGroup = (SourceGroup)this.this$0.rootComboBox.getSelectedItem();
                    if (sourceGroup != null) {
                        this.model = PackageView.createListView((SourceGroup)sourceGroup);
                        SwingUtilities.invokeLater(this);
                    }
                } else {
                    if (!clean) {
                        this.model.setSelectedItem(this.this$0.packageComboBox.getEditor().getItem());
                    }
                    this.this$0.packageComboBox.setModel(this.model);
                }
            }
        });
    }

    private void updateText() {
    }

    private SourceGroup getPreselectedGroup(FileObject folder) {
        for (int i = 0; folder != null && i < this.groups.length; ++i) {
            FileObject root = this.groups[i].getRootFolder();
            if (!root.equals(folder) && !FileUtil.isParentOf((FileObject)root, (FileObject)folder)) continue;
            return this.groups[i];
        }
        if (this.groups == null || this.groups.length == 0) {
            return null;
        }
        return this.groups[0];
    }

    private Object getPreselectedPackage(SourceGroup group, FileObject folder, ListModel model) {
        if (folder == null || group == null) {
            return null;
        }
        FileObject root = group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        if (relPath == null) {
            return null;
        }
        String name = relPath.replace('/', '.');
        return name;
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SourceGroup g = (SourceGroup)value;
            if (g != null) {
                super.getListCellRendererComponent((JList<?>)list, g.getDisplayName(), index, isSelected, cellHasFocus);
                this.setIcon(g.getIcon(false));
            }
            return this;
        }
    }
}

