/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.util.logging.Logger;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionInternal;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionLocal;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionRemote;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionScript;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionSelenium;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionTest;
import org.netbeans.modules.php.project.ui.actions.support.DebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.util.Lookup;

public abstract class ConfigAction {
    protected static final Logger LOGGER = Logger.getLogger(ConfigAction.class.getName());
    protected final PhpProject project;

    protected ConfigAction(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public static Type convert(PhpProjectProperties.RunAsType runAsType) {
        Type type = null;
        switch (runAsType) {
            case LOCAL: {
                type = Type.LOCAL;
                break;
            }
            case REMOTE: {
                type = Type.REMOTE;
                break;
            }
            case SCRIPT: {
                type = Type.SCRIPT;
                break;
            }
            case INTERNAL: {
                type = Type.INTERNAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)runAsType));
            }
        }
        return type;
    }

    public static ConfigAction get(Type type, PhpProject project) {
        assert (type != null);
        ConfigAction action = null;
        switch (type.ordinal()) {
            case 0: {
                action = new ConfigActionLocal(project);
                break;
            }
            case 1: {
                action = new ConfigActionRemote(project);
                break;
            }
            case 2: {
                action = new ConfigActionScript(project);
                break;
            }
            case 3: {
                action = new ConfigActionInternal(project);
                break;
            }
            case 4: {
                action = new ConfigActionTest(project);
                break;
            }
            case 5: {
                action = new ConfigActionSelenium(project);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
        assert (action != null);
        return action;
    }

    public boolean isRunProjectEnabled() {
        return true;
    }

    public boolean isDebugProjectEnabled() {
        return DebugStarterFactory.getInstance() != null;
    }

    public abstract boolean isProjectValid();

    public abstract boolean isFileValid();

    public abstract boolean isRunFileEnabled(Lookup var1);

    public abstract boolean isDebugFileEnabled(Lookup var1);

    public boolean isRunMethodEnabled(Lookup context) {
        return false;
    }

    public boolean isDebugMethodEnabled(Lookup context) {
        return false;
    }

    public abstract void runProject();

    public abstract void debugProject();

    public abstract void runFile(Lookup var1);

    public abstract void debugFile(Lookup var1);

    public void runMethod(Lookup context) {
        throw new UnsupportedOperationException();
    }

    public void debugMethod(Lookup context) {
        throw new UnsupportedOperationException();
    }

    protected void showCustomizer() {
        PhpProjectUtils.openCustomizerRun(this.project);
    }

    public static enum Type {
        LOCAL,
        REMOTE,
        SCRIPT,
        INTERNAL,
        TEST,
        SELENIUM;

    }
}

