/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.utils.ServerUtils;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;

public class KillTask
extends BasicTask<TaskState> {
    private static final Logger LOGGER = GlassFishLogger.get(StartTask.class);

    public KillTask(GlassfishInstance instance, TaskStateListener ... stateListener) {
        super(instance, stateListener);
        this.taskThread = null;
    }

    @Override
    public TaskState call() {
        this.setTaskThread();
        LOGGER.log(Level.FINEST, "[0] GlassFish server termination task started", this.taskThread.getName());
        Process process = this.instance.getProcess();
        if (process == null) {
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.PROCESS_NOT_EXISTS, "KillTask.call.noProcess", this.instanceName);
        }
        if (!ServerUtils.isProcessRunning(process)) {
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.PROCESS_NOT_RUNNING, "KillTask.call.finished", this.instanceName);
        }
        this.fireOperationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, "KillTask.call.running", this.instanceName);
        TaskState state = this.kill(process);
        this.clearTaskThread();
        return state;
    }

    private TaskState kill(Process process) {
        process.destroy();
        BasicTask.StateChange stateChange = this.waitShutDown();
        if (stateChange != null) {
            return stateChange.fireOperationStateChanged();
        }
        this.instance.setProcess(null);
        return this.fireOperationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "KillTask.kill.completed", this.instanceName);
    }
}

