/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.field.InjectionPointAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.field.ScopedFieldAnalyzer;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;

public class FieldModelAnalyzer
implements ModelAnalyzer {
    private static final List<FieldAnalyzer> ANALYZERS = new LinkedList<FieldAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        VariableElement var = (VariableElement)element;
        if (cancel.get()) {
            return;
        }
        TypeMirror varType = model.getCompilationController().getTypes().asMemberOf((DeclaredType)parent.asType(), var);
        for (FieldAnalyzer analyzer : ANALYZERS) {
            if (cancel.get()) {
                return;
            }
            analyzer.analyze(var, varType, parent, model, cancel, result);
        }
    }

    static {
        ANALYZERS.add(new ScopedFieldAnalyzer());
        ANALYZERS.add(new InjectionPointAnalyzer());
    }

    public static interface FieldAnalyzer {
        public void analyze(VariableElement var1, TypeMirror var2, TypeElement var3, WebBeansModel var4, AtomicBoolean var5, ModelAnalyzer.Result var6);
    }
}

